(*
	Copyright (c) 2000
		Cambridge University Technical Services Limited

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Lesser General Public
	License as published by the Free Software Foundation; either
	version 2.1 of the License, or (at your option) any later version.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Lesser General Public License for more details.
	
	You should have received a copy of the GNU Lesser General Public
	License along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*)


signature XKEYSYMS_SIG = sig

  val XK_VoidSymbol: int ;

(*
 * TTY Functions, cleverly chosen to map to ascii, for convenience of
 * programming, but could have been arbitrary (at the cost of lookup
 * tables in client code.
 *)

  val XK_BackSpace:   int ;
  val XK_Tab:         int ;
  val XK_Linefeed:    int ;
  val XK_Clear:       int ;
  val XK_Return:      int ;
  val XK_Pause:       int ;
  val XK_Scroll_Lock: int ;
  val XK_Escape:      int ;
  val XK_Delete:      int ;


(* International & multi-key character composition *)

  val XK_Multi_key: int ;

(* Japanese keyboard support *)

  val XK_Kanji:             int ;
  val XK_Muhenkan:          int ;
  val XK_Henkan_Mode:       int ;
  val XK_Henkan:            int ;
  val XK_Romaji:            int ;
  val XK_Hiragana:          int ;
  val XK_Katakana:          int ;
  val XK_Hiragana_Katakana: int ;
  val XK_Zenkaku:           int ;
  val XK_Hankaku:           int ;
  val XK_Zenkaku_Hankaku:   int ;
  val XK_Touroku:           int ;
  val XK_Massyo:            int ;
  val XK_Kana_Lock:         int ;
  val XK_Kana_Shift:        int ;
  val XK_Eisu_Shift:        int ;
  val XK_Eisu_toggle:       int ;

(* Cursor control & motion *)

  val XK_Home:  int ;
  val XK_Left:  int ;
  val XK_Up:    int ;
  val XK_Right: int ;
  val XK_Down:  int ;
  val XK_Prior: int ;
  val XK_Next:  int ;
  val XK_End:   int ;
  val XK_Begin: int ;

(* Misc Functions *)

  val XK_Select:        int ;
  val XK_Print:         int ;
  val XK_Execute:       int ;
  val XK_Insert:        int ;
  val XK_Undo:          int ;
  val XK_Redo:          int ;
  val XK_Menu:          int ;
  val XK_Find:          int ;
  val XK_Cancel:        int ;
  val XK_Help:          int ;
  val XK_Break:         int ;
  val XK_Mode_switch:   int ;
  val XK_script_switch: int ;
  val XK_Num_Lock:      int ;

(* Keypad Functions, keypad numbers cleverly chosen to map to ascii *)

  val XK_KP_Space:     int ;
  val XK_KP_Tab:       int ;
  val XK_KP_Enter:     int ;
  val XK_KP_F1:        int ;
  val XK_KP_F2:        int ;
  val XK_KP_F3:        int ;
  val XK_KP_F4:        int ;
  val XK_KP_Equal:     int ;
  val XK_KP_Multiply:  int ;
  val XK_KP_Add:       int ;
  val XK_KP_Separator: int ;
  val XK_KP_Subtract:  int ;
  val XK_KP_Decimal:   int ;
  val XK_KP_Divide:    int ;

  val XK_KP_0: int ;
  val XK_KP_1: int ;
  val XK_KP_2: int ;
  val XK_KP_3: int ;
  val XK_KP_4: int ;
  val XK_KP_5: int ;
  val XK_KP_6: int ;
  val XK_KP_7: int ;
  val XK_KP_8: int ;
  val XK_KP_9: int ;

(*
 * Auxilliary Functions; note the duplicate definitions for left and right
 * function keys;  Sun keyboards and a few other manufactures have such
 * function key groups on the left and/or right sides of the keyboard.
 * We've not found a keyboard with more than 35 function keys total.
 *)

  val XK_F1:  int ;
  val XK_F2:  int ;
  val XK_F3:  int ;
  val XK_F4:  int ;
  val XK_F5:  int ;
  val XK_F6:  int ;
  val XK_F7:  int ;
  val XK_F8:  int ;
  val XK_F9:  int ;
  val XK_F10: int ;
  val XK_F11: int ;
  val XK_L1:  int ;
  val XK_F12: int ;
  val XK_L2:  int ;
  val XK_F13: int ;
  val XK_L3:  int ;
  val XK_F14: int ;
  val XK_L4:  int ;
  val XK_F15: int ;
  val XK_L5:  int ;
  val XK_F16: int ;
  val XK_L6:  int ;
  val XK_F17: int ;
  val XK_L7:  int ;
  val XK_F18: int ;
  val XK_L8:  int ;
  val XK_F19: int ;
  val XK_L9:  int ;
  val XK_F20: int ;
  val XK_L10: int ;
  val XK_F21: int ;
  val XK_R1:  int ;
  val XK_F22: int ;
  val XK_R2:  int ;
  val XK_F23: int ;
  val XK_R3:  int ;
  val XK_F24: int ;
  val XK_R4:  int ;
  val XK_F25: int ;
  val XK_R5:  int ;
  val XK_F26: int ;
  val XK_R6:  int ;
  val XK_F27: int ;
  val XK_R7:  int ;
  val XK_F28: int ;
  val XK_R8:  int ;
  val XK_F29: int ;
  val XK_R9:  int ;
  val XK_F30: int ;
  val XK_R10: int ;
  val XK_F31: int ;
  val XK_R11: int ;
  val XK_F32: int ;
  val XK_R12: int ;
  val XK_R13: int ;
  val XK_F33: int ;
  val XK_F34: int ;
  val XK_R14: int ;
  val XK_F35: int ;
  val XK_R15: int ;

(* Modifiers *)

  val XK_Shift_L:    int ;
  val XK_Shift_R:    int ;
  val XK_Control_L:  int ;
  val XK_Control_R:  int ;
  val XK_Caps_Lock:  int ;
  val XK_Shift_Lock: int ;
  val XK_Meta_L:     int ;
  val XK_Meta_R:     int ;
  val XK_Alt_L:      int ;
  val XK_Alt_R:      int ;
  val XK_Super_L:    int ;
  val XK_Super_R:    int ;
  val XK_Hyper_L:    int ;
  val XK_Hyper_R:    int ;

(* Latin 1 *)

  val XK_space:          int ;
  val XK_exclam:         int ;
  val XK_quotedbl:       int ;
  val XK_numbersign:     int ;
  val XK_dollar:         int ;
  val XK_percent:        int ;
  val XK_ampersand:      int ;
  val XK_apostrophe:     int ;
  val XK_quoteright:     int ;
  val XK_parenleft:      int ;
  val XK_parenright:     int ;
  val XK_asterisk:       int ;
  val XK_plus:           int ;
  val XK_comma:          int ;
  val XK_minus:          int ;
  val XK_period:         int ;
  val XK_slash:          int ;
  val XK_0:              int ;
  val XK_1:              int ;
  val XK_2:              int ;
  val XK_3:              int ;
  val XK_4:              int ;
  val XK_5:              int ;
  val XK_6:              int ;
  val XK_7:              int ;
  val XK_8:              int ;
  val XK_9:              int ;
  val XK_colon:          int ;
  val XK_semicolon:      int ;
  val XK_less:           int ;
  val XK_equal:          int ;
  val XK_greater:        int ;
  val XK_question:       int ;
  val XK_at:             int ;
  val XK_A:              int ;
  val XK_B:              int ;
  val XK_C:              int ;
  val XK_D:              int ;
  val XK_E:              int ;
  val XK_F:              int ;
  val XK_G:              int ;
  val XK_H:              int ;
  val XK_I:              int ;
  val XK_J:              int ;
  val XK_K:              int ;
  val XK_L:              int ;
  val XK_M:              int ;
  val XK_N:              int ;
  val XK_O:              int ;
  val XK_P:              int ;
  val XK_Q:              int ;
  val XK_R:              int ;
  val XK_S:              int ;
  val XK_T:              int ;
  val XK_U:              int ;
  val XK_V:              int ;
  val XK_W:              int ;
  val XK_X:              int ;
  val XK_Y:              int ;
  val XK_Z:              int ;
  val XK_bracketleft:    int ;
  val XK_backslash:      int ;
  val XK_bracketright:   int ;
  val XK_asciicircum:    int ;
  val XK_underscore:     int ;
  val XK_grave:          int ;
  val XK_quoteleft:      int ;
  val XK_a:              int ;
  val XK_b:              int ;
  val XK_c:              int ;
  val XK_d:              int ;
  val XK_e:              int ;
  val XK_f:              int ;
  val XK_g:              int ;
  val XK_h:              int ;
  val XK_i:              int ;
  val XK_j:              int ;
  val XK_k:              int ;
  val XK_l:              int ;
  val XK_m:              int ;
  val XK_n:              int ;
  val XK_o:              int ;
  val XK_p:              int ;
  val XK_q:              int ;
  val XK_r:              int ;
  val XK_s:              int ;
  val XK_t:              int ;
  val XK_u:              int ;
  val XK_v:              int ;
  val XK_w:              int ;
  val XK_x:              int ;
  val XK_y:              int ;
  val XK_z:              int ;
  val XK_braceleft:      int ;
  val XK_bar:            int ;
  val XK_braceright:     int ;
  val XK_asciitilde:     int ;
  val XK_nobreakspace:   int ;
  val XK_exclamdown:     int ;
  val XK_cent:           int ;
  val XK_sterling:       int ;
  val XK_currency:       int ;
  val XK_yen:            int ;
  val XK_brokenbar:      int ;
  val XK_section:        int ;
  val XK_diaeresis:      int ;
  val XK_copyright:      int ;
  val XK_ordfeminine:    int ;
  val XK_guillemotleft:  int ;
  val XK_notsign:        int ;
  val XK_hyphen:         int ;
  val XK_registered:     int ;
  val XK_macron:         int ;
  val XK_degree:         int ;
  val XK_plusminus:      int ;
  val XK_twosuperior:    int ;
  val XK_threesuperior:  int ;
  val XK_acute:          int ;
  val XK_mu:             int ;
  val XK_paragraph:      int ;
  val XK_periodcentered: int ;
  val XK_cedilla:        int ;
  val XK_onesuperior:    int ;
  val XK_masculine:      int ;
  val XK_guillemotright: int ;
  val XK_onequarter:     int ;
  val XK_onehalf:        int ;
  val XK_threequarters:  int ;
  val XK_questiondown:   int ;
  val XK_Agrave:         int ;
  val XK_Aacute:         int ;
  val XK_Acircumflex:    int ;
  val XK_Atilde:         int ;
  val XK_Adiaeresis:     int ;
  val XK_Aring:          int ;
  val XK_AE:             int ;
  val XK_Ccedilla:       int ;
  val XK_Egrave:         int ;
  val XK_Eacute:         int ;
  val XK_Ecircumflex:    int ;
  val XK_Ediaeresis:     int ;
  val XK_Igrave:         int ;
  val XK_Iacute:         int ;
  val XK_Icircumflex:    int ;
  val XK_Idiaeresis:     int ;
  val XK_ETH:            int ;
  val XK_Eth:            int ;
  val XK_Ntilde:         int ;
  val XK_Ograve:         int ;
  val XK_Oacute:         int ;
  val XK_Ocircumflex:    int ;
  val XK_Otilde:         int ;
  val XK_Odiaeresis:     int ;
  val XK_multiply:       int ;
  val XK_Ooblique:       int ;
  val XK_Ugrave:         int ;
  val XK_Uacute:         int ;
  val XK_Ucircumflex:    int ;
  val XK_Udiaeresis:     int ;
  val XK_Yacute:         int ;
  val XK_THORN:          int ;
  val XK_Thorn:          int ;
  val XK_ssharp:         int ;
  val XK_agrave:         int ;
  val XK_aacute:         int ;
  val XK_acircumflex:    int ;
  val XK_atilde:         int ;
  val XK_adiaeresis:     int ;
  val XK_aring:          int ;
  val XK_ae:             int ;
  val XK_ccedilla:       int ;
  val XK_egrave:         int ;
  val XK_eacute:         int ;
  val XK_ecircumflex:    int ;
  val XK_ediaeresis:     int ;
  val XK_igrave:         int ;
  val XK_iacute:         int ;
  val XK_icircumflex:    int ;
  val XK_idiaeresis:     int ;
  val XK_eth:            int ;
  val XK_ntilde:         int ;
  val XK_ograve:         int ;
  val XK_oacute:         int ;
  val XK_ocircumflex:    int ;
  val XK_otilde:         int ;
  val XK_odiaeresis:     int ;
  val XK_division:       int ;
  val XK_oslash:         int ;
  val XK_ugrave:         int ;
  val XK_uacute:         int ;
  val XK_ucircumflex:    int ;
  val XK_udiaeresis:     int ;
  val XK_yacute:         int ;
  val XK_thorn:          int ;
  val XK_ydiaeresis:     int ;

(* Latin 2 *)

  val XK_Aogonek:      int ;
  val XK_breve:        int ;
  val XK_Lstroke:      int ;
  val XK_Lcaron:       int ;
  val XK_Sacute:       int ;
  val XK_Scaron:       int ;
  val XK_Scedilla:     int ;
  val XK_Tcaron:       int ;
  val XK_Zacute:       int ;
  val XK_Zcaron:       int ;
  val XK_Zabovedot:    int ;
  val XK_aogonek:      int ;
  val XK_ogonek:       int ;
  val XK_lstroke:      int ;
  val XK_lcaron:       int ;
  val XK_sacute:       int ;
  val XK_caron:        int ;
  val XK_scaron:       int ;
  val XK_scedilla:     int ;
  val XK_tcaron:       int ;
  val XK_zacute:       int ;
  val XK_doubleacute:  int ;
  val XK_zcaron:       int ;
  val XK_zabovedot:    int ;
  val XK_Racute:       int ;
  val XK_Abreve:       int ;
  val XK_Lacute:       int ;
  val XK_Cacute:       int ;
  val XK_Ccaron:       int ;
  val XK_Eogonek:      int ;
  val XK_Ecaron:       int ;
  val XK_Dcaron:       int ;
  val XK_Dstroke:      int ;
  val XK_Nacute:       int ;
  val XK_Ncaron:       int ;
  val XK_Odoubleacute: int ;
  val XK_Rcaron:       int ;
  val XK_Uring:        int ;
  val XK_Udoubleacute: int ;
  val XK_Tcedilla:     int ;
  val XK_racute:       int ;
  val XK_abreve:       int ;
  val XK_lacute:       int ;
  val XK_cacute:       int ;
  val XK_ccaron:       int ;
  val XK_eogonek:      int ;
  val XK_ecaron:       int ;
  val XK_dcaron:       int ;
  val XK_dstroke:      int ;
  val XK_nacute:       int ;
  val XK_ncaron:       int ;
  val XK_odoubleacute: int ;
  val XK_udoubleacute: int ;
  val XK_rcaron:       int ;
  val XK_uring:        int ;
  val XK_tcedilla:     int ;
  val XK_abovedot:     int ;

(* Latin 3 *)

  val XK_Hstroke:     int ;
  val XK_Hcircumflex: int ;
  val XK_Iabovedot:   int ;
  val XK_Gbreve:      int ;
  val XK_Jcircumflex: int ;
  val XK_hstroke:     int ;
  val XK_hcircumflex: int ;
  val XK_idotless:    int ;
  val XK_gbreve:      int ;
  val XK_jcircumflex: int ;
  val XK_Cabovedot:   int ;
  val XK_Ccircumflex: int ;
  val XK_Gabovedot:   int ;
  val XK_Gcircumflex: int ;
  val XK_Ubreve:      int ;
  val XK_Scircumflex: int ;
  val XK_cabovedot:   int ;
  val XK_ccircumflex: int ;
  val XK_gabovedot:   int ;
  val XK_gcircumflex: int ;
  val XK_ubreve:      int ;
  val XK_scircumflex: int ;

(* Latin 4 *)

  val XK_kra:       int ;
  val XK_kappa:     int ;
  val XK_Rcedilla:  int ;
  val XK_Itilde:    int ;
  val XK_Lcedilla:  int ;
  val XK_Emacron:   int ;
  val XK_Gcedilla:  int ;
  val XK_Tslash:    int ;
  val XK_rcedilla:  int ;
  val XK_itilde:    int ;
  val XK_lcedilla:  int ;
  val XK_emacron:   int ;
  val XK_gcedilla:  int ;
  val XK_tslash:    int ;
  val XK_ENG:       int ;
  val XK_eng:       int ;
  val XK_Amacron:   int ;
  val XK_Iogonek:   int ;
  val XK_Eabovedot: int ;
  val XK_Imacron:   int ;
  val XK_Ncedilla:  int ;
  val XK_Omacron:   int ;
  val XK_Kcedilla:  int ;
  val XK_Uogonek:   int ;
  val XK_Utilde:    int ;
  val XK_Umacron:   int ;
  val XK_amacron:   int ;
  val XK_iogonek:   int ;
  val XK_eabovedot: int ;
  val XK_imacron:   int ;
  val XK_ncedilla:  int ;
  val XK_omacron:   int ;
  val XK_kcedilla:  int ;
  val XK_uogonek:   int ;
  val XK_utilde:    int ;
  val XK_umacron:   int ;

(* Katakana *)

  val XK_overline:            int ;
  val XK_kana_fullstop:       int ;
  val XK_kana_openingbracket: int ;
  val XK_kana_closingbracket: int ;
  val XK_kana_comma:          int ;
  val XK_kana_conjunctive:    int ;
  val XK_kana_middledot:      int ;
  val XK_kana_WO:             int ;
  val XK_kana_a:              int ;
  val XK_kana_i:              int ;
  val XK_kana_u:              int ;
  val XK_kana_e:              int ;
  val XK_kana_o:              int ;
  val XK_kana_ya:             int ;
  val XK_kana_yu:             int ;
  val XK_kana_yo:             int ;
  val XK_kana_tsu:            int ;
  val XK_kana_tu:             int ;
  val XK_prolongedsound:      int ;
  val XK_kana_A:              int ;
  val XK_kana_I:              int ;
  val XK_kana_U:              int ;
  val XK_kana_E:              int ;
  val XK_kana_O:              int ;
  val XK_kana_KA:             int ;
  val XK_kana_KI:             int ;
  val XK_kana_KU:             int ;
  val XK_kana_KE:             int ;
  val XK_kana_KO:             int ;
  val XK_kana_SA:             int ;
  val XK_kana_SHI:            int ;
  val XK_kana_SU:             int ;
  val XK_kana_SE:             int ;
  val XK_kana_SO:             int ;
  val XK_kana_TA:             int ;
  val XK_kana_CHI:            int ;
  val XK_kana_TI:             int ;
  val XK_kana_TSU:            int ;
  val XK_kana_TU:             int ;
  val XK_kana_TE:             int ;
  val XK_kana_TO:             int ;
  val XK_kana_NA:             int ;
  val XK_kana_NI:             int ;
  val XK_kana_NU:             int ;
  val XK_kana_NE:             int ;
  val XK_kana_NO:             int ;
  val XK_kana_HA:             int ;
  val XK_kana_HI:             int ;
  val XK_kana_FU:             int ;
  val XK_kana_HU:             int ;
  val XK_kana_HE:             int ;
  val XK_kana_HO:             int ;
  val XK_kana_MA:             int ;
  val XK_kana_MI:             int ;
  val XK_kana_MU:             int ;
  val XK_kana_ME:             int ;
  val XK_kana_MO:             int ;
  val XK_kana_YA:             int ;
  val XK_kana_YU:             int ;
  val XK_kana_YO:             int ;
  val XK_kana_RA:             int ;
  val XK_kana_RI:             int ;
  val XK_kana_RU:             int ;
  val XK_kana_RE:             int ;
  val XK_kana_RO:             int ;
  val XK_kana_WA:             int ;
  val XK_kana_N:              int ;
  val XK_voicedsound:         int ;
  val XK_semivoicedsound:     int ;
  val XK_kana_switch:         int ;

(* Arabic *)

  val XK_Arabic_comma:          int ;
  val XK_Arabic_semicolon:      int ;
  val XK_Arabic_question_mark:  int ;
  val XK_Arabic_hamza:          int ;
  val XK_Arabic_maddaonalef:    int ;
  val XK_Arabic_hamzaonalef:    int ;
  val XK_Arabic_hamzaonwaw:     int ;
  val XK_Arabic_hamzaunderalef: int ;
  val XK_Arabic_hamzaonyeh:     int ;
  val XK_Arabic_alef:           int ;
  val XK_Arabic_beh:            int ;
  val XK_Arabic_tehmarbuta:     int ;
  val XK_Arabic_teh:            int ;
  val XK_Arabic_theh:           int ;
  val XK_Arabic_jeem:           int ;
  val XK_Arabic_hah:            int ;
  val XK_Arabic_khah:           int ;
  val XK_Arabic_dal:            int ;
  val XK_Arabic_thal:           int ;
  val XK_Arabic_ra:             int ;
  val XK_Arabic_zain:           int ;
  val XK_Arabic_seen:           int ;
  val XK_Arabic_sheen:          int ;
  val XK_Arabic_sad:            int ;
  val XK_Arabic_dad:            int ;
  val XK_Arabic_tah:            int ;
  val XK_Arabic_zah:            int ;
  val XK_Arabic_ain:            int ;
  val XK_Arabic_ghain:          int ;
  val XK_Arabic_tatweel:        int ;
  val XK_Arabic_feh:            int ;
  val XK_Arabic_qaf:            int ;
  val XK_Arabic_kaf:            int ;
  val XK_Arabic_lam:            int ;
  val XK_Arabic_meem:           int ;
  val XK_Arabic_noon:           int ;
  val XK_Arabic_ha:             int ;
  val XK_Arabic_heh:            int ;
  val XK_Arabic_waw:            int ;
  val XK_Arabic_alefmaksura:    int ;
  val XK_Arabic_yeh:            int ;
  val XK_Arabic_fathatan:       int ;
  val XK_Arabic_dammatan:       int ;
  val XK_Arabic_kasratan:       int ;
  val XK_Arabic_fatha:          int ;
  val XK_Arabic_damma:          int ;
  val XK_Arabic_kasra:          int ;
  val XK_Arabic_shadda:         int ;
  val XK_Arabic_sukun:          int ;
  val XK_Arabic_switch:         int ;

(* Cyrillic *)

  val XK_Serbian_dje:         int ;
  val XK_Macedonia_gje:       int ;
  val XK_Cyrillic_io:         int ;
  val XK_Ukrainian_ie:        int ;
  val XK_Ukranian_je:         int ;
  val XK_Macedonia_dse:       int ;
  val XK_Ukrainian_i:         int ;
  val XK_Ukranian_i:          int ;
  val XK_Ukrainian_yi:        int ;
  val XK_Ukranian_yi:         int ;
  val XK_Cyrillic_je:         int ;
  val XK_Serbian_je:          int ;
  val XK_Cyrillic_lje:        int ;
  val XK_Serbian_lje:         int ;
  val XK_Cyrillic_nje:        int ;
  val XK_Serbian_nje:         int ;
  val XK_Serbian_tshe:        int ;
  val XK_Macedonia_kje:       int ;
  val XK_Byelorussian_shortu: int ;
  val XK_Cyrillic_dzhe:       int ;
  val XK_Serbian_dze:         int ;
  val XK_numerosign:          int ;
  val XK_Serbian_DJE:         int ;
  val XK_Macedonia_GJE:       int ;
  val XK_Cyrillic_IO:         int ;
  val XK_Ukrainian_IE:        int ;
  val XK_Ukranian_JE:         int ;
  val XK_Macedonia_DSE:       int ;
  val XK_Ukrainian_I:         int ;
  val XK_Ukranian_I:          int ;
  val XK_Ukrainian_YI:        int ;
  val XK_Ukranian_YI:         int ;
  val XK_Cyrillic_JE:         int ;
  val XK_Serbian_JE:          int ;
  val XK_Cyrillic_LJE:        int ;
  val XK_Serbian_LJE:         int ;
  val XK_Cyrillic_NJE:        int ;
  val XK_Serbian_NJE:         int ;
  val XK_Serbian_TSHE:        int ;
  val XK_Macedonia_KJE:       int ;
  val XK_Byelorussian_SHORTU: int ;
  val XK_Cyrillic_DZHE:       int ;
  val XK_Serbian_DZE:         int ;
  val XK_Cyrillic_yu:         int ;
  val XK_Cyrillic_a:          int ;
  val XK_Cyrillic_be:         int ;
  val XK_Cyrillic_tse:        int ;
  val XK_Cyrillic_de:         int ;
  val XK_Cyrillic_ie:         int ;
  val XK_Cyrillic_ef:         int ;
  val XK_Cyrillic_ghe:        int ;
  val XK_Cyrillic_ha:         int ;
  val XK_Cyrillic_i:          int ;
  val XK_Cyrillic_shorti:     int ;
  val XK_Cyrillic_ka:         int ;
  val XK_Cyrillic_el:         int ;
  val XK_Cyrillic_em:         int ;
  val XK_Cyrillic_en:         int ;
  val XK_Cyrillic_o:          int ;
  val XK_Cyrillic_pe:         int ;
  val XK_Cyrillic_ya:         int ;
  val XK_Cyrillic_er:         int ;
  val XK_Cyrillic_es:         int ;
  val XK_Cyrillic_te:         int ;
  val XK_Cyrillic_u:          int ;
  val XK_Cyrillic_zhe:        int ;
  val XK_Cyrillic_ve:         int ;
  val XK_Cyrillic_softsign:   int ;
  val XK_Cyrillic_yeru:       int ;
  val XK_Cyrillic_ze:         int ;
  val XK_Cyrillic_sha:        int ;
  val XK_Cyrillic_e:          int ;
  val XK_Cyrillic_shcha:      int ;
  val XK_Cyrillic_che:        int ;
  val XK_Cyrillic_hardsign:   int ;
  val XK_Cyrillic_YU:         int ;
  val XK_Cyrillic_A:          int ;
  val XK_Cyrillic_BE:         int ;
  val XK_Cyrillic_TSE:        int ;
  val XK_Cyrillic_DE:         int ;
  val XK_Cyrillic_IE:         int ;
  val XK_Cyrillic_EF:         int ;
  val XK_Cyrillic_GHE:        int ;
  val XK_Cyrillic_HA:         int ;
  val XK_Cyrillic_I:          int ;
  val XK_Cyrillic_SHORTI:     int ;
  val XK_Cyrillic_KA:         int ;
  val XK_Cyrillic_EL:         int ;
  val XK_Cyrillic_EM:         int ;
  val XK_Cyrillic_EN:         int ;
  val XK_Cyrillic_O:          int ;
  val XK_Cyrillic_PE:         int ;
  val XK_Cyrillic_YA:         int ;
  val XK_Cyrillic_ER:         int ;
  val XK_Cyrillic_ES:         int ;
  val XK_Cyrillic_TE:         int ;
  val XK_Cyrillic_U:          int ;
  val XK_Cyrillic_ZHE:        int ;
  val XK_Cyrillic_VE:         int ;
  val XK_Cyrillic_SOFTSIGN:   int ;
  val XK_Cyrillic_YERU:       int ;
  val XK_Cyrillic_ZE:         int ;
  val XK_Cyrillic_SHA:        int ;
  val XK_Cyrillic_E:          int ;
  val XK_Cyrillic_SHCHA:      int ;
  val XK_Cyrillic_CHE:        int ;
  val XK_Cyrillic_HARDSIGN:   int ;

(* Greek *)

  val XK_Greek_ALPHAaccent:           int ;
  val XK_Greek_EPSILONaccent:         int ;
  val XK_Greek_ETAaccent:             int ;
  val XK_Greek_IOTAaccent:            int ;
  val XK_Greek_IOTAdiaeresis:         int ;
  val XK_Greek_OMICRONaccent:         int ;
  val XK_Greek_UPSILONaccent:         int ;
  val XK_Greek_UPSILONdieresis:       int ;
  val XK_Greek_OMEGAaccent:           int ;
  val XK_Greek_accentdieresis:        int ;
  val XK_Greek_horizbar:              int ;
  val XK_Greek_alphaaccent:           int ;
  val XK_Greek_epsilonaccent:         int ;
  val XK_Greek_etaaccent:             int ;
  val XK_Greek_iotaaccent:            int ;
  val XK_Greek_iotadieresis:          int ;
  val XK_Greek_iotaaccentdieresis:    int ;
  val XK_Greek_omicronaccent:         int ;
  val XK_Greek_upsilonaccent:         int ;
  val XK_Greek_upsilondieresis:       int ;
  val XK_Greek_upsilonaccentdieresis: int ;
  val XK_Greek_omegaaccent:           int ;
  val XK_Greek_ALPHA:                 int ;
  val XK_Greek_BETA:                  int ;
  val XK_Greek_GAMMA:                 int ;
  val XK_Greek_DELTA:                 int ;
  val XK_Greek_EPSILON:               int ;
  val XK_Greek_ZETA:                  int ;
  val XK_Greek_ETA:                   int ;
  val XK_Greek_THETA:                 int ;
  val XK_Greek_IOTA:                  int ;
  val XK_Greek_KAPPA:                 int ;
  val XK_Greek_LAMDA:                 int ;
  val XK_Greek_LAMBDA:                int ;
  val XK_Greek_MU:                    int ;
  val XK_Greek_NU:                    int ;
  val XK_Greek_XI:                    int ;
  val XK_Greek_OMICRON:               int ;
  val XK_Greek_PI:                    int ;
  val XK_Greek_RHO:                   int ;
  val XK_Greek_SIGMA:                 int ;
  val XK_Greek_TAU:                   int ;
  val XK_Greek_UPSILON:               int ;
  val XK_Greek_PHI:                   int ;
  val XK_Greek_CHI:                   int ;
  val XK_Greek_PSI:                   int ;
  val XK_Greek_OMEGA:                 int ;
  val XK_Greek_alpha:                 int ;
  val XK_Greek_beta:                  int ;
  val XK_Greek_gamma:                 int ;
  val XK_Greek_delta:                 int ;
  val XK_Greek_epsilon:               int ;
  val XK_Greek_zeta:                  int ;
  val XK_Greek_eta:                   int ;
  val XK_Greek_theta:                 int ;
  val XK_Greek_iota:                  int ;
  val XK_Greek_kappa:                 int ;
  val XK_Greek_lamda:                 int ;
  val XK_Greek_lambda:                int ;
  val XK_Greek_mu:                    int ;
  val XK_Greek_nu:                    int ;
  val XK_Greek_xi:                    int ;
  val XK_Greek_omicron:               int ;
  val XK_Greek_pi:                    int ;
  val XK_Greek_rho:                   int ;
  val XK_Greek_sigma:                 int ;
  val XK_Greek_finalsmallsigma:       int ;
  val XK_Greek_tau:                   int ;
  val XK_Greek_upsilon:               int ;
  val XK_Greek_phi:                   int ;
  val XK_Greek_chi:                   int ;
  val XK_Greek_psi:                   int ;
  val XK_Greek_omega:                 int ;
  val XK_Greek_switch:                int ;

(* Technical *)

  val XK_leftradical:               int ;
  val XK_topleftradical:            int ;
  val XK_horizconnector:            int ;
  val XK_topintegral:               int ;
  val XK_botintegral:               int ;
  val XK_vertconnector:             int ;
  val XK_topleftsqbracket:          int ;
  val XK_botleftsqbracket:          int ;
  val XK_toprightsqbracket:         int ;
  val XK_botrightsqbracket:         int ;
  val XK_topleftparens:             int ;
  val XK_botleftparens:             int ;
  val XK_toprightparens:            int ;
  val XK_botrightparens:            int ;
  val XK_leftmiddlecurlybrace:      int ;
  val XK_rightmiddlecurlybrace:     int ;
  val XK_topleftsummation:          int ;
  val XK_botleftsummation:          int ;
  val XK_topvertsummationconnector: int ;
  val XK_botvertsummationconnector: int ;
  val XK_toprightsummation:         int ;
  val XK_botrightsummation:         int ;
  val XK_rightmiddlesummation:      int ;
  val XK_lessthanequal:             int ;
  val XK_notequal:                  int ;
  val XK_greaterthanequal:          int ;
  val XK_integral:                  int ;
  val XK_therefore:                 int ;
  val XK_variation:                 int ;
  val XK_infinity:                  int ;
  val XK_nabla:                     int ;
  val XK_approximate:               int ;
  val XK_similarequal:              int ;
  val XK_ifonlyif:                  int ;
  val XK_implies:                   int ;
  val XK_identical:                 int ;
  val XK_radical:                   int ;
  val XK_includedin:                int ;
  val XK_includes:                  int ;
  val XK_intersection:              int ;
  val XK_union:                     int ;
  val XK_logicaland:                int ;
  val XK_logicalor:                 int ;
  val XK_partialderivative:         int ;
  val XK_function:                  int ;
  val XK_leftarrow:                 int ;
  val XK_uparrow:                   int ;
  val XK_rightarrow:                int ;
  val XK_downarrow:                 int ;

(* Special *)

  val XK_blank:          int ;
  val XK_soliddiamond:   int ;
  val XK_checkerboard:   int ;
  val XK_ht:             int ;
  val XK_ff:             int ;
  val XK_cr:             int ;
  val XK_lf:             int ;
  val XK_nl:             int ;
  val XK_vt:             int ;
  val XK_lowrightcorner: int ;
  val XK_uprightcorner:  int ;
  val XK_upleftcorner:   int ;
  val XK_lowleftcorner:  int ;
  val XK_crossinglines:  int ;
  val XK_horizlinescan1: int ;
  val XK_horizlinescan3: int ;
  val XK_horizlinescan5: int ;
  val XK_horizlinescan7: int ;
  val XK_horizlinescan9: int ;
  val XK_leftt:          int ;
  val XK_rightt:         int ;
  val XK_bott:           int ;
  val XK_topt:           int ;
  val XK_vertbar:        int ;

(* Publishing *)

  val XK_emspace:              int ;
  val XK_enspace:              int ;
  val XK_em3space:             int ;
  val XK_em4space:             int ;
  val XK_digitspace:           int ;
  val XK_punctspace:           int ;
  val XK_thinspace:            int ;
  val XK_hairspace:            int ;
  val XK_emdash:               int ;
  val XK_endash:               int ;
  val XK_signifblank:          int ;
  val XK_ellipsis:             int ;
  val XK_doubbaselinedot:      int ;
  val XK_onethird:             int ;
  val XK_twothirds:            int ;
  val XK_onefifth:             int ;
  val XK_twofifths:            int ;
  val XK_threefifths:          int ;
  val XK_fourfifths:           int ;
  val XK_onesixth:             int ;
  val XK_fivesixths:           int ;
  val XK_careof:               int ;
  val XK_figdash:              int ;
  val XK_leftanglebracket:     int ;
  val XK_decimalpoint:         int ;
  val XK_rightanglebracket:    int ;
  val XK_marker:               int ;
  val XK_oneeighth:            int ;
  val XK_threeeighths:         int ;
  val XK_fiveeighths:          int ;
  val XK_seveneighths:         int ;
  val XK_trademark:            int ;
  val XK_signaturemark:        int ;
  val XK_trademarkincircle:    int ;
  val XK_leftopentriangle:     int ;
  val XK_rightopentriangle:    int ;
  val XK_emopencircle:         int ;
  val XK_emopenrectangle:      int ;
  val XK_leftsinglequotemark:  int ;
  val XK_rightsinglequotemark: int ;
  val XK_leftdoublequotemark:  int ;
  val XK_rightdoublequotemark: int ;
  val XK_prescription:         int ;
  val XK_minutes:              int ;
  val XK_seconds:              int ;
  val XK_latincross:           int ;
  val XK_hexagram:             int ;
  val XK_filledrectbullet:     int ;
  val XK_filledlefttribullet:  int ;
  val XK_filledrighttribullet: int ;
  val XK_emfilledcircle:       int ;
  val XK_emfilledrect:         int ;
  val XK_enopencircbullet:     int ;
  val XK_enopensquarebullet:   int ;
  val XK_openrectbullet:       int ;
  val XK_opentribulletup:      int ;
  val XK_opentribulletdown:    int ;
  val XK_openstar:             int ;
  val XK_enfilledcircbullet:   int ;
  val XK_enfilledsqbullet:     int ;
  val XK_filledtribulletup:    int ;
  val XK_filledtribulletdown:  int ;
  val XK_leftpointer:          int ;
  val XK_rightpointer:         int ;
  val XK_club:                 int ;
  val XK_diamond:              int ;
  val XK_heart:                int ;
  val XK_maltesecross:         int ;
  val XK_dagger:               int ;
  val XK_doubledagger:         int ;
  val XK_checkmark:            int ;
  val XK_ballotcross:          int ;
  val XK_musicalsharp:         int ;
  val XK_musicalflat:          int ;
  val XK_malesymbol:           int ;
  val XK_femalesymbol:         int ;
  val XK_telephone:            int ;
  val XK_telephonerecorder:    int ;
  val XK_phonographcopyright:  int ;
  val XK_caret:                int ;
  val XK_singlelowquotemark:   int ;
  val XK_doublelowquotemark:   int ;
  val XK_cursor:               int ;

(* APL *)

  val XK_leftcaret:  int ;
  val XK_rightcaret: int ;
  val XK_downcaret:  int ;
  val XK_upcaret:    int ;
  val XK_overbar:    int ;
  val XK_downtack:   int ;
  val XK_upshoe:     int ;
  val XK_downstile:  int ;
  val XK_underbar:   int ;
  val XK_jot:        int ;
  val XK_quad:       int ;
  val XK_uptack:     int ;
  val XK_circle:     int ;
  val XK_upstile:    int ;
  val XK_downshoe:   int ;
  val XK_rightshoe:  int ;
  val XK_leftshoe:   int ;
  val XK_lefttack:   int ;
  val XK_righttack:  int ;

(* Hebrew *)

  val XK_hebrew_doublelowline: int ;
  val XK_hebrew_aleph:         int ;
  val XK_hebrew_bet:           int ;
  val XK_hebrew_beth:          int ;
  val XK_hebrew_gimel:         int ;
  val XK_hebrew_gimmel:        int ;
  val XK_hebrew_dalet:         int ;
  val XK_hebrew_daleth:        int ;
  val XK_hebrew_he:            int ;
  val XK_hebrew_waw:           int ;
  val XK_hebrew_zain:          int ;
  val XK_hebrew_zayin:         int ;
  val XK_hebrew_chet:          int ;
  val XK_hebrew_het:           int ;
  val XK_hebrew_tet:           int ;
  val XK_hebrew_teth:          int ;
  val XK_hebrew_yod:           int ;
  val XK_hebrew_finalkaph:     int ;
  val XK_hebrew_kaph:          int ;
  val XK_hebrew_lamed:         int ;
  val XK_hebrew_finalmem:      int ;
  val XK_hebrew_mem:           int ;
  val XK_hebrew_finalnun:      int ;
  val XK_hebrew_nun:           int ;
  val XK_hebrew_samech:        int ;
  val XK_hebrew_samekh:        int ;
  val XK_hebrew_ayin:          int ;
  val XK_hebrew_finalpe:       int ;
  val XK_hebrew_pe:            int ;
  val XK_hebrew_finalzade:     int ;
  val XK_hebrew_finalzadi:     int ;
  val XK_hebrew_zade:          int ;
  val XK_hebrew_zadi:          int ;
  val XK_hebrew_qoph:          int ;
  val XK_hebrew_kuf:           int ;
  val XK_hebrew_resh:          int ;
  val XK_hebrew_shin:          int ;
  val XK_hebrew_taw:           int ;
  val XK_hebrew_taf:           int ;
  val XK_Hebrew_switch:        int ;

end (* XKEYSYMS_SIG *) ;
