dnl This is m4 source.
dnl Process using m4 to produce 'C' language file.
dnl
dnl If you see this line, you can ignore the next one.
/* Do not edit this file. It is produced from the corresponding .m4 source */
dnl
/*
 *  Copyright (C) 2003, Northwestern University and Argonne National Laboratory
 *  See COPYRIGHT notice in top-level directory.
 */
/* $Id: test_put.m4 2295 2016-01-06 20:28:09Z wkliao $ */


undefine(`index')dnl
dnl dnl dnl
dnl
dnl Macros
dnl
dnl dnl dnl
dnl
dnl Upcase(str)
dnl
define(`Upcase',dnl
`dnl
translit($1, abcdefghijklmnopqrstuvwxyz, ABCDEFGHIJKLMNOPQRSTUVWXYZ)')dnl
dnl dnl dnl
dnl
dnl NCT_ITYPE(type)
dnl
define(`NCT_ITYPE',    ``NCT_'Upcase($1)')dnl
define(`NC_TYPE',      ``NC_'Upcase($1)')dnl
define(`X_MIN',        ``X_'Upcase($1)_MIN')dnl
define(`X_MAX',        ``X_'Upcase($1)_MAX')dnl
dnl

define(`CheckText', `ifelse(`$1',`text', , `== (NCT_ITYPE($1) == NCT_TEXT)')')dnl
define(`IfCheckTextChar', `ifelse(`$1',`text', `if ($2 != NC_CHAR)')')dnl
define(`CheckNumRange',
       `ifelse(`$1',`text', `1',
               `inRange3($2,$3,NCT_ITYPE($1)) && ($2 >= $1_min && $2 <= $1_max)')')dnl
define(`CheckRange',
       `ifelse(`$1',`text', `0', `($2 >= $1_min && $2 <= $1_max)')')dnl
define(`CheckRange3',
       `ifelse(`$1',`text', `1',
               `inRange3($2,$3,NCT_ITYPE($1))')')dnl

#include "tests.h"

dnl HASH(TYPE)
dnl
define(`HASH',dnl
`dnl
/*
 *  ensure hash value within range for internal TYPE
 */
static
double
hash_$1(
    const nc_type type,
    const int rank,
    const MPI_Offset *index,
    const nct_itype itype)
{
    const double min = $1_min;
    const double max = $1_max;

    return MAX(min, MIN(max, hash4( type, rank, index, itype)));
}
')dnl

dnl HASH(text)
#define hash_text hash4

HASH(uchar)
HASH(schar)
HASH(short)
HASH(int)
HASH(long)
HASH(float)
HASH(double)
HASH(ushort)
HASH(uint)
HASH(longlong)
HASH(ulonglong)


dnl CHECK_VARS(TYPE)
dnl
define(`CHECK_VARS',dnl
`dnl
/* 
 *  check all vars in file which are (text/numeric) compatible with TYPE
 */
static
int
check_vars_$1(const char *filename)
{
    int  ncid;                  /* netCDF id */
    MPI_Offset index[MAX_RANK];
    int  err;
    int  d;
    int  i;
    size_t  j;
    $1 value;
    nc_type datatype;
    int ndims;
    int dimids[MAX_RANK];
    char name[NC_MAX_NAME];
    MPI_Offset length;
    int canConvert;     /* Both text or both numeric */
    int nok = 0;      /* count of valid comparisons */
    double expect;

    err = ncmpi_open(comm, filename, NC_NOWRITE, info, &ncid);
    IF (err != NC_NOERR)
        error("ncmpi_open: %s", ncmpi_strerror(err));

    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        if (canConvert) {
            err = ncmpi_inq_var(ncid, i, name, &datatype, &ndims, dimids, NULL);
            IF (err != NC_NOERR)
                error("ncmpi_inq_var: %s", ncmpi_strerror(err));
            IF (strcmp(name, var_name[i]) != 0)
                error("Unexpected var_name");
            IF (datatype != var_type[i])
                error("Unexpected type");
            IF (ndims != var_rank[i])
                error("Unexpected rank");
            for (j = 0; j < ndims; j++) {
                err = ncmpi_inq_dim(ncid, dimids[j], 0, &length);
                IF (err != NC_NOERR)
                    error("ncmpi_inq_dim: %s", ncmpi_strerror(err));
                IF (length != var_shape[i][j])
                    error("Unexpected shape");
            }
            for (j = 0; j < var_nels[i]; j++) {
                err = toMixedBase(j, var_rank[i], var_shape[i], index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase 2");
                expect = hash4( var_type[i], var_rank[i], index, NCT_ITYPE($1));
                err = ncmpi_get_var1_$1_all(ncid, i, index, &value);
                if (CheckNumRange($1, expect, datatype)) {
                    IF (err != NC_NOERR) {
                        error("ncmpi_get_var1_$1_all: %s", ncmpi_strerror(err));
                    } else {
                        IF (!equal(value,expect,var_type[i],NCT_ITYPE($1))) {
                            error("Var value read not that expected");
                            if (verbose) {
                                error("\n");
                                error("varid: %d, ", i);
                                error("var_name: %s, ", var_name[i]);
                                error("var_type: %s, ", s_nc_type(var_type[i]));
                                error("index:");
                                for (d = 0; d < var_rank[i]; d++)
                                    error(" %d", index[d]);
                                error(", expect: %g, ", expect);
                                error("got: %g", (double) value);
                            }
                        } else {
                            ++nok;
                        }
                    }
                }
            }
        }
    }
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));
    return nok;
}
')dnl

CHECK_VARS(text)
CHECK_VARS(uchar)
CHECK_VARS(schar)
CHECK_VARS(short)
CHECK_VARS(int)
CHECK_VARS(long)
CHECK_VARS(float)
CHECK_VARS(double)
CHECK_VARS(ushort)
CHECK_VARS(uint)
CHECK_VARS(longlong)
CHECK_VARS(ulonglong)


dnl CHECK_ATTS(TYPE)         numeric only
dnl
define(`CHECK_ATTS',dnl
`dnl
/* 
 *  check all attributes in file which are (text/numeric) compatible with TYPE
 *  ignore any attributes containing values outside range of TYPE
 */
static
int
check_atts_$1(int  ncid)
{
    int  err;
    int  i;
    int  j;
    MPI_Offset  k;
    $1 value[MAX_NELS];
    nc_type datatype;
    MPI_Offset length;
    size_t nInExtRange;  /* number values within external range */
    size_t nInIntRange;  /* number values within internal range */
    int canConvert;     /* Both text or both numeric */
    int nok = 0;      /* count of valid comparisons */
    double expect[MAX_NELS];

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            canConvert = (ATT_TYPE(i,j) == NC_CHAR) CheckText($1);
            if (!canConvert) continue;

            err = ncmpi_inq_att(ncid, i, ATT_NAME(i,j), &datatype, &length);
            IF (err != NC_NOERR)
                error("ncmpi_inq_att: %s", ncmpi_strerror(err));
            IF (datatype != ATT_TYPE(i,j))
            error("ncmpi_inq_att: unexpected type");
            IF (length != ATT_LEN(i,j))
                error("ncmpi_inq_att: unexpected length");
            assert(length <= MAX_NELS);
            nInIntRange = nInExtRange = 0;
            for (k = 0; k < length; k++) {
                expect[k] = hash4( datatype, -1, &k, NCT_ITYPE($1));
                if (inRange3(expect[k], datatype, NCT_ITYPE($1))) {
                    ++nInExtRange;
                    if (CheckRange($1, expect[k]))
                        ++nInIntRange;
                }
            }
            err = ncmpi_get_att_$1(ncid, i, ATT_NAME(i,j), value);
            if (nInExtRange == length && nInIntRange == length) {
                IF (err != NC_NOERR)
                    error("%s", ncmpi_strerror(err));
            } else {
                IF (err != NC_NOERR && err != NC_ERANGE)
                    error("OK or Range error: err = %d", err);
            }
            for (k = 0; k < length; k++) {
                if (CheckNumRange($1, expect[k], datatype)) {
                    IF (!equal(value[k],expect[k],datatype,NCT_ITYPE($1))) {
                        error("att. value read not that expected");
                        if (verbose) {
                            error("\n");
                            error("varid: %d, ", i);
                            error("att_name: %s, ", ATT_NAME(i,j));
                            error("att_type: %s, ", s_nc_type(ATT_TYPE(i,j)));
                            error("element number: %d ", k);
                            error("expect: %g, ", expect[k]);
                            error("got: %g", (double) value[k]);
                        }
                    } else {
                        nok++;
                    }
                }
            }                                               
        }                                               
    }
    return nok;
}
')dnl

CHECK_ATTS(text)
CHECK_ATTS(uchar)
CHECK_ATTS(schar)
CHECK_ATTS(short)
CHECK_ATTS(int)
CHECK_ATTS(long)
CHECK_ATTS(float)
CHECK_ATTS(double)
CHECK_ATTS(ushort)
CHECK_ATTS(uint)
CHECK_ATTS(longlong)
CHECK_ATTS(ulonglong)


dnl TEST_NC_PUT_VAR1(TYPE)
dnl
define(`TEST_NC_PUT_VAR1',dnl
`dnl
int
test_ncmpi_put_var1_$1(void)
{
    int ncid, nok=0;
    int i;
    int j;
    int err;
    MPI_Offset index[MAX_RANK];
    int canConvert;        /* Both text or both numeric */
    $1 value = 5;        /* any value would do - only for error cases */

    err = ncmpi_create(comm, scratch, NC_CLOBBER|extra_flags, info, &ncid);
    IF (err != NC_NOERR) {
        error("ncmpi_create: %s", ncmpi_strerror(err));
        return nok;
    }
    def_dims(ncid);
    def_vars(ncid);
    err = ncmpi_enddef(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_enddef: %s", ncmpi_strerror(err));

    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        for (j = 0; j < var_rank[i]; j++)
            index[j] = 0;
        err = ncmpi_put_var1_$1_all(BAD_ID, i, index, &value);
        IF (err != NC_EBADID) 
            error("expecting NC_EBADID (bad ncid), but err = %s", nc_err_code_name(err));
        ELSE_NOK
        err = ncmpi_put_var1_$1_all(ncid, BAD_VARID, index, &value);
        IF (err != NC_ENOTVAR) 
            error("expecting NC_ENOTVAR (bad var id), but err = %s", nc_err_code_name(err));
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] > 0) {                /* skip record dim */
                index[j] = var_shape[i][j];     /* out of boundary check */
                err = ncmpi_put_var1_$1_all(ncid, i, index, &value);
                IF (canConvert && err != NC_EINVALCOORDS)
                    error("expecting NC_EINVALCOORDS (bad index), but err = %s", nc_err_code_name(err));
                ELSE_NOK
                index[j] = 0;
            }
        }
        for (j = 0; j < var_nels[i]; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != NC_NOERR) 
                error("error in toMixedBase 1");
            value = hash_$1( var_type[i], var_rank[i], index, NCT_ITYPE($1));
            if (var_rank[i] == 0 && i%2 == 0)
                err = ncmpi_put_var1_$1_all(ncid, i, NULL, &value);
            else
                err = ncmpi_put_var1_$1_all(ncid, i, index, &value);
            if (canConvert) {
                if (CheckRange3($1, value, var_type[i])) {
                    IF (err != NC_NOERR)
                        error("%s", ncmpi_strerror(err));
                    ELSE_NOK
                } else {
                    IF (err != NC_ERANGE) {
                        error("Range error: err = %d", err);
                        error("\n\t\tfor type %s value %.17e %ld",
                                s_nc_type(var_type[i]),
                                (double)value, (long)value);
                    }
                    ELSE_NOK
                }
            } else {
                IF (err != NC_ECHAR)
                    error("wrong type: err = %d", err);
                ELSE_NOK
            }
        }
    }

    err = ncmpi_close(ncid);
    IF (err != NC_NOERR) 
        error("ncmpi_close: %s", ncmpi_strerror(err));

    nok += check_vars_$1(scratch);

    err = ncmpi_delete(scratch, info);
    IF (err != NC_NOERR)
        error("remove of %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_PUT_VAR1(text)
TEST_NC_PUT_VAR1(uchar)
TEST_NC_PUT_VAR1(schar)
TEST_NC_PUT_VAR1(short)
TEST_NC_PUT_VAR1(int)
TEST_NC_PUT_VAR1(long)
TEST_NC_PUT_VAR1(float)
TEST_NC_PUT_VAR1(double)
TEST_NC_PUT_VAR1(ushort)
TEST_NC_PUT_VAR1(uint)
TEST_NC_PUT_VAR1(longlong)
TEST_NC_PUT_VAR1(ulonglong)


dnl TEST_NC_PUT_VAR(TYPE)
dnl
define(`TEST_NC_PUT_VAR',dnl
`dnl
int
test_ncmpi_put_var_$1(void)
{
    int ncid, nok=0;
    int varid;
    int i;
    int j;
    int err;
    int nels;
    MPI_Offset index[MAX_RANK];
    int canConvert;        /* Both text or both numeric */
    int allInExtRange;        /* all values within external range? */
    $1 value[MAX_NELS];

    err = ncmpi_create(comm, scratch, NC_CLOBBER|extra_flags, info, &ncid);
    IF (err != NC_NOERR) {
        error("ncmpi_create: %s", ncmpi_strerror(err));
        return nok;
    }
    def_dims(ncid);
    def_vars(ncid);
    err = ncmpi_enddef(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_enddef: %s", ncmpi_strerror(err));

    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        err = ncmpi_put_var_$1_all(BAD_ID, i, value);
        IF (err != NC_EBADID) 
            error("expecting bad ncid, but err = %d", err);
        ELSE_NOK
        err = ncmpi_put_var_$1_all(ncid, BAD_VARID, value);
        IF (err != NC_ENOTVAR) 
            error("expecting bad var id, but err = %d", err);
        ELSE_NOK

        nels = 1;
        for (j = 0; j < var_rank[i]; j++) {
            nels *= var_shape[i][j];
        }
        for (allInExtRange = 1, j = 0; j < nels; j++) {
            err = toMixedBase(j, var_rank[i], var_shape[i], index);
            IF (err != NC_NOERR) 
                error("error in toMixedBase 1");
            value[j]= hash_$1(var_type[i], var_rank[i], index, NCT_ITYPE($1));
            IfCheckTextChar($1, var_type[i])
                allInExtRange &= inRange3(value[j], var_type[i], NCT_ITYPE($1));
        }
        err = ncmpi_put_var_$1_all(ncid, i, value);
        if (canConvert) {
            if (allInExtRange) {
                IF (err != NC_NOERR) 
                    error("%s", ncmpi_strerror(err));
                ELSE_NOK
            } else {
                IF (err != NC_ERANGE && var_dimid[i][0] != RECDIM)
                    error("expecting range error, but err = %d", err);
                ELSE_NOK
            }
        } else { /* should flag wrong type even if nothing to write */
            IF (nels > 0 && err != NC_ECHAR)
                error("wrong type: err = %d", err);
            ELSE_NOK
        }
    }

    /* Preceeding has written nothing for record variables, now try */
    /* again with more than 0 records */

    /* Write record number NRECS to force writing of preceding records */
    /* Assumes variable cr is char vector with UNLIMITED dimension */
    err = ncmpi_inq_varid(ncid, "cr", &varid);
    IF (err != NC_NOERR)
        error("ncmpi_inq_varid: %s", ncmpi_strerror(err));
    index[0] = NRECS-1;
    err = ncmpi_put_var1_text_all(ncid, varid, index, "x");
    IF (err != NC_NOERR)
        error("ncmpi_put_var1_text_all: %s", ncmpi_strerror(err));

    for (i = 0; i < numVars; i++) {
        if (var_dimid[i][0] == RECDIM) {  /* only test record variables here */
            canConvert = (var_type[i] == NC_CHAR) CheckText($1);
            assert(var_rank[i] <= MAX_RANK);
            assert(var_nels[i] <= MAX_NELS);
            err = ncmpi_put_var_$1_all(BAD_ID, i, value);
            IF (err != NC_EBADID) 
                error("expecting bad ncid, but err = %d", err);
            ELSE_NOK

            nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                nels *= var_shape[i][j];
            }
            for (allInExtRange = 1, j = 0; j < nels; j++) {
                err = toMixedBase(j, var_rank[i], var_shape[i], index);
                IF (err != NC_NOERR) 
                    error("error in toMixedBase 1");
                ELSE_NOK
                value[j]= hash_$1(var_type[i], var_rank[i], index, NCT_ITYPE($1));
                IfCheckTextChar($1, var_type[i])
                    allInExtRange &= inRange3(value[j], var_type[i], NCT_ITYPE($1));
            }
            err = ncmpi_put_var_$1_all(ncid, i, value);
            if (canConvert) {
                if (allInExtRange) {
                    IF (err != NC_NOERR) 
                        error("%s", ncmpi_strerror(err));
                    ELSE_NOK
                } else {
                    IF (err != NC_ERANGE)
                        error("expecting range error, but err = %d", err);
                    ELSE_NOK
                }
            } else {
                IF (nels > 0 && err != NC_ECHAR)
                    error("wrong type: err = %d", err);
                ELSE_NOK
            }
        }
    }

    err = ncmpi_close(ncid);
    IF (err != NC_NOERR) 
        error("ncmpi_close: %s", ncmpi_strerror(err));

    nok += check_vars_$1(scratch);

    err = ncmpi_delete(scratch, info);
    IF (err != NC_NOERR)
        error("remove of %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_PUT_VAR(text)
TEST_NC_PUT_VAR(uchar)
TEST_NC_PUT_VAR(schar)
TEST_NC_PUT_VAR(short)
TEST_NC_PUT_VAR(int)
TEST_NC_PUT_VAR(long)
TEST_NC_PUT_VAR(float)
TEST_NC_PUT_VAR(double)
TEST_NC_PUT_VAR(ushort)
TEST_NC_PUT_VAR(uint)
TEST_NC_PUT_VAR(longlong)
TEST_NC_PUT_VAR(ulonglong)


dnl TEST_NC_PUT_VARA(TYPE)
dnl
define(`TEST_NC_PUT_VARA',dnl
`dnl
int
test_ncmpi_put_vara_$1(void)
{
    int ncid, nok=0;
    int d;
    int i;
    int j;
    int k;
    int err;
    int nslabs;
    int nels;
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    int canConvert;        /* Both text or both numeric */
    int allInExtRange;        /* all values within external range? */
    $1 value[MAX_NELS];

    err = ncmpi_create(comm, scratch, NC_CLOBBER|extra_flags, info, &ncid);
    IF (err != NC_NOERR) {
        error("ncmpi_create: %s", ncmpi_strerror(err));
        return nok;
    }
    def_dims(ncid);
    def_vars(ncid);
    err = ncmpi_enddef(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_enddef: %s", ncmpi_strerror(err));

    value[0] = 0;
    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
        }
        err = ncmpi_put_vara_$1_all(BAD_ID, i, start, edge, value);
        IF (err != NC_EBADID) 
            error("expecting bad ncid, but err = %d", err);
        ELSE_NOK
        err = ncmpi_put_vara_$1_all(ncid, BAD_VARID, start, edge, value);
        IF (err != NC_ENOTVAR) 
            error("expecting bad var id, but err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] > 0) {                /* skip record dim */
                start[j] = var_shape[i][j];
                err = ncmpi_put_vara_$1_all(ncid, i, start, edge, value);
                IF (canConvert && err != NC_EINVALCOORDS)
                    error("expecting bad start, but err = %d", err);
                ELSE_NOK
                start[j] = 0;
                edge[j] = var_shape[i][j] + 1;
                err = ncmpi_put_vara_$1_all(ncid, i, start, edge, value);
                IF (canConvert && err != NC_EEDGE)
                    error("expecting bad edge, but err = %d", err);
                ELSE_NOK
                edge[j] = 1;
            }
        }

        /* Check correct error returned even when nothing to put */
        for (j = 0; j < var_rank[i]; j++) {
            edge[j] = 0;
        }
        err = ncmpi_put_vara_$1_all(BAD_ID, i, start, edge, value);
        IF (err != NC_EBADID) 
            error("expecting bad ncid, but err = %d", err);
        ELSE_NOK
        err = ncmpi_put_vara_$1_all(ncid, BAD_VARID, start, edge, value);
        IF (err != NC_ENOTVAR) 
            error("expecting bad var id, but err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] > 0) {                /* skip record dim */
                start[j] = var_shape[i][j];
                err = ncmpi_put_vara_$1_all(ncid, i, start, edge, value);
                IF (canConvert && err != NC_EINVALCOORDS)
                    error("expecting bad start, but err = %d", err);
                ELSE_NOK
                start[j] = 0;
            }
        }

/* wkliao: this test below of put_vara is redundant and incorrectly uses the
           value[] set from the previously iteration. There is no such test
           in put_vars and put_varm.

        err = ncmpi_put_vara_$1_all(ncid, i, start, edge, value);
        if (canConvert) {
            IF (err != NC_NOERR)
                error("%s", ncmpi_strerror(err));
            ELSE_NOK
        } else {
            IF (err != NC_ECHAR)
                error("wrong type: err = %d", err);
            ELSE_NOK
        }
*/
        for (j = 0; j < var_rank[i]; j++) {
            edge[j] = 1;
        }

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        for (k = 0; k < nslabs; k++) {
            nels = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                nels *= edge[j];
            }
            for (allInExtRange = 1, j = 0; j < nels; j++) {
                err = toMixedBase(j, var_rank[i], edge, index);
                IF (err != NC_NOERR) 
                    error("error in toMixedBase 1");
                for (d = 0; d < var_rank[i]; d++) 
                    index[d] += start[d];
                value[j]= hash_$1(var_type[i], var_rank[i], index, NCT_ITYPE($1));
                IfCheckTextChar($1, var_type[i])
                    allInExtRange &= inRange3(value[j], var_type[i], NCT_ITYPE($1));
            }
            if (var_rank[i] == 0 && i%2 == 0)
                err = ncmpi_put_vara_$1_all(ncid, i, NULL, NULL, value);
            else
                err = ncmpi_put_vara_$1_all(ncid, i, start, edge, value);
            if (canConvert) {
                if (allInExtRange) {
                    IF (err != NC_NOERR) 
                        error("%s", ncmpi_strerror(err));
                    ELSE_NOK
                } else {
                    IF (err != NC_ERANGE)
                        error("expecting range error, but err = %d", err);
                    ELSE_NOK
                }
            } else {
                IF (nels > 0 && err != NC_ECHAR)
                    error("wrong type: err = %d", err);
                ELSE_NOK
            }
        }
    }

    err = ncmpi_close(ncid);
    IF (err != NC_NOERR) 
        error("ncmpi_close: %s", ncmpi_strerror(err));

    nok += check_vars_$1(scratch);

    err = ncmpi_delete(scratch, info);
    IF (err != NC_NOERR)
        error("remove of %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_PUT_VARA(text)
TEST_NC_PUT_VARA(uchar)
TEST_NC_PUT_VARA(schar)
TEST_NC_PUT_VARA(short)
TEST_NC_PUT_VARA(int)
TEST_NC_PUT_VARA(long)
TEST_NC_PUT_VARA(float)
TEST_NC_PUT_VARA(double)
TEST_NC_PUT_VARA(ushort)
TEST_NC_PUT_VARA(uint)
TEST_NC_PUT_VARA(longlong)
TEST_NC_PUT_VARA(ulonglong)


dnl TEST_NC_PUT_VARS(TYPE)
dnl
define(`TEST_NC_PUT_VARS',dnl
`dnl
int
test_ncmpi_put_vars_$1(void)
{
    int ncid, nok=0;
    int d;
    int i;
    int j;
    int k;
    int m;
    int err;
    int nels;
    int nslabs;
    int nstarts;        /* number of different starts */
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    MPI_Offset index2[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    MPI_Offset count[MAX_RANK];
    MPI_Offset sstride[MAX_RANK];
    MPI_Offset stride[MAX_RANK];
    int canConvert;        /* Both text or both numeric */
    int allInExtRange;        /* all values within external range? */
    $1 value[MAX_NELS];

    err = ncmpi_create(comm, scratch, NC_CLOBBER|extra_flags, info, &ncid);
    IF (err != NC_NOERR) {
        error("ncmpi_create: %s", ncmpi_strerror(err));
        return nok;
    }
    def_dims(ncid);
    def_vars(ncid);
    err = ncmpi_enddef(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_enddef: %s", ncmpi_strerror(err));

    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
        }
        err = ncmpi_put_vars_$1_all(BAD_ID, i, start, edge, stride, value);
        IF (err != NC_EBADID) 
            error("expecting bad ncid, but err = %d", err);
        ELSE_NOK
        err = ncmpi_put_vars_$1_all(ncid, BAD_VARID, start, edge, stride, value);
        IF (err != NC_ENOTVAR) 
            error("expecting bad var id, but err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] > 0) {                /* skip record dim */
                start[j] = var_shape[i][j];
                err = ncmpi_put_vars_$1_all(ncid, i, start, edge, stride, value);
                if (!canConvert) {
                    IF (err != NC_ECHAR)
                        error("conversion: err = %d", err);
                    ELSE_NOK
                } else {
                    IF (err != NC_EINVALCOORDS)
                        error("expecting bad start, but err = %d", err);
                    ELSE_NOK
                    start[j] = 0;
                    edge[j] = var_shape[i][j] + 1;
                    err = ncmpi_put_vars_$1_all(ncid, i, start, edge, stride, value);
                    IF (err != NC_EEDGE)
                        error("expecting bad edge, but err = %d", err);
                    ELSE_NOK
                    edge[j] = 1;
                    stride[j] = 0;
                    err = ncmpi_put_vars_$1_all(ncid, i, start, edge, stride, value);
                    IF (err != NC_ESTRIDE)
                        error("expecting bad stride, but err = %d", err);
                    ELSE_NOK
                    stride[j] = 1;
                }
            }
        }

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                for (allInExtRange = 1, j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != NC_NOERR)
                        error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    value[j] = hash_$1(var_type[i], var_rank[i], index2, 
                        NCT_ITYPE($1));
                    IfCheckTextChar($1, var_type[i])
                        allInExtRange &= inRange3(value[j], var_type[i], NCT_ITYPE($1));
                }
                if (var_rank[i] == 0 && i%2 == 0)
                    err = ncmpi_put_vars_$1_all(ncid, i, NULL, NULL, stride, value);
                else
                    err = ncmpi_put_vars_$1_all(ncid, i, index, count, stride, value);
                if (canConvert) {
                    if (allInExtRange) {
                        IF (err != NC_NOERR) 
                            error("%s", ncmpi_strerror(err));
                        ELSE_NOK
                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting range error, but err = %d", err);
                        ELSE_NOK
                    }
                } else {
                    IF (nels > 0 && err != NC_ECHAR)
                        error("wrong type: err = %d", err);
                    ELSE_NOK
                }
            }
        }
    }

    err = ncmpi_close(ncid);
    IF (err != NC_NOERR) 
        error("ncmpi_close: %s", ncmpi_strerror(err));

    nok += check_vars_$1(scratch);

    err = ncmpi_delete(scratch, info);
    IF (err != NC_NOERR)
        error("remove of %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_PUT_VARS(text)
TEST_NC_PUT_VARS(uchar)
TEST_NC_PUT_VARS(schar)
TEST_NC_PUT_VARS(short)
TEST_NC_PUT_VARS(int)
TEST_NC_PUT_VARS(long)
TEST_NC_PUT_VARS(float)
TEST_NC_PUT_VARS(double)
TEST_NC_PUT_VARS(ushort)
TEST_NC_PUT_VARS(uint)
TEST_NC_PUT_VARS(longlong)
TEST_NC_PUT_VARS(ulonglong)


dnl TEST_NC_PUT_VARM(TYPE)
dnl
define(`TEST_NC_PUT_VARM',dnl
`dnl
int
test_ncmpi_put_varm_$1(void)
{
    int ncid, nok=0;
    int d;
    int i;
    int j;
    int k;
    int m;
    int err;
    int nels;
    int nslabs;
    int nstarts;        /* number of different starts */
    MPI_Offset start[MAX_RANK];
    MPI_Offset edge[MAX_RANK];
    MPI_Offset index[MAX_RANK];
    MPI_Offset index2[MAX_RANK];
    MPI_Offset mid[MAX_RANK];
    MPI_Offset count[MAX_RANK];
    MPI_Offset sstride[MAX_RANK];
    MPI_Offset stride[MAX_RANK];
    MPI_Offset imap[MAX_RANK];
    int canConvert;        /* Both text or both numeric */
    int allInExtRange;        /* all values within external range? */
    $1 value[MAX_NELS];

    err = ncmpi_create(comm, scratch, NC_CLOBBER|extra_flags, info, &ncid);
    IF (err != NC_NOERR) {
        error("ncmpi_create: %s", ncmpi_strerror(err));
        return nok;
    }
    def_dims(ncid);
    def_vars(ncid);
    err = ncmpi_enddef(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_enddef: %s", ncmpi_strerror(err));

    for (i = 0; i < numVars; i++) {
        canConvert = (var_type[i] == NC_CHAR) CheckText($1);
        assert(var_rank[i] <= MAX_RANK);
        assert(var_nels[i] <= MAX_NELS);
        for (j = 0; j < var_rank[i]; j++) {
            start[j] = 0;
            edge[j] = 1;
            stride[j] = 1;
            imap[j] = 1;
        }
        err = ncmpi_put_varm_$1_all(BAD_ID, i, start, edge, stride, imap, value);
        IF (err != NC_EBADID) 
            error("expecting bad ncid, but err = %d", err);
        ELSE_NOK
        err = ncmpi_put_varm_$1_all(ncid, BAD_VARID, start, edge, stride, imap, value);
        IF (err != NC_ENOTVAR) 
            error("expecting bad var id, but err = %d", err);
        ELSE_NOK
        for (j = 0; j < var_rank[i]; j++) {
            if (var_dimid[i][j] > 0) {                /* skip record dim */
                start[j] = var_shape[i][j];
                err = ncmpi_put_varm_$1_all(ncid, i, start, edge, stride, imap, value);
                if (!canConvert) {
                    IF (err != NC_ECHAR)
                        error("conversion: err = %d", err);
                    ELSE_NOK
                } else {
                    IF (err != NC_EINVALCOORDS)
                        error("expecting bad start, but err = %d", err);
                    ELSE_NOK
                    start[j] = 0;
                    edge[j] = var_shape[i][j] + 1;
                    err = ncmpi_put_varm_$1_all(ncid, i, start, edge, stride, imap, value);
                    IF (err != NC_EEDGE)
                        error("expecting bad edge, but err = %d", err);
                    ELSE_NOK
                    edge[j] = 1;
                    stride[j] = 0;
                    err = ncmpi_put_varm_$1_all(ncid, i, start, edge, stride, imap, value);
                    IF (err != NC_ESTRIDE)
                        error("expecting bad stride, but err = %d", err);
                    ELSE_NOK
                    stride[j] = 1;
                }
            }
        }

        /* Choose a random point dividing each dim into 2 parts */
        /* Put 2^rank (nslabs) slabs so defined */
        nslabs = 1;
        for (j = 0; j < var_rank[i]; j++) {
            mid[j] = roll( var_shape[i][j] );
            nslabs *= 2;
        }
        /* bits of k determine whether to put lower or upper part of dim */
        /* choose random stride from 1 to edge */
        for (k = 0; k < nslabs; k++) {
            nstarts = 1;
            for (j = 0; j < var_rank[i]; j++) {
                if ((k >> j) & 1) {
                    start[j] = 0;
                    edge[j] = mid[j];
                } else {
                    start[j] = mid[j];
                    edge[j] = var_shape[i][j] - mid[j];
                }
                sstride[j] = stride[j] = edge[j] > 0 ? 1+roll(edge[j]) : 1;
                nstarts *= stride[j];
            }
            for (m = 0; m < nstarts; m++) {
                err = toMixedBase(m, var_rank[i], sstride, index);
                IF (err != NC_NOERR)
                    error("error in toMixedBase");
                nels = 1;
                for (j = 0; j < var_rank[i]; j++) {
                    count[j] = 1 + (edge[j] - index[j] - 1) / stride[j];
                    nels *= count[j];
                    index[j] += start[j];
                }
                /* Random choice of forward or backward */
/* TODO
                if ( roll(2) ) {
                    for (j = 0; j < var_rank[i]; j++) {
                        index[j] += (count[j] - 1) * stride[j];
                        stride[j] = -stride[j];
                    }
                }
*/
                if (var_rank[i] > 0) {
                    j = var_rank[i] - 1;
                    imap[j] = 1;
                    for (; j > 0; j--)
                        imap[j-1] = imap[j] * count[j];
                }
                for (allInExtRange = 1, j = 0; j < nels; j++) {
                    err = toMixedBase(j, var_rank[i], count, index2);
                    IF (err != NC_NOERR)
                        error("error in toMixedBase");
                    for (d = 0; d < var_rank[i]; d++)
                        index2[d] = index[d] + index2[d] * stride[d];
                    value[j] = hash_$1(var_type[i], var_rank[i], index2,
                        NCT_ITYPE($1));
                    IfCheckTextChar($1, var_type[i])
                        allInExtRange &= inRange3(value[j], var_type[i], NCT_ITYPE($1));
                }
                if (var_rank[i] == 0 && i%2 == 0)
                    err = ncmpi_put_varm_$1_all(ncid,i,NULL,NULL,NULL,NULL,value);
                else
                    err = ncmpi_put_varm_$1_all(ncid,i,index,count,stride,imap,value);
                if (canConvert) {
                    if (allInExtRange) {
                        IF (err != NC_NOERR)
                            error("%s", ncmpi_strerror(err));
                        ELSE_NOK
                    } else {
                        IF (err != NC_ERANGE)
                            error("expecting range error, but err = %d", err);
                        ELSE_NOK
                    }
                } else {
                    IF (nels > 0 && err != NC_ECHAR)
                        error("wrong type: err = %d", err);
                    ELSE_NOK
                }
            }
        }
    }

    err = ncmpi_close(ncid);
    IF (err != NC_NOERR) 
        error("ncmpi_close: %s", ncmpi_strerror(err));

    nok += check_vars_$1(scratch);

    err = ncmpi_delete(scratch, info);
    IF (err != NC_NOERR)
        error("remove of %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_PUT_VARM(text)
TEST_NC_PUT_VARM(uchar)
TEST_NC_PUT_VARM(schar)
TEST_NC_PUT_VARM(short)
TEST_NC_PUT_VARM(int)
TEST_NC_PUT_VARM(long)
TEST_NC_PUT_VARM(float)
TEST_NC_PUT_VARM(double)
TEST_NC_PUT_VARM(ushort)
TEST_NC_PUT_VARM(uint)
TEST_NC_PUT_VARM(longlong)
TEST_NC_PUT_VARM(ulonglong)


int
test_ncmpi_put_att_text(void)
{
    int ncid, nok=0;
    int i;
    int j;
    MPI_Offset k;
    int err;
    text value[MAX_NELS];

    err = ncmpi_create(comm, scratch, NC_NOCLOBBER|extra_flags, info, &ncid);
    IF (err != NC_NOERR) {
        error("ncmpi_create: %s", ncmpi_strerror(err));
        return nok;
    }
    def_dims(ncid);
    def_vars(ncid);

    {
        const char *const tval = "value for bad name";
        const size_t tval_len = strlen(tval);
        
        err = ncmpi_put_att_text(ncid, 0, "", tval_len, tval);
        IF (err != NC_EBADNAME)
           error("should be NC_EBADNAME: err = %d", err);
        ELSE_NOK
    }
    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            if (ATT_TYPE(i,j) == NC_CHAR) {
                assert(ATT_LEN(i,j) <= MAX_NELS);
                err = ncmpi_put_att_text(BAD_ID, i, ATT_NAME(i,j), ATT_LEN(i,j), 
                    value);
                IF (err != NC_EBADID)
                    error("expecting bad ncid, but err = %d", err);
                ELSE_NOK
                err = ncmpi_put_att_text(ncid, BAD_VARID, ATT_NAME(i,j), 
                    ATT_LEN(i,j), value);
                IF (err != NC_ENOTVAR)
                    error("expecting bad var id, but err = %d", err);
                ELSE_NOK
                for (k = 0; k < ATT_LEN(i,j); k++) {
                    value[k] = hash(ATT_TYPE(i,j), -1, &k);
                }
                err = ncmpi_put_att_text(ncid, i, ATT_NAME(i,j), 
                    ATT_LEN(i,j), value);
                IF (err != NC_NOERR)
                    error("%s", ncmpi_strerror(err));
                ELSE_NOK
            }
        }
    }

    nok += check_atts_text(ncid);
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));

    err = ncmpi_delete(scratch, info);
    IF (err != NC_NOERR)
        error("remove of %s failed", scratch);
    return nok;
}


dnl TEST_NC_PUT_ATT(TYPE)         numeric only
dnl
define(`TEST_NC_PUT_ATT',dnl
`dnl
int
test_ncmpi_put_att_$1(void)
{
    int ncid, nok=0;
    int i;
    int j;
    MPI_Offset k;
    int err;
    $1 value[MAX_NELS];
    int allInExtRange;  /* all values within external range? */

    err = ncmpi_create(comm, scratch, NC_NOCLOBBER|extra_flags, info, &ncid);
    IF (err != NC_NOERR) {
        error("ncmpi_create: %s", ncmpi_strerror(err));
        return nok;
    }
    def_dims(ncid);
    def_vars(ncid);

    for (i = -1; i < numVars; i++) {
        for (j = 0; j < NATTS(i); j++) {
            if (!(ATT_TYPE(i,j) == NC_CHAR)) {
                assert(ATT_LEN(i,j) <= MAX_NELS);
                err = ncmpi_put_att_$1(BAD_ID, i, ATT_NAME(i,j), ATT_TYPE(i,j), 
                    ATT_LEN(i,j), value);
                IF (err != NC_EBADID)
                    error("expecting bad ncid, but err = %d", err);
                ELSE_NOK
                err = ncmpi_put_att_$1(ncid, BAD_VARID, ATT_NAME(i,j), 
                    ATT_TYPE(i,j), ATT_LEN(i,j), value);
                IF (err != NC_ENOTVAR)
                    error("expecting bad var id, but err = %d", err);
                ELSE_NOK
                err = ncmpi_put_att_$1(ncid, i, ATT_NAME(i,j), BAD_TYPE, 
                    ATT_LEN(i,j), value);
                IF (err != NC_EBADTYPE)
                    error("expecting bad type, but err = %d", err);
                ELSE_NOK
                for (allInExtRange = 1, k = 0; k < ATT_LEN(i,j); k++) {
                    value[k] = hash_$1(ATT_TYPE(i,j), -1, &k, NCT_ITYPE($1));
                    IfCheckTextChar($1, ATT_TYPE(i,j))
                        allInExtRange &= inRange3(value[k], ATT_TYPE(i,j), NCT_ITYPE($1));
                }
                err = ncmpi_put_att_$1(ncid, i, ATT_NAME(i,j), ATT_TYPE(i,j),
                    ATT_LEN(i,j), value);
                if (allInExtRange) {
                    IF (err != NC_NOERR)
                        error("%s", ncmpi_strerror(err));
                    ELSE_NOK
                } else {
                    IF (err != NC_ERANGE)
                        error("expecting range error, but err = %d", err);
                    ELSE_NOK
                }
            }
        }
    }

    nok += check_atts_$1(ncid);
    err = ncmpi_close(ncid);
    IF (err != NC_NOERR)
        error("ncmpi_close: %s", ncmpi_strerror(err));

    err = ncmpi_delete(scratch, info);
    IF (err != NC_NOERR)
        error("remove of %s failed", scratch);
    return nok;
}
')dnl

TEST_NC_PUT_ATT(uchar)
TEST_NC_PUT_ATT(schar)
TEST_NC_PUT_ATT(short)
TEST_NC_PUT_ATT(int)
TEST_NC_PUT_ATT(long)
TEST_NC_PUT_ATT(float)
TEST_NC_PUT_ATT(double)
TEST_NC_PUT_ATT(ushort)
TEST_NC_PUT_ATT(uint)
TEST_NC_PUT_ATT(longlong)
TEST_NC_PUT_ATT(ulonglong)

