use strict;
use Data::Dumper;
use Wx qw/
             wxVERTICAL
             wxSWISS
             wxNORMAL
             wxBOLD
             wxALIGN_CENTER
             wxEXPAND
             wxALL
             wxDefaultSize
             wxDefaultPosition
         /;
use Uploader::GUI::wxCategoryTreeCtrl;

use vars qw($CHOOSE_DESTINATION); $CHOOSE_DESTINATION = 10000;
use vars qw($DESTINATION_CATEGORIES); $DESTINATION_CATEGORIES = 10001;
use vars qw($DESTINATION_CATEGORIES_OK); $DESTINATION_CATEGORIES_OK = 10002;
use vars qw($DESTINATION_CATEGORIES_CANCEL); $DESTINATION_CATEGORIES_CANCEL = 10003;


sub DestinationCategory {
    my ( $parent, $params ) = @_;


    my( $top_sizer ) = Wx::BoxSizer->new( wxVERTICAL );
    

    my( $item1 ) = Wx::StaticText->new(
        $parent,
        $main::CHOOSE_DESTINATION,
        "",
        wxDefaultPosition,
        [-1,40],
        0
    );
    my $btfont = Wx::Font->new(12, wxSWISS, wxNORMAL, wxNORMAL );
    $item1->SetFont($btfont);


    $top_sizer->AddWindow( $item1, 0, wxALIGN_LEFT|wxALL, 5 );
    $top_sizer->AddWindow(
        Uploader::GUI::wxCategoryTreeCtrl->new(
            {
                parentwnd      => $parent,
                id             => $main::DESTINATION_CATEGORIES,
                categories     => $params->{categories}, 
                frame_callback => $params->{frame_callback}, 
            }
        ), 1, wxEXPAND|wxALL, 5 );

    my( $item2 ) = Wx::StdDialogButtonSizer->new();
    $item2->SetAffirmativeButton( Wx::Button->new( $parent, $main::DESTINATION_CATEGORIES_OK, "" ) );
    $item2->SetCancelButton( Wx::Button->new( $parent, $main::DESTINATION_CATEGORIES_CANCEL, "" ) );
    $item2->Realize();
    $top_sizer->Add( $item2, 0, wxEXPAND|wxALL, 5 );


    $parent->SetSizer( $top_sizer );
    #$top_sizer->Fit( $parent );

    $top_sizer;
}

1;
