Author: Andreas Tille <tille@debian.org>
Last-Update: Tue, 09 Feb 2016 10:20:36 +0100
Description: Adapt test script to Debian installation

--- a/scripts/test-plast.sh
+++ b/scripts/test-plast.sh
@@ -15,14 +15,17 @@
 # *****************************************************************************/
 
 # We get the directory of the script (absolute path)
-_scripts_dir=$( cd -P -- "$(dirname -- "$(command -v -- "$0")")" && pwd -P )
-_result=$_scripts_dir/out.txt
+#_scripts_dir=$( cd -P -- "$(dirname -- "$(command -v -- "$0")")" && pwd -P )
+BUILD_DIR=obj-$(dpkg-architecture -qDEB_HOST_GNU_TYPE)
+DATA_DIR=$(pwd)/db
+_script=`find $(pwd)/obj-x86_64-linux-gnu/bin -name plast -executable`
+_result=`dirname $_script`/out.txt
 
 echo "Start PLAST..."
 echo
 
 # We setup a PLAST command-line and run it to test the software
-_cmdline="$_scripts_dir/../build/bin/plast -p plastp -i $_scripts_dir/../db/query.fa -d $_scripts_dir/../db/tursiops.fa -o $_result"
+_cmdline="$_script -p plastp -i ${DATA_DIR}/query.fa -d ${DATA_DIR}/tursiops.fa -o $_result"
 
 echo $_cmdline
 
