/***********************************************************************************
* Smooth Tasks
* Copyright (C) 2009 Mathias Panzenböck <grosser.meister.morti@gmx.net>
* Copyright (C) 2009-2010 Toni Dietze <smooth-tasks@derflupp.e4ward.com>
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*
***********************************************************************************/

#include "SmoothTasks/FixedItemCountTaskbarLayout.h"

#include <QApplication>

#include <cmath>

namespace SmoothTasks {

void FixedItemCountTaskbarLayout::setItemsPerRow(int itemsPerRow) {
	if (m_itemsPerRow != itemsPerRow) {
		m_itemsPerRow = itemsPerRow;
		invalidate();
	}
}

int FixedItemCountTaskbarLayout::optimumCapacity() const {
	return m_itemsPerRow * maximumRows();
}

void FixedItemCountTaskbarLayout::updateLayoutStatic() {
	const bool isVertical = orientation() == Qt::Vertical;
	
	const int N = items().size();
	
	const QRectF effectiveRect(effectiveGeometry());
	const qreal availableHeight = isVertical ? effectiveRect.width()  : effectiveRect.height();
	const qreal spacing         = this->spacing();
	
#define CELL_HEIGHT(ROWS) (((availableHeight + spacing) / ((qreal) (ROWS))) - spacing)
	
	// if there is nothing to layout fill in some dummy data and leave
	if (N == 0) {
		m_rows = minimumRows();
		m_cellHeight = CELL_HEIGHT(m_rows);
		m_rowInfos.clear();
		return;
	}
	
	int itemsPerRow = m_itemsPerRow;
	int rows = maximumRows();
	
	if (itemsPerRow * rows < N) {
		itemsPerRow = std::ceil(((qreal) N) / rows);
	}
	else {
		rows = std::ceil(((qreal) N) / itemsPerRow);
	}
	
	QList<RowInfo> rowInfos;
	
	buildRows(itemsPerRow, rowInfos, rows);
	
	m_rows = rows;
	m_cellHeight = CELL_HEIGHT(m_rows);
	m_rowInfos = rowInfos;
	updateItemsRowCache();
	
#undef CELL_HEIGHT
}

} // namespace SmoothTasks
