<?php

/**
* All functions relevant to creating and displaying color ranges
*
* @version 0.3
* @author  Matt McClanahan <cardinal@dodds.net>
* @package Imlib
* @access public
*/
class ImlibColorRange extends ImlibCliprect
{
   /**
   * Resource id# of the current color range
   *
   * @access private
   */
   var $cr;

   /**
   * Resource id# of the image to draw on
   *
   * @access private
   */
   var $im;

   /**
   * ImlibColorRange constructor
   *
   * @access public
   */
   function ImlibColorRange()
   {
      $this->cr = 0;
      $this->im = 0;
   }

   /**
   * Add a color to the color range at distance $x.
   *
   * A distance of 0 will center it between the previous color and the end.
   * $x is ignored for the first color.
   *
   * @param int Distance from the previous color
   * @param int Red
   * @param int Blue
   * @param int Green
   * @param int Alpha
   * @access public
   */
   function add_color($x,$r,$g,$b,$a)
   {
      if (!is_resource($this->cr))
         return false;

      imlib_add_color_to_color_range($this->cr,$x,$r,$g,$b,$a);
   }

   /**
   * Add a color to the color range at distance $x.
   *
   * A distance of 0 will center it between the previous color and the end.
   * $x is ignored for the first color.
   *
   * @param int Distance from the previous color
   * @param array Color array (r,g,b,a)
   * @access public
   */
   function add_color_array($x,$arr)
   {
      list($r,$g,$b,$a) = $arr;
      $this->add_color($x,$r,$g,$b,$a);
   }

   /**
   * Create a new color range
   *
   * @return int Resource id# of the new color range
   * @access public
   */
   function create()
   {
      if (is_resource($this->cr))
         return false;

      return $this->cr = imlib_create_color_range();
   }

   /**
   * Free the current color range
   *
   * @access public
   */
   function free()
   {
      if (!is_resource($this->cr))
         return false;

      imlib_free_color_range($this->cr);
      unset($this->cr);
   }

   /**
   * Fill the current image with a rectangle using the current color range
   *
   * The color range will be filled in the specified box at angle $angle
   *
   * @param int Upper-left X coordinate of the box
   * @param int Upper-left Y coordinate of the box
   * @param int Width of the box
   * @param int Height of the box
   * @param int Angle to rotate the color range (degrees)
   * @access public
   */
   function fill_rectangle($x,$y,$w,$h,$angle)
   {
      if (!is_resource($this->im) || !is_resource($this->cr))
         return false;

      if ($this->cliprect_inuse)
         return imlib_image_fill_color_range_rectangle($this->im,$this->cr,
                      $x,$y,$w,$h,$angle,$this->get_cliprect_array());
      else
         return imlib_image_fill_color_range_rectangle($this->im,$this->cr,
                      $x,$y,$w,$h,$angle);
   }

   /**
   * Set the image to draw the color range on
   *
   * @param int Resource id# of the image
   * @access public
   */
   function set_image($im)
   {
      if (is_resource($im))
         $this->im = $im;
   }
};

?>
