%feature("docstring") PERSALYS::FieldMonteCarloResult
"Get the results of a Monte Carlo analysis with mesh."


// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldMonteCarloResult::getCorrelationFunction
"Correlation function accessor.

Returns
-------
functions : sequence of :py:class:`openturns.Function`
    Correlation function for each output"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldMonteCarloResult::getKarhunenLoeveResult
"Karhunen Loeve result accessor.

Parameters
----------
index : int
    Index of the output

Returns
-------
result : :py:class:`openturns.KarhunenLoeveResult`
    Karhunen Loeve result for an output"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldMonteCarloResult::getMeanSample
"Mean trajectory accessor.

Returns
-------
sample : :py:class:`openturns.Sample`
    Mean trajectory for each output"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldMonteCarloResult::getProcessSample
"Output values accessor.

Returns
-------
sample : :py:class:`openturns.ProcessSample`
    Output values"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldMonteCarloResult::getLowerQuantileSample
"Lower quantile accessor.

Returns
-------
sample : :py:class:`openturns.Sample`
    Lower quantile trajectory for each output at *level* defined in
    :meth:`persalys.FieldMonteCarloAnalysis.getQuantileLevel`"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldMonteCarloResult::getUpperQuantileSample
"Upper quantile accessor.

Returns
-------
sample : :py:class:`openturns.Sample`
    Upper quantile trajectory for each output at *1-level* defined in
    :meth:`persalys.FieldMonteCarloAnalysis.getQuantileLevel`"

// ---------------------------------------------------------------------

%feature("docstring") PERSALYS::FieldMonteCarloResult::getXiSamples
":math:`X_i` distribution values accessor.

Returns
-------
samples : sequence of :py:class:`openturns.Sample`
    Distribution values of the :math:`X_i` variables of the Karhunen Loeve decomposition"
