# Compiling PowerDNS
PowerDNS can be compiled with modules built in, or with modules designed to be
loaded at runtime. All that is configured before compiling using the well known
autoconf/automake system.

PowerDNS requires 'Boost' to compile, it is available for most operating
systems. Otherwise, see [the Boost website](http://www.boost.org).

To compile in modules, specify them as `--with-modules='mod1 mod2 mod3'`,
substituting the desired module names. Each backend has a module name that you
look up in this [table](../authoritative/index.md#backend-capibilities).

To compile a module for inclusion at runtime, which is great if you are a unix
vendor, use `--with-dynmodules='mod1 mod2 mod3'`. These modules then end up as
.so files in the compiled libdir.

## Getting the sources
There are 3 ways of getting the source. If you want the bleeding edge, you can
clone the repository at [GitHub](https://github.com/PowerDNS/pdns) and run
`./bootstrap` in the clone.

You can also download snapshot tarballs generated by Jenkins and can be found
[here](https://autotest.powerdns.com/).

You can also download releases on the [website](https://downloads.powerdns.com/releases/).
These releases are PGP-signed with key-id [FBAE 0323 821C 7706 A5CA 151B DCF5
13FA 7EED 19F3](https://pgp.mit.edu/pks/lookup?op=get&search=0xDCF513FA7EED19F3)
or [1628 90D0 689D D12D D33E 4696 1C5E
E990 D2E7 1575](https://pgp.mit.edu/pks/lookup?op=get&search=0x1C5EE990D2E71575).

## OS specific gotcha's
### AIX
It is unknown if PowerDNS compiles on AIX.

### FreeBSD
Works fine, but use gmake.

The FreeBSD Boost include files are installed in `/usr/local/include`, so prefix
`CXXFLAGS=-I/usr/local/include` to your `./configure` invocation.

### Linux
Linux is probably the best supported platform as most of the main coders are
Linux users. The static DEB distribution is known to have problems on Debian
'Sid', but that doesn't matter as PowerDNS is a native part of Debian 'Sid'.
Just `apt-get`!

### Mac OS X
The [installation from Homebrew](../authoritative/installation.md#mac-os-x)
for the authoritative server should work, event though not all commits are
tested on OS X.

The recursor has been reported to crash for some OS X users.

### OpenBSD 5.8
Compiles, but use gmake and g++-4.9.3 or higher.

### Solaris
Solaris 8 and 9 work fine. The 'Sunpro' compiler has not been tried but is
reported to be lacking large parts of the Standard Template Library, which
PowerDNS relies on heavily. Use gcc and gmake (if available). Regular Solaris 
make has some issues with some PowerDNS Makefile constructs.

When compiling, make sure that you have `/usr/ccs/bin` in your path.
Furthermore, with some versions of MySQL, you may have to add `LDFLAGS=-lz`
before `./configure`.
