#include "Platform.h"
#include <string.h>
#include <stdio.h>
#include <time.h>
#include "Reader.h"
#include "RFCReader.h"
#include "BaseCommunication.h"

#include "memory_placements.h"


#define base CRFSReader

CRFCReader::CRFCReader(CReader *Owner,CBaseCommunication *Communicator)
			  :base(Owner,Communicator)
{}

CRFCReader::~CRFCReader(void)
{
}

void CRFCReader::SetHWString(char *String)
{
   strcpy(String,"RFC_");
}

void CRFCReader::GetProductString(uint8_t *Product)
{
	memcpy(Product,"CJRFC",5);
}

CJ_RESULT CRFCReader::CtSetBacklight(EBacklight eBacklight,uint32_t *Result)
{
	CJ_RESULT Res;
	switch(eBacklight)
	{
	case BacklightOff:
		Res=_CtSetBacklight(0,Result);
		break;
	case BacklightVeryLow:
		Res=_CtSetBacklight(70,Result);
		break;
	case BacklightLow:
		Res=_CtSetBacklight(100,Result);
		break;
	case BacklightMedium:
		Res=_CtSetBacklight(120,Result);
		break;
	case BacklightHigh:
		Res=_CtSetBacklight(160,Result);
		break;
	case BacklightVeryHigh:
		Res=_CtSetBacklight(255,Result);
		break;
	default:
		Res=CJ_ERR_WRONG_PARAMETER;
	}
	return Res;
}

CJ_RESULT CRFCReader::CtSetMFT(const uint8_t *const pData, uint32_t DataLen, uint32_t *Result)
{
	UNREFERENCED_PARAMETER(Result);
	UNREFERENCED_PARAMETER(DataLen);
	UNREFERENCED_PARAMETER(pData);

	m_Owner->DebugResult("%s --> %s", __FUNCTION__, "SCARD_E_UNSUPPORTED_FEATURE");
	return SCARD_E_UNSUPPORTED_FEATURE; 
}

CJ_RESULT CRFCReader::CtGetMFT(cj_MFT_Info *const pData, uint32_t *const pNumElemnts)
{
	UNREFERENCED_PARAMETER(pData);

	*pNumElemnts = 0;
	m_Owner->DebugResult("%s --> %s", __FUNCTION__, "SCARD_E_UNSUPPORTED_FEATURE");
	return SCARD_E_UNSUPPORTED_FEATURE;
}

#ifdef WITH_SECODER_INFO_OVERRIDE
CJ_RESULT CRFCReader::KTLightCall(uint8_t *sad, uint8_t *dad, uint8_t *cmd, uint16_t lenc, int32_t Lc, uint8_t *data_ptr, int32_t Le, uint8_t *response, uint16_t *lenr)
{
	return CEC30Reader::KTLightCall(sad, dad, cmd, lenc, Lc, data_ptr, Le, response, lenr);
}
#endif
