# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.

from pkg_resources import get_distribution
from sphinx_astropy.conf.v1 import *

# -- Project information -----------------------------------------------------

project = 'Parfive'
copyright = '2018, Stuart Mumford'
author = 'Stuart Mumford'

release = get_distribution('parfive').version
# for example take major/minor
version = '.'.join(release.split('.')[:2])


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ['_build', 'Thumbs.db', '.DS_Store']

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None


# -- Options for HTML output -------------------------------------------------

try:
    from sunpy_sphinx_theme.conf import *
except ImportError:
    html_theme = 'alabaster'

html_theme_options = {'logo_url': 'https://parfive.readthedocs.io/en/latest/'}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'Parfivedoc'


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {'https://docs.python.org/': None,
                       'http://aiohttp.readthedocs.io/en/stable': None,
                       'https://aioftp.readthedocs.io/': None}
