/*
 * Copyright (C) 2005-2017 Centre National d'Etudes Spatiales (CNES)
 *
 * This file is part of Orfeo Toolbox
 *
 *     https://www.orfeo-toolbox.org/
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


#include "otbVectorDataToRightAngleVectorDataFilter.h"

#include "otbVectorData.h"
#include "otbVectorDataFileReader.h"
#include "otbVectorDataFileWriter.h"

#include "otbImage.h"
#include "otbImageFileWriter.h"


int otbVectorDataToRightAngleVectorDataFilterNew(int itkNotUsed(argc), char * itkNotUsed(argv) [])
{
  /** Typedefs */
  typedef otb::VectorData< >                    VectorDataType;
  typedef otb::VectorDataToRightAngleVectorDataFilter<VectorDataType>
                                                RightAngleFilterType;

  RightAngleFilterType::Pointer filter  = RightAngleFilterType::New();

  std::cout << filter << std::endl;

  return EXIT_SUCCESS;
}


int otbVectorDataToRightAngleVectorDataFilter(int itkNotUsed(argc), char * argv[])
{
  const char * infname  = argv[1];
  const char * outfname = argv[2];

  /** Typedefs */
  typedef otb::VectorData< >                          VectorDataType;
  typedef otb::VectorDataToRightAngleVectorDataFilter<VectorDataType>
                                                      RightAngleFilterType;

  typedef otb::VectorDataFileReader<VectorDataType>   vDataReaderType;
  typedef otb::VectorDataFileWriter<VectorDataType>   vDataWriterType;

  // Create instances
  vDataReaderType::Pointer      vDataReader       = vDataReaderType::New();
  RightAngleFilterType::Pointer rightAngleFilter  = RightAngleFilterType::New();
  vDataWriterType::Pointer      vDataWriter       = vDataWriterType::New();

  // Begin the process
  vDataReader->SetFileName(infname);
  rightAngleFilter->SetInput(vDataReader->GetOutput());
  rightAngleFilter->SetDistanceThreshold(10.0);
  rightAngleFilter->SetAngleThreshold(3.141592/18.0);
  vDataWriter->SetFileName(outfname);
  vDataWriter->SetInput(rightAngleFilter->GetOutput());
  vDataWriter->Update();

  return EXIT_SUCCESS;
}
