# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-850-3 (poppler)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(66308);
 script_cve_id("CVE-2009-3603", "CVE-2009-3604", "CVE-2009-3607", "CVE-2009-3608", "CVE-2009-3609");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"9.3");
 script_tag(name:"risk_factor", value:"Critical");
 script_name("Ubuntu USN-850-3 (poppler)");

 desc = "The remote host is missing an update to poppler
announced via advisory USN-850-3.

Details follow:

USN-850-1 fixed vulnerabilities in poppler. This update provides the
corresponding updates for Ubuntu 9.10.

Original advisory details:

 It was discovered that poppler contained multiple security issues when
 parsing malformed PDF documents. If a user or automated system were tricked
 into opening a crafted PDF file, an attacker could cause a denial of
 service or execute arbitrary code with privileges of the user invoking the
 program.

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 9.10:
  libpoppler-glib4                0.12.0-0ubuntu2.1
  libpoppler5                     0.12.0-0ubuntu2.1

In general, a standard system upgrade is sufficient to effect the
necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-850-3

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-850-3 (poppler)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpoppler-dev", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-glib-dev", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-glib4", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt-dev", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt2", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt4-3", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler-qt4-dev", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpoppler5", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"poppler-dbg", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"poppler-utils", ver:"0.12.0-0ubuntu2.1", rls:"UBUNTU9.10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
