###################################################################
# OpenVAS Network Vulnerability Test
#
# SMB NativeLanMan
#
# LSS-NVT-2009-011
#
# Developed by LSS Security Team <http://security.lss.hr>
#
# Copyright (C) 2009 LSS <http://www.lss.hr>
#
# This program is free software: you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation, either version 2 of
# the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this program. If not, see
# <http://www.gnu.org/licenses/>.
###################################################################

desc = "
Overview:
It is possible to extract OS, domain and SMB server information
from the Session Setup AndX Response packet which is generated
during NTLM authentication.
";

if (description) {
 script_id(102011);
 script_version("1.0");
 script_tag(name:"risk_factor", value:"None");
 script_name("SMB NativeLanMan");
 script_description(desc);
 script_summary("Extracts info about the OS through NTLM authentication packets");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("Copyright (C) 2009 LSS");
 exit(0);
}

include ("misc_func.inc");
include ("smb_nt.inc");
include ("global_settings.inc");

port = kb_smb_transport();
if(!port){
 port = 139;
}

soc = open_sock_tcp(port);
if(!soc){
 exit(0);
}

r = smb_session_request(soc:soc, remote:name);
if(!r){
 close(soc);
 exit(0);
}

r = smb_neg_prot_NTLMv1(soc);
r = smb_session_setup_NTLMvN(soc, "anonymous", "password", "domain", "cs", "version");
close (soc);

s = hexstr(r);  # convert response packet to a "string" hex
l = strlen(s);
c = 0;          # counter

# according to www.snia.org/tech_activities/CIFS/CIFS-TR-1p00_FINAL.pdf
# domain, server & os info are the last 3 strings in the packet
# so there is no point in going through the whole packet

for (x=l-3; x>0 && c<3 ; x=x-2) {
 if ( (s[x]+s[x-1]) == "00") {
  c++;
  if (c==1) {
   set_kb_item (name:"SMB/workgroup", value:hex2raw(s:out));
   set_kb_item (name:"SMB/DOMAIN", value:hex2raw(s:out));
   info="Detected SMB workgroup: "+hex2raw(s:out)+'\n';
   desc+=info;
  }
  if (c==2) {
   set_kb_item(name:"SMB/NativeLanManager", value:hex2raw(s:out));
   set_kb_item(name:"SMB/SERVER", value:hex2raw(s:out));
   info="Detected SMB server: "+hex2raw(s:out)+'\n';
   desc+=info;
  }
  if (c==3) {
   set_kb_item(name:"Host/OS/smb", value:hex2raw(s:out));
   set_kb_item(name:"SMB/OS", value:hex2raw(s:out));
   info="Detected OS: "+hex2raw(s:out)+'\n';
   desc+=info;
   if(report_verbosity) {
    security_note(port:port, data:desc);
   }
  }
  out = NULL;
 } else {
  out = s[x-1] + s[x] + out;
 }
}

