##############################################################################
#
#  MailEnable IMAP Denial of Service Vulnerability 
#
#  Copyright: SecPod
#
#  Date Written: 2008/08/06
#
#  Revision: 1.2
#
#  Log: ssharath
#  Issue #0080
#  ------------------------------------------------------------------------
#  This program was written by SecPod and is licensed under the GNU GPL 
#  license. Please refer to the below link for details,
#  http://www.gnu.org/licenses/gpl.html
#  This header contains information regarding licensing terms under the GPL, 
#  and information regarding obtaining source code from the Author. 
#  Consequently, pursuant to section 3(c) of the GPL, you must accompany the 
#  information found in this header with any distribution you make of this 
#  Program.
#  ------------------------------------------------------------------------
##############################################################################


if(description)
{
 script_id(900104);
 script_cve_id("CVE-2008-3449");
 script_bugtraq_id(30498);
 script_copyright("Copyright (C) 2008 SecPod");
 script_version("$Revision: 1.2 $");
 script_tag(name:"cvss_base", value:"6.3");
 script_tag(name:"risk_factor", value:"High");
 script_category(ACT_GATHER_INFO);
 script_family("Denial of Service");
 script_name(" MailEnable IMAP Denial of Service Vulnerability");
 script_summary("Check for vulnerable version of MailEnable");
 desc = "
 Overview : The host is running MailEnable Mail Server, which prone to Denial
 of Service vulnerability.
	
 Vulnerability Insight :

	The flaw exists due to the load created when handling multiple IMAP connections
	to the same folder.

        Impact : Successful exploitation will potentially cause a service crash.

 Impact Level : Application

 Affected Software/OS :
	MailEnable Enterprise Edition 3.52 and Professional Edition 3.52
	and prior on Windows (all)

 Fix : Apply Patch,
 http://www.mailenable.com/hotfix/ME-10042.EXE

 References :
 http://www.mailenable.com/hotfix/
 http://secunia.com/advisories/31325

 CVSS Score :
        CVSS Base Score     : 6.3 (AV:N/AC:M/Au:SI/C:N/I:N/A:C) 
        CVSS Temporal Score : 4.7
 Risk factor : Medium";
 script_description(desc);
 script_dependencies("secpod_reg_enum.nasl");
 script_require_keys("SMB/WindowsVersion");
 script_require_ports(139, 445);
 exit(0);
}


 include("smb_nt.inc");
 include("imap_func.inc");
 
 if(!get_kb_item("SMB/WindowsVersion")){
        exit(0);
 }

 port = get_kb_item("Services/imap");
 if(!port) {
	port = 143;
 }

 if(!get_port_state(port)){
	exit(0);
 }

 if("IMAP4rev1" >!< get_imap_banner(port)){
        exit(0);
 }

 mailVer = registry_get_sz(key:"SOFTWARE\Mail Enable\Mail Enable",
			   item:"Professional Version");
 if(!mailVer)
 {
        mailVer = registry_get_sz(key:"SOFTWARE\Mail Enable\Mail Enable",
                                  item:"Enterprise Version");
	if(!mailVer){
		exit(0);
 	}
 }

 if(registry_key_exists(key:"SOFTWARE\Mail Enable\Mail Enable\Updates\ME-10042")){
		exit(0);
 }

 if(egrep(pattern:"^([0-2]\..*|3\.([0-4]?[0-9]|5[0-2]))$", string:mailVer)){
	security_warning(port);
 }
