###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_hamster_audio_player_bof_vuln.nasl 3579 2009-07-22 16:52:02Z jul $
#
# Hamster Audio Player Buffer Overflow Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900693);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-2550");
  script_name("Hamster Audio Player Buffer Overflow Vulnerability");
  desc = "

  Overview: This host is installed with Hamster Audio player and is prone
  to Stack Overflow Vulnerability.

  Vulnerability Insight:
  This flaw is due to improper bounds checking when processing .m3u files
  and can be exploited by persuading a victim to open a specially-crafted
  .m3u or .hpl playlist file containing an overly long string.

  Impact:
  Successful exploitation allows the attacker to execute arbitrary code on
  the system or cause the application to crash.

  Impact Level:System/Application

  Affected Software/OS:
  Hamster Audio Player 0.3a and prior on Windows.

  Fix:
  No solution or patch is available as on th 22nd July, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,http://www.ondanera.net/eng/download.html 

  References:
  http://secunia.com/advisories/35825
  http://www.milw0rm.com/exploits/9172
  http://xforce.iss.net/xforce/xfdb/51732
  
  CVSS Score:
    CVSS Base Score      : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C) 
    CVSS Temporal Score  : 8.4 
  Risk factor: Critical"; 
  
  script_description(desc);
  script_summary("Check for the Version of Hamster Audio Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Buffer overflow");
  script_dependencies("secpod_hamster_audio_player_detect.nasl");
  script_require_keys("Hamster/Audio-Player/Ver");
  exit(0);
}


include("version_func.inc");

hamsterVer = get_kb_item("Hamster/Audio-Player/Ver");
if(hamsterVer != NULL)
{
  if(version_is_less_equal(version:hamsterVer, test_version:"0.3a")){
    security_hole(0);
  }
}
