# gentoocheck is intended to provide a quick way to verify that
# a given gentoo pkg, if it is installed, is up to date.
# ispkgvuln returns 0 if it is not installed or is installed
# but up to date, and returns 1 if it is installed and vulnerable

function ispkgvuln(pkg, unaffected, vulnerable) {
    local_var kbrls, pkgs, narrowed, list, vver, vvercomp, rc, res, sub;

    # Check that we have the data for this release.
    kbrls = get_kb_item("ssh/login/release");
    if(kbrls!="GENTOO") {
	return(0);
    }
    pkgs = get_kb_item("ssh/login/pkg");
    if(!pkgs) return(0);
    narrowed = egrep(pattern:"^" + pkg + "-[0-9]", string:pkgs);
    if(!narrowed) return(0);
    list = split(narrowed, sep:'\n', keep:0);
    foreach package (list) {
	# First check if anything is matches the vulnerable versions
	foreach vver (vulnerable) {
	    vvercomp = split(vver, sep:' ', keep:0);
	    rc = revcomp(a:package, b:pkg + "-" + vvercomp[1]);
	    res = 0;
	    if(vvercomp[0]=="lt" && rc<0) res = 1;
	    if(vvercomp[0]=="le" && rc<=0) res = 1;
	    if(vvercomp[0]=="gt" && rc>0) res = 1;
	    if(vvercomp[0]=="ge" && rc>=0) res = 1;
	    if(vvercomp[0]=="eq" && rc==0) res = 1;
	}
	# If no vulnerability versions match, exit now.
	if(res==0) {
	    return(0);
	}
	# If we get here, we got a match. Check now to see if it
	# matches any of our unaffected versions.
	foreach vver (unaffected) {
	    rc = revcomp(a:package, b:pkg + "-" + vvercomp[1]);
	    if(vvercomp[0]=="lt" && rc<0) res = 0;
	    if(vvercomp[0]=="le" && rc<=0) res = 0;
	    if(vvercomp[0]=="gt" && rc>0) res = 0;
	    if(vvercomp[0]=="ge" && rc>=0) res = 0;
	    if(vvercomp[0]=="eq" && rc==0) res = 0;
	    if((vvercomp[0]=="rge" && rc>=0) || (vvercomp[0]=="rgt" && rc>0)) {
		sub = eregmatch(pattern:"(.*-r)[0-9]+$", string:vvercomp[1]);
		if(!sub) sub = vvercomp[1];
		if(sub >< package) res = 0;
	    }
	}
	if(res==1) {
	    security_note(0, data: "Package " + package + 
		    " is installed which is known to be vulnerable.");
	    return(1);
	}
    }

    return(0);
}
