###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ms_ie_detect.nasl 714 2008-12-17 13:15:29Z dec $
#
# Microsoft Internet Explorer Version Detection (Win)
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2008 Intevation GmbH, http://www.intevation.net
#
# Updated to Set KB for 'iexplore.exe' File Version
#   - By Sharath S <sharaths@secpod.com> On 2009-08-06
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(800209);
  script_version("$Revision: 1.1 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Microsoft Internet Explorer Version Detection (Win)");
  desc = "
 
  Overview: The script detects the version of Microsoft Internet Explorer
  on remote host and sets the KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Check for Internet Explorer version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl", "smb_registry_access.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Check for IE Installation
if(!registry_key_exists(key:"SOFTWARE\Microsoft\Internet Explorer")){
  exit(0);
}

# Get for IE Version from Registry Entry
ver = registry_get_sz(item:"Version",
                      key:"SOFTWARE\Microsoft\Internet Explorer");

# Set KB from Registry Entry version
if(ver != NULL){
  set_kb_item(name:"MS/IE/Version", value:ver);
}

# Get for IE Installed Path
exePath = registry_get_sz(key:"SOFTWARE\Microsoft\Windows\CurrentVersion" +
                              "\App Paths\IEXPLORE.EXE", item:"Path");
if(exePath != NULL)
{
  exePath = exePath - ";" + "\iexplore.exe";
  share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:exePath);
  file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:exePath);
  ieVer = GetVer(file:file, share:share);

  # Set KB for iexplore.exe File Version
  if(ieVer)
  {
    set_kb_item(name:"MS/IE/EXE/Ver", value:ieVer);
    security_note(data:"Microsoft Internet Explorer version " + ieVer +
                       " running at location " + exePath +
                       " was detected on the host");
  }
}
