###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ibm_install_manager_arg_inj_vuln_win.nasl 5170 2009-10-08 13:24:24Z oct $
#
# IBM Installation Manager URI Handling Argument Injection Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801011);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3518");
  script_bugtraq_id(36549);
  script_name("IBM Installation Manager URI Handling Argument Injection Vulnerability (Win)");
  desc = "
  Overview: This host has IBM Installation Manager installed and is prone to
  Argument Injection vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'IBMIM.exe' when handling arguments received via
  an 'iim:' URI. This can be exploited to load an arbitrary library from a
  network share via a specially crafted '-vm' argument.

  Impact:
  Successful exploitation will let the attackers to execute arbitrary code or
  compromise a user's system.

  Impact Level: Application/System

  Affected Software/OS:
  IBM Installation Manager 1.3.2 and prior on Windows.

  Fix: No solution or patch is available as on 08th October, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www-01.ibm.com/software/awdtools/installmanager/support/

  References:
  http://secunia.com/advisories/36906
  http://retrogod.altervista.org/9sg_ibm_uri.html
  http://www.vupen.com/english/advisories/2009/2792

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of IBM Installation Manager");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("gb_ibm_install_manager_detect_win.nasl");
  script_require_keys("IBM/InstallMang/Win/Ver");
  exit(0);
}


include("version_func.inc");

# Get IBM Installation Manager Version
iimVer = get_kb_item("IBM/InstallMang/Win/Ver");

if(iimVer != NULL)
{
  # Check for IBM Install Manager version <= 1.3.2
  if(version_is_less_equal(version:iimVer, test_version:"1.3.2")){
    security_hole(0);
  }
}
