###############################################################################
# OpenVAS Vulnerability Test
# $Id:gb_firefox_keygen_dos_vuln_win.nasl 2569 2009-06-02 21:25:33Z june $
#
# Mozilla Firefox 'keygen' HTML Tag DOS Vulnerability (Win)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800624);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1828", "CVE-2009-1827");
  script_bugtraq_id(35132);
  script_name("Mozilla Firefox 'keygen' HTML Tag DOS Vulnerability (Win)");
  desc = "

  Overview: The host is installed with Mozilla Firefox browser and is prone
  to Denial of Service vulnerability.

  Vulnerability Insight:
  - Error exists via KEYGEN element in conjunction with a META element
    specifying automatic page refresh or a JavaScript onLoad event handler
    for a BODY element.
  - Error caused while passing a large value in the r (aka Radius) attribute
    of a circle element, related to an 'unclamped loop.'.

  Impact:
  Successful exploitation will let attackers to cause the browser to stop
  responding, infinite loop, application hang, and memory consumption, and
  can cause denying service to legitimate users.

  Impact Level: Application

  Affected Software/OS:
  Firefox version 3.0.4 and 3.0.10 on Windows

  Fix: Upgrade to Firefox version 3.6.3 or later, 
  For updates refer,http://www.mozilla.com/en-US/

  References:
  http://www.milw0rm.com/exploits/8794
  http://xforce.iss.net/xforce/xfdb/50721
  http://blog.zoller.lu/2009/04/advisory-firefox-denial-of-service.html

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Firefox");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("gb_firefox_detect_win.nasl");
  script_require_keys("Firefox/Win/Ver");
  exit(0);
}


include("version_func.inc");

ffVer = get_kb_item("Firefox/Win/Ver");
if(!ffVer){
  exit(0);
}

if(version_is_equal(version:ffVer, test_version:"3.0.10")||
   version_is_equal(version:ffVer, test_version:"3.0.4")){
  security_hole(0);
}
