###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for qt4 FEDORA-2007-4285
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(860580);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2007-4285");
  script_cve_id("CVE-2007-5965");
  script_name( "Fedora Update for qt4 FEDORA-2007-4285");
  desc = "

  Vulnerability Insight:
  Qt is a software toolkit for developing applications.
  
  This package contains base tools, like string, xml, and network
  handling.


  Affected Software/OS:
  qt4 on Fedora 8

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2008-January/msg00005.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of qt4");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC8")
{

  if(isrpmvuln(pkg:"qt4", rpm:"qt4~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-odbc", rpm:"qt4-odbc~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-debuginfo", rpm:"qt4-debuginfo~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-mysql", rpm:"qt4-mysql~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-sqlite", rpm:"qt4-sqlite~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-devel", rpm:"qt4-devel~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-postgresql", rpm:"qt4-postgresql~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-doc", rpm:"qt4-doc~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4", rpm:"qt4~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-x11", rpm:"qt4-x11~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-mysql", rpm:"qt4-mysql~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-postgresql", rpm:"qt4-postgresql~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-odbc", rpm:"qt4-odbc~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4", rpm:"qt4~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-sqlite", rpm:"qt4-sqlite~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-devel", rpm:"qt4-devel~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-doc", rpm:"qt4-doc~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-debuginfo", rpm:"qt4-debuginfo~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"qt4-x11", rpm:"qt4-x11~4.3.3~1.fc8", rls:"FC8"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}