###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_ccproxy_connection_req_bof_vuln.nasl 831 2009-03-13 14:45:02Z mar $
#
# CCProxy CONNECTION Request Buffer Overflow Vulnerability.
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800539);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-6415");
  script_bugtraq_id(31416);
  script_name("CCProxy CONNECTION Request Buffer Overflow Vulnerability");
  desc = "

  Overview:
  This host is running CCProxy and is prone to buffer overflow vulnerability.

  Vulnerability Insight:
  Boundary error in the CCProxy while processing of CONNECT requests sent to
  the HTTP proxy having overly long hostname.

  Impact:
  Attackers can exploit this issue to cause a stack based buffer overflow and
  to execute arbitrary code in the scope of affected application.

  Affected Software/OS:
  Youngzsoft CCProxy 6.61 and prior on Windows.

  Fix: Upgrade to CCProxy version 6.62 or later,
  http://www.youngzsoft.net/ccproxy/proxy-server-download.htm

  References:
  http://secunia.com/advisories/31997
  http://jbrownsec.blogspot.com/2008/09/ccproxy-near-stealth-patching.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.4
  Risk factor: High ";

  script_description(desc);
  script_summary("Check for the version of CCProxy");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_ccproxy_detect.nasl", "find_service.nes");
  script_require_keys("CCProxy/Ver");
  script_require_ports("Services/www", 808);
  exit(0);
}


include("version_func.inc");

ccproxyPort = 808;
if(!get_port_state(ccproxyPort)){
  exit(0);
}

ccproxyVer = get_kb_item("CCProxy/Ver");
if(ccproxyVer)
{
  if(version_is_less(version:ccproxyVer, test_version:"6.62")){
    security_hole(ccproxyPort);
  }
}
