#
#VID fa708908-a8c7-11dc-b41d-000fb5066b20
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60022);
 script_cve_id("CVE-2007-6299");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "FreeBSD Ports: drupal5";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   drupal5
   drupal4

CVE-2007-6299
Multiple SQL injection vulnerabilities in Drupal and vbDrupal 4.7.x
before 4.7.9 and 5.x before 5.4 allow remote attackers to execute
arbitrary SQL commands via modules that pass input to the
taxonomy_select_nodes function, as demonstrated by the (1)
taxonomy_menu, (2) ajaxLoader, and (3) ubrowser contributed modules.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://drupal.org/node/198162
http://secunia.com/advisories/27932/
http://www.vuxml.org/freebsd/fa708908-a8c7-11dc-b41d-000fb5066b20.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: drupal5";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"drupal5");
if(!isnull(bver) && revcomp(a:bver, b:"5.4")<0) {
    security_note(0, data:"Package drupal5 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"drupal4");
if(!isnull(bver) && revcomp(a:bver, b:"4.7.9")<0) {
    security_note(0, data:"Package drupal4 version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
