# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8815 (neon)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64719);
 script_cve_id("CVE-2009-2473");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Fedora Core 11 FEDORA-2009-8815 (neon)");

 desc = "The remote host is missing an update to neon
announced via advisory FEDORA-2009-8815.

Update Information:

This update includes the latest release of neon, version 0.28.6.
This fixes two security issues:

* the billion laughs attack against expat could allow
  a Denial of Service attack by a malicious server. (CVE-2009-2473)
* an embedded NUL byte in a certificate subject name could allow an
  undetected MITM attack against an SSL server if a trusted CA
  issues such a cert.

ChangeLog:

* Wed Aug 19 2009 Joe Orton  0.28.6-1
- update to 0.26.1
* Thu Jul  9 2009 Joe Orton  0.28.5-1
- update to 0.28.5 (#502451, #491839)

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update neon' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8815

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 11 FEDORA-2009-8815 (neon)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"neon", rpm:"neon~0.28.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"neon-devel", rpm:"neon-devel~0.28.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"neon-debuginfo", rpm:"neon-debuginfo~0.28.6~1.fc11", rls:"FC11")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
