# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-2805 (ntop)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63787);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Fedora Core 10 FEDORA-2009-2805 (ntop)";
 script_name(name);

 desc = "The remote host is missing an update to ntop
announced via advisory FEDORA-2009-2805.

Update Information:

ls -lh /var/log/ntop/access.log  -rw-rw-rw- 1 root root 0 2009-02-04 11:53
/var/log/ntop/access.log    Fixed.  log world-writable when the --access-log-
file option is used.    This option is not used in Fedora or Red Hat by default
and is not noted in the configuration file.  It is, however, noted in the ntop
manpage. It would require the root user to add this option to the configuration
in order for this file to be created.

ChangeLog:

* Tue Mar 17 2009 Rakesh Pandit  - 3.3.8-3
- Fixed world writable accesslog (#490561) - security bug
* Tue Mar  3 2009 Peter Vrabec  - 3.3.8-2
- invalid certificate fix (#486725)

References:

[ 1 ] Bug #490561 - ntop: access.log created world-writable
https://bugzilla.redhat.com/show_bug.cgi?id=490561

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update ntop' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-2805

Risk factor : High";

 script_description(desc);

 summary = "Fedora Core 10 FEDORA-2009-2805 (ntop)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Fedora Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ntop", rpm:"ntop~3.3.8~3.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ntop-debuginfo", rpm:"ntop-debuginfo~3.3.8~3.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
