# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 692-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53522);
 script_cve_id("CVE-2005-0205");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 692-1 (kdenetwork)";
 script_name(name);

 desc = "The remote host is missing an update to kdenetwork
announced via advisory DSA 692-1.

The KDE team fixed a bug in kppp in 2002 which was now discovered to be
exploitable by iDEFENSE.  By opening a sufficiently large number of
file descriptors before executing kppp which is installed setuid root a
local attacker is able to take over privileged file descriptors.

For the stable distribution (woody) this problem has been fixed in
version 2.2.2-14.7.

The testing (sarge) and unstable (sid) distributions are not affected
since KDE 3.2 already contained the correction.

We recommend that you upgrade your kppp package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20692-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 692-1 (kdenetwork)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdict", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kit", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"klisa", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kmail", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"knewsticker", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"knode", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"korn", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kppp", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ksirc", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ktalkd", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkdenetwork1", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmimelib-dev", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libmimelib1", ver:"2.2.2-14.7", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
