# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 504-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53194);
 script_cve_id("CVE-2004-0472");
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 504-1 (heimdal)";
 script_name(name);

 desc = "The remote host is missing an update to heimdal
announced via advisory DSA 504-1.

Evgeny Demidov discovered a potential buffer overflow in a Kerberos 4
component of heimdal, a free implementation of Kerberos 5.  The
problem is present in kadmind, a server for administrative access to
the Kerberos database.  This problem could perhaps be exploited to
cause the daemon to read a negative amount of data which could lead to
unexpected behaviour.

For the stable distribution (woody) this problem has been fixed in
version 0.4e-7.woody.9.

For the unstable distribution (sid) this problem has been fixed in
version 0.6.2-1.

We recommend that you upgrade your heimdal and related packages.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20504-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 504-1 (heimdal)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"heimdal-docs", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-lib", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-clients-x", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-dev", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-kdc", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"heimdal-servers-x", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libasn1-5-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libcomerr1-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libgssapi1-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libhdb7-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm5clnt4-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkadm5srv7-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkafs0-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libkrb5-17-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libotp0-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libroken9-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsl0-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libss0-heimdal", ver:"0.4e-7.woody.9", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
