# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 2004-1 (samba)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(67030);
 script_cve_id("CVE-2009-3297", "CVE-2010-0547");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"2.1");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 2004-1 (samba)");

 desc = "The remote host is missing an update to samba
announced via advisory DSA 2004-1.

Two local vulnerabilities have been discovered in samba, a SMB/CIFS file,
print, and login server for Unix. The Common  Vulnerabilities and
Exposures project identifies the following problems:

CVE-2009-3297

Ronald Volgers discovered that a race condition in mount.cifs
allows local users to mount remote filesystems over arbitrary
mount points.

CVE-2010-0547

Jeff Layton discovered that missing input sanitising in mount.cifs
allows denial of service by corrupting /etc/mtab.

For the stable distribution (lenny), these problems have been fixed in
version 2:3.2.5-4lenny9.

For the unstable distribution (sid), these problems have been fixed in
version 2:3.4.5~dfsg-2.

We recommend that you upgrade your samba packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%202004-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 2004-1 (samba)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"samba-doc-pdf", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-doc", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbfs", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpam-smbpass", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libsmbclient-dev", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"winbind", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-dbg", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"smbclient", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-common", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libwbclient0", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"samba-tools", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"swat", ver:"3.2.5-4lenny9", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
