# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1635-1 (freetype)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(61593);
 script_cve_id("CVE-2008-1806", "CVE-2008-1807", "CVE-2008-1808");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1635-1 (freetype)";
 script_name(name);

 desc = "The remote host is missing an update to freetype
announced via advisory DSA 1635-1.

Several local vulnerabilities have been discovered in freetype,
a FreeType 2 font engine, which could allow the execution of arbitrary
code.

The Common Vulnerabilities and Exposures project identifies the
following problems:

CVE-2008-1806
An integer overflow allows context-dependent attackers to execute
arbitrary code via a crafted set of values within the Private
dictionary table in a Printer Font Binary (PFB) file.

CVE-2008-1807
The handling of an invalid number of axes field in the PFB file could
trigger the freeing of aribtrary memory locations, leading to
memory corruption.

CVE-2008-1808
Multiple off-by-one errors allowed the execution of arbitrary code
via malformed tables in PFB files, or invalid SHC instructions in
TTF files.


For the stable distribution (etch), these problems have been fixed in version
2.2.1-5+etch3.

For the unstable distribution (sid), these problems have been fixed in
version 2.3.6-1.

We recommend that you upgrade your freetype package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201635-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1635-1 (freetype)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"freetype2-demos", ver:"2.2.1-5+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreetype6-dev", ver:"2.2.1-5+etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libfreetype6", ver:"2.2.1-5+etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
