#
# This script was written by Carsten Koch-Mauthe <c.koch-mauthe at dn-systems.de>
# Slight modification by Vlatko Kosturjak - Kost <kost@linux.hr>
# This script is released under the GNU GPLv2
#
# $Revision: 06 $

if(description)
{

  script_id(90000);
  script_version ("$Revision: 06 $");
  script_tag(name:"risk_factor", value:"High");
  script_name("ClamAV < 0.93.1 vulnerability");

  desc = "The remote host is probably affected by the
  vulnerabilities described in CVE 2007-6335 CVE 2007-6336 CVE 2007-6337
  CVE-2008-0318 CVE-2008-1100 CVE-2008-1387 CVE-2008-2713

  Impact
  CVE 2008-2713
  libclamav/petite.c in ClamAV before 0.93.1 allows remote attackers to cause
  a denial of service via a crafted Petite file that triggers an out-of-bound
  read.
  CVE 2008-1387
  ClamAV before 0.93 allows remote attackers to cause a denial of service
  (CPU consumption) via a crafted ARJ archive, as demonstrated by the PROTOS
  GENOME test suite for Archive Formats.
  CVE 2008-1100
  Buffer overflow in the cli_scanpe function in libclamav (libclamav/pe.c)
  for ClamAV 0.92 and 0.92.1 allows remote attackers to execute arbitrary
  code via a crafted Upack PE file.
  CVE 2008-0318
  Integer overflow in the cli_scanpe function in libclamav in ClamAV before
  0.92.1, as used in clamd, allows remote attackers to cause a denial of
  service and possibly execute arbitrary code via a crafted Petite packed
  PE file, which triggers a heap-based buffer overflow.
  CVE 2007-6337
  Unspecified vulnerability in the bzip2 decompression algorithm in
  nsis/bzlib_private.h in ClamAV before 0.92 has unknown impact and remote
  attack vectors.
  CVE 2007-6336
  off-by-one error in ClamAV before 0.92 allows remote attackers to execute
  arbitrary code via a crafted MS-ZIP compressed CAB file.
  CVE 2007-6335
  Integer overflow in libclamav in ClamAV before 0.92 allows remote attackers
  to execute arbitrary code via a crafted MEW packed PE file, which triggers
  a heap-based buffer overflow.

  References:
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-2713
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1387
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-1100
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2008-0318
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6337
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6336
  http://www.cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2007-6335

  Solution:
  All ClamAV users should upgrade to the latest version:

  Risk factor : High";

  script_description(desc);
  script_summary("Determines the Version of ClamAV");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is under GPLv2");
  family = "General";
  script_family(family);
  exit(0);
}

#
# The code starts here
#
include("ssh_func.inc");
include("version_func.inc");

sock = ssh_login_or_reuse_connection();
if(!sock){
  exit(0);
}

getPath = find_bin(prog_name:"clamscan", sock:sock);
foreach binaryFile (getPath)
{
  avVer = get_bin_version(full_prog_name:chomp(binaryFile), version_argv:"-V",
                          ver_pattern:"ClamAV ([0-9.]+)", sock:sock);
  if(avVer[1] != NULL)
  {
    # Check for < 0.93.1 version of ClamAV
    if(version_is_less(version:avVer[1], test_version:"0.93.1")){
      security_hole(0);
    }
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
