// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Select3D_SensitiveTriangulation_HeaderFile
#define _Select3D_SensitiveTriangulation_HeaderFile

#include <Standard.hxx>
#include <Standard_DefineHandle.hxx>
#include <Handle_Select3D_SensitiveTriangulation.hxx>

#include <Handle_Poly_Triangulation.hxx>
#include <TopLoc_Location.hxx>
#include <gp_Trsf.hxx>
#include <gp_Pnt.hxx>
#include <Handle_TColStd_HArray1OfInteger.hxx>
#include <Standard_Boolean.hxx>
#include <TColgp_Array1OfPnt2d.hxx>
#include <gp_Pnt2d.hxx>
#include <Bnd_Box2d.hxx>
#include <Standard_Integer.hxx>
#include <Select3D_SensitiveEntity.hxx>
#include <Handle_SelectBasics_EntityOwner.hxx>
#include <Handle_Select3D_Projector.hxx>
#include <Handle_Select3D_SensitiveEntity.hxx>
#include <SelectBasics_PickArgs.hxx>
#include <Standard_Real.hxx>
#include <Standard_OStream.hxx>
class Poly_Triangulation;
class TColStd_HArray1OfInteger;
class SelectBasics_EntityOwner;
class TopLoc_Location;
class gp_Pnt;
class Select3D_Projector;
class SelectBasics_ListOfBox2d;
class Select3D_SensitiveEntity;
class TColgp_Array1OfPnt2d;
class Bnd_Box2d;
class gp_Lin;
class gp_Pnt2d;
class gp_XY;


//! A framework to define selection of a sensitive entity made of a set of triangles.
class Select3D_SensitiveTriangulation : public Select3D_SensitiveEntity
{

public:

  
  //! Constructs a sensitive triangulation object defined by
  //! the owner OwnerId, the triangulation aTriangulation,
  //! the location aLoc, and the flag InteriorFlag.
  Standard_EXPORT Select3D_SensitiveTriangulation(const Handle(SelectBasics_EntityOwner)& OwnerId, const Handle(Poly_Triangulation)& aTriangulation, const TopLoc_Location& aLoc, const Standard_Boolean InteriorFlag = Standard_True);
  
  //! Constructs a sensitive triangulation object defined by
  //! the owner OwnerId, the triangulation aTriangulation,
  //! the location aLoc, the array of free edges
  //! thefreeedges, the center of gravity theCDG, and the flag InteriorFlag.
  //! As free edges and the center of gravity do not have
  //! to be computed later, this syntax reduces computation time.
  Standard_EXPORT Select3D_SensitiveTriangulation(const Handle(SelectBasics_EntityOwner)& OwnerId, const Handle(Poly_Triangulation)& aTriangulation, const TopLoc_Location& aLoc, const Handle(TColStd_HArray1OfInteger)& thefreeedges, const gp_Pnt& theCDG, const Standard_Boolean InteriorFlag);
  
  //! projection of the sensitive primitive in order to
  //! get 2D boxes for the Sort Algorithm
  Standard_EXPORT   void Project (const Handle(Select3D_Projector)& aProjector) ;
  
  //! stores in <boxes> the 2D Boxes which represent the sensitive face
  //! in the selection algorithm.
  Standard_EXPORT   void Areas (SelectBasics_ListOfBox2d& boxes) ;
  
  Standard_EXPORT   Handle(Select3D_SensitiveEntity) GetConnected (const TopLoc_Location& aLocation) ;
  
  //! Checks whether the sensitive entity matches the picking
  //! detection area (close to the picking line).
  //! For details please refer to base class declaration.
  Standard_EXPORT virtual   Standard_Boolean Matches (const SelectBasics_PickArgs& thePickArgs, Standard_Real& theMatchDMin, Standard_Real& theMatchDepth) ;
  
  Standard_EXPORT virtual   Standard_Boolean Matches (const Standard_Real XMin, const Standard_Real YMin, const Standard_Real XMax, const Standard_Real YMax, const Standard_Real aTol) ;
  
  Standard_EXPORT virtual   Standard_Boolean Matches (const TColgp_Array1OfPnt2d& Polyline, const Bnd_Box2d& aBox, const Standard_Real aTol) ;
  
  //! Compute precise depth of detected triangle.
  //! @param thePickLine [in] the picking line.
  //! @param theTriangle [in] the index of detected triangle.
  //! @return depth on the picking line.
  Standard_EXPORT   Standard_Real ComputeDepth (const gp_Lin& thePickLine, const Standard_Integer theTriangle)  const;
  
  //! Returns the detected three nodes P1, P2, P3 constituting a triangle.
  //! This triangle is a component of the overall sensitive
  //! triangulation created at construction time.
      Standard_Integer DetectedTriangle()  const;
  
  //! Returns the triangulation used at the time of construction.
     const  Handle(Poly_Triangulation)& Triangulation()  const;
  
  //! Returns the 3D center of gravity used at the time of construction.
     const  gp_Pnt& CDG3D()  const;
  
  //! Returns the 2D center of gravity used at the time of construction.
     const  gp_Pnt2d& CDG2D()  const;
  
  //! Dmin gives the distance between the cdg and aPoint
  Standard_EXPORT   Standard_Integer Status (const gp_XY& p0, const gp_XY& p1, const gp_XY& p2, const gp_XY& aPoint, const Standard_Real aTol, Standard_Real& Dmin)  const;
  
      Standard_Boolean HasInitLocation()  const;
  
     const  TopLoc_Location& GetInitLocation()  const;
  
  Standard_EXPORT virtual   void ResetLocation() ;
  
  Standard_EXPORT virtual   void SetLocation (const TopLoc_Location& aLoc) ;
  
  Standard_EXPORT virtual   void Dump (Standard_OStream& S, const Standard_Boolean FullDump = Standard_True)  const;
  
  //! gives the vertices of detected triangle...
  Standard_EXPORT   Standard_Boolean DetectedTriangle (gp_Pnt& P1, gp_Pnt& P2, gp_Pnt& P3)  const;
  
  //! Gets 2D nodes computed by entity using 3D nodes and viewer
  //! parameters (see Project() method)
  Standard_EXPORT   Standard_Boolean DetectedTriangle2d (gp_Pnt2d& P1, gp_Pnt2d& P2, gp_Pnt2d& P3)  const;




  DEFINE_STANDARD_RTTI(Select3D_SensitiveTriangulation)

protected:




private: 

  
  Standard_EXPORT   Standard_Boolean IsFree (const Standard_Integer IndexOfTriangle, Standard_Integer& IndexinFree)  const;
  
  Standard_EXPORT   void ComputeTotalTrsf() ;

  Handle(Poly_Triangulation) myTriangul;
  TopLoc_Location myiniloc;
  gp_Trsf myTrsf;
  gp_Pnt myCDG3D;
  Handle(TColStd_HArray1OfInteger) myFreeEdges;
  Standard_Boolean myIntFlag;
  TColgp_Array1OfPnt2d myNodes2d;
  gp_Pnt2d myCDG2D;
  Bnd_Box2d mybox2d;
  Standard_Integer myDetectedTr;


};


#include <Select3D_SensitiveTriangulation.lxx>





#endif // _Select3D_SensitiveTriangulation_HeaderFile
