MODULE mod_prism_get_comm

  IMPLICIT NONE

  PUBLIC prism_get_intracomm, prism_get_intercomm 

  INTERFACE prism_get_intercomm
    
    MODULE PROCEDURE prism_get_intercomm_1mod
       
  END INTERFACE

  INTERFACE prism_get_intracomm

    MODULE PROCEDURE prism_get_intracomm_1mod
       
  END INTERFACE
  
!
!-----Type model to store information about models
!
  TYPE :: model
    character(len=6) :: name
    integer          :: master_proc   !! rank of master proc in global communicator
  END TYPE model

  TYPE(model), ALLOCATABLE, DIMENSION(:) :: coupling_models

CONTAINS

  SUBROUTINE prism_get_intercomm_1mod(il_local_comm, cd_name, kinfo)
!
!*    *** Get_intercomm ***   PRISM 1.0
!
!     purpose:
!     --------
!        Get an intercommunicator.
!
!     interface:
!     ----------
!        il_local_comm : intercommunicator
!        cd_name : name of the model to be linked with thanks to the intercommunicator
!        kinfo  : exit status
!
!     lib mp:
!     -------
!        mpi-1
!
!     author:
!     -------
!        Arnaud Caubel
!
!     ----------------------------------------------------------------
!
    USE mod_kinds_model
    USE mod_comprism_proto

    include 'mpif.h'

!     ----------------------------------------------------------------
    INTEGER (kind=ip_intwp_p)	:: il, il_local_comm, kinfo, il_local_intercomm
    INTEGER (kind=ip_intwp_p)	:: tag
    CHARACTER (len=6) :: cd_name
    LOGICAL :: ll_found
!     ----------------------------------------------------------------

    ll_found= .false.

    ALLOCATE(coupling_models(knmods))
    coupling_models(1)%master_proc=1
    coupling_models(1)%name=trim(cunames(2))
    DO il=2,knmods
      coupling_models(il)%master_proc= &
         coupling_models(il-1)%master_proc+ kbtotproc(il-1)
      coupling_models(il)%name= &
         TRIM(cunames(coupling_models(il)%master_proc+1))
    ENDDO
      
    DO il=1,knmods
      IF (cd_name .EQ. coupling_models(il)%name .AND. .NOT. ll_found) THEN
          tag=ICHAR(TRIM(cmynam))+ICHAR(TRIM(cd_name))
      CALL mpi_intercomm_create(ig_local_comm, 0, MPI_COMM_WORLD, coupling_models(il)%master_proc, &
             tag, il_local_intercomm, kinfo)
          ll_found= .true.
      ENDIF
    ENDDO
    
    il_local_comm = il_local_intercomm

    IF (ll_found) THEN
        kinfo = CLIM_Ok
    ELSE
        kinfo = CLIM_BadName
    ENDIF

    deallocate (coupling_models)

  END SUBROUTINE prism_get_intercomm_1mod

  SUBROUTINE prism_get_intracomm_1mod(il_local_comm, cd_name, kinfo)
!
!*    *** Get_intracomm ***   PRISM 1.0
!
!     purpose:
!     --------
!        Get an intracommunicator.
!
!     interface:
!     ----------
!        il_local_comm : intracommunicator
!        cd_name : name of the model to share the communicator with
!        kinfo  : exit status
!
!     lib mp:
!     -------
!        mpi-1
!
!     author:
!     -------
!        Arnaud Caubel
!
!     ----------------------------------------------------------------
!
    USE mod_kinds_model
    USE mod_comprism_proto

    include 'mpif.h'

!     ----------------------------------------------------------------
    INTEGER (kind=4)	:: il, il_local_comm, kinfo, il_local_intercomm
    INTEGER (kind=4)	:: il_new_local_comm, tag
    CHARACTER (len=6) :: cd_name
    LOGICAL :: ll_found
!     ----------------------------------------------------------------

    ll_found= .false.

    ALLOCATE(coupling_models(knmods))
    coupling_models(1)%master_proc=1
    coupling_models(1)%name=trim(cunames(2))
    DO il=2,knmods
      coupling_models(il)%master_proc= &
         coupling_models(il-1)%master_proc+ kbtotproc(il-1)
      coupling_models(il)%name= &
         TRIM(cunames(coupling_models(il)%master_proc+1))
    ENDDO
      
    DO il=1,knmods
      IF (cd_name .EQ. coupling_models(il)%name .AND. .NOT. ll_found) THEN
          tag=ICHAR(TRIM(cmynam))+ICHAR(TRIM(cd_name))
      CALL mpi_intercomm_create(ig_local_comm, 0, MPI_COMM_WORLD, coupling_models(il)%master_proc, &
             tag, il_local_intercomm, kinfo)
          CALL mpi_intercomm_merge(il_local_intercomm,.FALSE., il_new_local_comm, kinfo)
          ll_found= .true.
      ENDIF
    ENDDO
    
    il_local_comm = il_new_local_comm

    IF (ll_found) THEN
        kinfo = CLIM_Ok
    ELSE
        kinfo = CLIM_BadName
    ENDIF

    deallocate (coupling_models)

  END SUBROUTINE prism_get_intracomm_1mod

END MODULE mod_prism_get_comm
