/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.dsi.test;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.security.auth.DialogAuthListener;
import com.sourceforge.knecs.util.NSProperty;
import java.io.File;
import java.util.Hashtable;

public class PerfTestPopulate {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: PerfTestPopulate filenamebase url numResources numProperties");
            System.exit(-1);
        }
        String filenameBase = args[0];
        String mHostStr = args[1];
        int numResources = Integer.parseInt(args[2]);
        int numprops = Integer.parseInt(args[3]);
        File file = new File(filenameBase);
        if (!file.exists()) {
            System.err.println("Input file " + file.toString() + " not found.");
            System.exit(-1);
        }
        Hashtable<NSProperty, String> props = new Hashtable<NSProperty, String>();
        long total = 0L;
        long minDur = 0L;
        long maxDur = 0L;
        try {
            DialogAuthListener dal = new DialogAuthListener();
            DSI dsi = new DSI(mHostStr, dal);
            for (int i = 0; i < numResources; ++i) {
                for (int j = 0; j < numprops; ++j) {
                    String propName = "prop" + j;
                    String propValue = "prop" + i % 10 + j;
                    NSProperty nsp = new NSProperty("cmcs", propName);
                    props.put(nsp, propValue);
                }
                String filename = filenameBase + i + ".txt";
                long start = System.currentTimeMillis();
                dsi.setURL(mHostStr + "/" + filename);
                dsi.putDataSet(file);
                if (numprops > 0) {
                    dsi.putMetaData(props);
                }
                long end = System.currentTimeMillis();
                long duration = end - start;
                System.out.println("file " + filename + " time: " + duration + "ms");
                total += duration;
                if (i == 0) {
                    minDur = duration;
                    maxDur = duration;
                } else {
                    if (duration < minDur) {
                        minDur = duration;
                    }
                    if (duration > maxDur) {
                        maxDur = duration;
                    }
                }
                props.clear();
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        System.out.println("PutDataset time with " + numprops + " properties");
        System.out.println("Total time: " + total + " ms");
        System.out.println("Average time: " + total / (long)numResources + " ms");
        System.out.println("Minimum time: " + minDur + " ms");
        System.out.println("Maximum time: " + maxDur + " ms");
        System.exit(0);
    }
}

