#include <ccan/hash/hash.h>
#include <ccan/tap/tap.h>
#include <stdbool.h>
#include <string.h>

#define ARRAY_WORDS 5

int main(int argc, char *argv[])
{
	unsigned int i;
	uint8_t u8array[ARRAY_WORDS];
	uint16_t u16array[ARRAY_WORDS];
	uint32_t u32array[ARRAY_WORDS];
	uint64_t u64array[ARRAY_WORDS];

	/* Initialize arrays. */
	for (i = 0; i < ARRAY_WORDS; i++) {
		u8array[i] = i;
		u16array[i] = i;
		u32array[i] = i;
		u64array[i] = i;
	}

	plan_tests(264);

	/* hash_stable is API-guaranteed. */
	ok1(hash_stable(u8array, ARRAY_WORDS, 0) == 0x1d4833cc);
	ok1(hash_stable(u8array, ARRAY_WORDS, 1) == 0x37125e2 );
	ok1(hash_stable(u8array, ARRAY_WORDS, 2) == 0x330a007a);
	ok1(hash_stable(u8array, ARRAY_WORDS, 4) == 0x7b0df29b);
	ok1(hash_stable(u8array, ARRAY_WORDS, 8) == 0xe7e5d741);
	ok1(hash_stable(u8array, ARRAY_WORDS, 16) == 0xaae57471);
	ok1(hash_stable(u8array, ARRAY_WORDS, 32) == 0xc55399e5);
	ok1(hash_stable(u8array, ARRAY_WORDS, 64) == 0x67f21f7 );
	ok1(hash_stable(u8array, ARRAY_WORDS, 128) == 0x1d795b71);
	ok1(hash_stable(u8array, ARRAY_WORDS, 256) == 0xeb961671);
	ok1(hash_stable(u8array, ARRAY_WORDS, 512) == 0xc2597247);
	ok1(hash_stable(u8array, ARRAY_WORDS, 1024) == 0x3f5c4d75);
	ok1(hash_stable(u8array, ARRAY_WORDS, 2048) == 0xe65cf4f9);
	ok1(hash_stable(u8array, ARRAY_WORDS, 4096) == 0xf2cd06cb);
	ok1(hash_stable(u8array, ARRAY_WORDS, 8192) == 0x443041e1);
	ok1(hash_stable(u8array, ARRAY_WORDS, 16384) == 0xdfc618f5);
	ok1(hash_stable(u8array, ARRAY_WORDS, 32768) == 0x5e3d5b97);
	ok1(hash_stable(u8array, ARRAY_WORDS, 65536) == 0xd5f64730);
	ok1(hash_stable(u8array, ARRAY_WORDS, 131072) == 0x372bbecc);
	ok1(hash_stable(u8array, ARRAY_WORDS, 262144) == 0x7c194c8d);
	ok1(hash_stable(u8array, ARRAY_WORDS, 524288) == 0x16cbb416);
	ok1(hash_stable(u8array, ARRAY_WORDS, 1048576) == 0x53e99222);
	ok1(hash_stable(u8array, ARRAY_WORDS, 2097152) == 0x6394554a);
	ok1(hash_stable(u8array, ARRAY_WORDS, 4194304) == 0xd83a506d);
	ok1(hash_stable(u8array, ARRAY_WORDS, 8388608) == 0x7619d9a4);
	ok1(hash_stable(u8array, ARRAY_WORDS, 16777216) == 0xfe98e5f6);
	ok1(hash_stable(u8array, ARRAY_WORDS, 33554432) == 0x6c262927);
	ok1(hash_stable(u8array, ARRAY_WORDS, 67108864) == 0x3f0106fd);
	ok1(hash_stable(u8array, ARRAY_WORDS, 134217728) == 0xc91e3a28);
	ok1(hash_stable(u8array, ARRAY_WORDS, 268435456) == 0x14229579);
	ok1(hash_stable(u8array, ARRAY_WORDS, 536870912) == 0x9dbefa76);
	ok1(hash_stable(u8array, ARRAY_WORDS, 1073741824) == 0xb05c0c78);
	ok1(hash_stable(u8array, ARRAY_WORDS, 2147483648U) == 0x88f24d81);

	ok1(hash_stable(u16array, ARRAY_WORDS, 0) == 0xecb5f507);
	ok1(hash_stable(u16array, ARRAY_WORDS, 1) == 0xadd666e6);
	ok1(hash_stable(u16array, ARRAY_WORDS, 2) == 0xea0f214c);
	ok1(hash_stable(u16array, ARRAY_WORDS, 4) == 0xae4051ba);
	ok1(hash_stable(u16array, ARRAY_WORDS, 8) == 0x6ed28026);
	ok1(hash_stable(u16array, ARRAY_WORDS, 16) == 0xa3917a19);
	ok1(hash_stable(u16array, ARRAY_WORDS, 32) == 0xf370f32b);
	ok1(hash_stable(u16array, ARRAY_WORDS, 64) == 0x807af460);
	ok1(hash_stable(u16array, ARRAY_WORDS, 128) == 0xb4c8cd83);
	ok1(hash_stable(u16array, ARRAY_WORDS, 256) == 0xa10cb5b0);
	ok1(hash_stable(u16array, ARRAY_WORDS, 512) == 0x8b7d7387);
	ok1(hash_stable(u16array, ARRAY_WORDS, 1024) == 0x9e49d1c );
	ok1(hash_stable(u16array, ARRAY_WORDS, 2048) == 0x288830d1);
	ok1(hash_stable(u16array, ARRAY_WORDS, 4096) == 0xbe078a43);
	ok1(hash_stable(u16array, ARRAY_WORDS, 8192) == 0xa16d5d88);
	ok1(hash_stable(u16array, ARRAY_WORDS, 16384) == 0x46839fcd);
	ok1(hash_stable(u16array, ARRAY_WORDS, 32768) == 0x9db9bd4f);
	ok1(hash_stable(u16array, ARRAY_WORDS, 65536) == 0xedff58f8);
	ok1(hash_stable(u16array, ARRAY_WORDS, 131072) == 0x95ecef18);
	ok1(hash_stable(u16array, ARRAY_WORDS, 262144) == 0x23c31b7d);
	ok1(hash_stable(u16array, ARRAY_WORDS, 524288) == 0x1d85c7d0);
	ok1(hash_stable(u16array, ARRAY_WORDS, 1048576) == 0x25218842);
	ok1(hash_stable(u16array, ARRAY_WORDS, 2097152) == 0x711d985c);
	ok1(hash_stable(u16array, ARRAY_WORDS, 4194304) == 0x85470eca);
	ok1(hash_stable(u16array, ARRAY_WORDS, 8388608) == 0x99ed4ceb);
	ok1(hash_stable(u16array, ARRAY_WORDS, 16777216) == 0x67b3710c);
	ok1(hash_stable(u16array, ARRAY_WORDS, 33554432) == 0x77f1ab35);
	ok1(hash_stable(u16array, ARRAY_WORDS, 67108864) == 0x81f688aa);
	ok1(hash_stable(u16array, ARRAY_WORDS, 134217728) == 0x27b56ca5);
	ok1(hash_stable(u16array, ARRAY_WORDS, 268435456) == 0xf21ba203);
	ok1(hash_stable(u16array, ARRAY_WORDS, 536870912) == 0xd48d1d1 );
	ok1(hash_stable(u16array, ARRAY_WORDS, 1073741824) == 0xa542b62d);
	ok1(hash_stable(u16array, ARRAY_WORDS, 2147483648U) == 0xa04c7058);

	ok1(hash_stable(u32array, ARRAY_WORDS, 0) == 0x13305f8c);
	ok1(hash_stable(u32array, ARRAY_WORDS, 1) == 0x171abf74);
	ok1(hash_stable(u32array, ARRAY_WORDS, 2) == 0x7646fcc7);
	ok1(hash_stable(u32array, ARRAY_WORDS, 4) == 0xa758ed5);
	ok1(hash_stable(u32array, ARRAY_WORDS, 8) == 0x2dedc2e4);
	ok1(hash_stable(u32array, ARRAY_WORDS, 16) == 0x28e2076b);
	ok1(hash_stable(u32array, ARRAY_WORDS, 32) == 0xb73091c5);
	ok1(hash_stable(u32array, ARRAY_WORDS, 64) == 0x87daf5db);
	ok1(hash_stable(u32array, ARRAY_WORDS, 128) == 0xa16dfe20);
	ok1(hash_stable(u32array, ARRAY_WORDS, 256) == 0x300c63c3);
	ok1(hash_stable(u32array, ARRAY_WORDS, 512) == 0x255c91fc);
	ok1(hash_stable(u32array, ARRAY_WORDS, 1024) == 0x6357b26);
	ok1(hash_stable(u32array, ARRAY_WORDS, 2048) == 0x4bc5f339);
	ok1(hash_stable(u32array, ARRAY_WORDS, 4096) == 0x1301617c);
	ok1(hash_stable(u32array, ARRAY_WORDS, 8192) == 0x506792c9);
	ok1(hash_stable(u32array, ARRAY_WORDS, 16384) == 0xcd596705);
	ok1(hash_stable(u32array, ARRAY_WORDS, 32768) == 0xa8713cac);
	ok1(hash_stable(u32array, ARRAY_WORDS, 65536) == 0x94d9794);
	ok1(hash_stable(u32array, ARRAY_WORDS, 131072) == 0xac753e8);
	ok1(hash_stable(u32array, ARRAY_WORDS, 262144) == 0xcd8bdd20);
	ok1(hash_stable(u32array, ARRAY_WORDS, 524288) == 0xd44faf80);
	ok1(hash_stable(u32array, ARRAY_WORDS, 1048576) == 0x2547ccbe);
	ok1(hash_stable(u32array, ARRAY_WORDS, 2097152) == 0xbab06dbc);
	ok1(hash_stable(u32array, ARRAY_WORDS, 4194304) == 0xaac0e882);
	ok1(hash_stable(u32array, ARRAY_WORDS, 8388608) == 0x443f48d0);
	ok1(hash_stable(u32array, ARRAY_WORDS, 16777216) == 0xdff49fcc);
	ok1(hash_stable(u32array, ARRAY_WORDS, 33554432) == 0x9ce0fd65);
	ok1(hash_stable(u32array, ARRAY_WORDS, 67108864) == 0x9ddb1def);
	ok1(hash_stable(u32array, ARRAY_WORDS, 134217728) == 0x86096f25);
	ok1(hash_stable(u32array, ARRAY_WORDS, 268435456) == 0xe713b7b5);
	ok1(hash_stable(u32array, ARRAY_WORDS, 536870912) == 0x5baeffc5);
	ok1(hash_stable(u32array, ARRAY_WORDS, 1073741824) == 0xde874f52);
	ok1(hash_stable(u32array, ARRAY_WORDS, 2147483648U) == 0xeca13b4e);

	ok1(hash_stable(u64array, ARRAY_WORDS, 0) == 0x12ef6302);
	ok1(hash_stable(u64array, ARRAY_WORDS, 1) == 0xe9aeb406);
	ok1(hash_stable(u64array, ARRAY_WORDS, 2) == 0xc4218ceb);
	ok1(hash_stable(u64array, ARRAY_WORDS, 4) == 0xb3d11412);
	ok1(hash_stable(u64array, ARRAY_WORDS, 8) == 0xdafbd654);
	ok1(hash_stable(u64array, ARRAY_WORDS, 16) == 0x9c336cba);
	ok1(hash_stable(u64array, ARRAY_WORDS, 32) == 0x65059721);
	ok1(hash_stable(u64array, ARRAY_WORDS, 64) == 0x95b5bbe6);
	ok1(hash_stable(u64array, ARRAY_WORDS, 128) == 0xe7596b84);
	ok1(hash_stable(u64array, ARRAY_WORDS, 256) == 0x503622a2);
	ok1(hash_stable(u64array, ARRAY_WORDS, 512) == 0xecdcc5ca);
	ok1(hash_stable(u64array, ARRAY_WORDS, 1024) == 0xc40d0513);
	ok1(hash_stable(u64array, ARRAY_WORDS, 2048) == 0xaab25e4d);
	ok1(hash_stable(u64array, ARRAY_WORDS, 4096) == 0xcc353fb9);
	ok1(hash_stable(u64array, ARRAY_WORDS, 8192) == 0x18e2319f);
	ok1(hash_stable(u64array, ARRAY_WORDS, 16384) == 0xfddaae8d);
	ok1(hash_stable(u64array, ARRAY_WORDS, 32768) == 0xef7976f2);
	ok1(hash_stable(u64array, ARRAY_WORDS, 65536) == 0x86359fc9);
	ok1(hash_stable(u64array, ARRAY_WORDS, 131072) == 0x8b5af385);
	ok1(hash_stable(u64array, ARRAY_WORDS, 262144) == 0x80d4ee31);
	ok1(hash_stable(u64array, ARRAY_WORDS, 524288) == 0x42f5f85b);
	ok1(hash_stable(u64array, ARRAY_WORDS, 1048576) == 0x9a6920e1);
	ok1(hash_stable(u64array, ARRAY_WORDS, 2097152) == 0x7b7c9850);
	ok1(hash_stable(u64array, ARRAY_WORDS, 4194304) == 0x69573e09);
	ok1(hash_stable(u64array, ARRAY_WORDS, 8388608) == 0xc942bc0e);
	ok1(hash_stable(u64array, ARRAY_WORDS, 16777216) == 0x7a89f0f1);
	ok1(hash_stable(u64array, ARRAY_WORDS, 33554432) == 0x2dd641ca);
	ok1(hash_stable(u64array, ARRAY_WORDS, 67108864) == 0x89bbd391);
	ok1(hash_stable(u64array, ARRAY_WORDS, 134217728) == 0xbcf88e31);
	ok1(hash_stable(u64array, ARRAY_WORDS, 268435456) == 0xfa7a3460);
	ok1(hash_stable(u64array, ARRAY_WORDS, 536870912) == 0x49a37be0);
	ok1(hash_stable(u64array, ARRAY_WORDS, 1073741824) == 0x1b346394);
	ok1(hash_stable(u64array, ARRAY_WORDS, 2147483648U) == 0x6c3a1592);

	ok1(hash64_stable(u8array, ARRAY_WORDS, 0) == 16887282882572727244ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 1) == 12032777473133454818ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 2) == 18183407363221487738ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 4) == 17860764172704150171ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 8) == 18076051600675559233ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 16) == 9909361918431556721ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 32) == 12937969888744675813ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 64) == 5245669057381736951ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 128) == 4376874646406519665ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 256) == 14219974419871569521ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 512) == 2263415354134458951ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 1024) == 4953859694526221685ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 2048) == 3432228642067641593ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 4096) == 1219647244417697483ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 8192) == 7629939424585859553ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 16384) == 10041660531376789749ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 32768) == 13859885793922603927ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 65536) == 15069060338344675120ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 131072) == 818163430835601100ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 262144) == 14914314323019517069ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 524288) == 17518437749769352214ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 1048576) == 14920048004901212706ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 2097152) == 8758567366332536138ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 4194304) == 6226655736088907885ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 8388608) == 13716650013685832100ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 16777216) == 305325651636315638ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 33554432) == 16784147606583781671ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 67108864) == 16509467555140798205ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 134217728) == 8717281234694060584ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 268435456) == 8098476701725660537ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 536870912) == 16345871539461094006ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 1073741824) == 3755557000429964408ULL);
	ok1(hash64_stable(u8array, ARRAY_WORDS, 2147483648U) == 15017348801959710081ULL);

	ok1(hash64_stable(u16array, ARRAY_WORDS, 0) == 1038028831307724039ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 1) == 10155473272642627302ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 2) == 5714751190106841420ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 4) == 3923885607767527866ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 8) == 3931017318293995558ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 16) == 1469696588339313177ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 32) == 11522218526952715051ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 64) == 6953517591561958496ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 128) == 7406689491740052867ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 256) == 10101844489704093104ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 512) == 12511348870707245959ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 1024) == 1614019938016861468ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 2048) == 5294796182374592721ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 4096) == 16089570706643716675ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 8192) == 1689302638424579464ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 16384) == 1446340172370386893ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 32768) == 16535503506744393039ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 65536) == 3496794142527150328ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 131072) == 6568245367474548504ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 262144) == 9487676460765485949ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 524288) == 4519762130966530000ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 1048576) == 15623412069215340610ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 2097152) == 544013388676438108ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 4194304) == 5594904760290840266ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 8388608) == 18098755780041592043ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 16777216) == 6389168672387330316ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 33554432) == 896986127732419381ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 67108864) == 13232626471143901354ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 134217728) == 53378562890493093ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 268435456) == 10072361400297824771ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 536870912) == 14511948118285144529ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 1073741824) == 6981033484844447277ULL);
	ok1(hash64_stable(u16array, ARRAY_WORDS, 2147483648U) == 5619339091684126808ULL);

	ok1(hash64_stable(u32array, ARRAY_WORDS, 0) == 3037571077312110476ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 1) == 14732398743825071988ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 2) == 14949132158206672071ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 4) == 1291370080511561429ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 8) == 10792665964172133092ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 16) == 14250138032054339435ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 32) == 17136741522078732741ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 64) == 3260193403318236635ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 128) == 10526616652205653536ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 256) == 9019690373358576579ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 512) == 6997491436599677436ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 1024) == 18302783371416533798ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 2048) == 10149320644446516025ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 4096) == 7073759949410623868ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 8192) == 17442399482223760073ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 16384) == 2983906194216281861ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 32768) == 4975845419129060524ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 65536) == 594019910205413268ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 131072) == 11903010186073691112ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 262144) == 7339636527154847008ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 524288) == 15243305400579108736ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 1048576) == 16737926245392043198ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 2097152) == 15725083267699862972ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 4194304) == 12527834265678833794ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 8388608) == 13908436455987824848ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 16777216) == 9672773345173872588ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 33554432) == 2305314279896710501ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 67108864) == 1866733780381408751ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 134217728) == 11906263969465724709ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 268435456) == 5501594918093830069ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 536870912) == 15823785789276225477ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 1073741824) == 17353000723889475410ULL);
	ok1(hash64_stable(u32array, ARRAY_WORDS, 2147483648U) == 7494736910655503182ULL);

	ok1(hash64_stable(u64array, ARRAY_WORDS, 0) == 9765419389786481410ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 1) == 11182806172127114246ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 2) == 2559155171395472619ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 4) == 3311692033324815378ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 8) == 1297175419505333844ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 16) == 617896928653569210ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 32) == 1517398559958603553ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 64) == 4504821917445110758ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 128) == 1971743331114904452ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 256) == 6177667912354374306ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 512) == 15570521289777792458ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 1024) == 9204559632415917331ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 2048) == 9008982669760028237ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 4096) == 14803537660281700281ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 8192) == 2873966517448487327ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 16384) == 5859277625928363661ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 32768) == 15520461285618185970ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 65536) == 16746489793331175369ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 131072) == 514952025484227461ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 262144) == 10867212269810675249ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 524288) == 9822204377278314587ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 1048576) == 3295088921987850465ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 2097152) == 7559197431498053712ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 4194304) == 1667267269116771849ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 8388608) == 2916804068951374862ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 16777216) == 14422558383125688561ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 33554432) == 10083112683694342602ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 67108864) == 7222777647078298513ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 134217728) == 18424513674048212529ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 268435456) == 14913668581101810784ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 536870912) == 14377721174297902048ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 1073741824) == 6031715005667500948ULL);
	ok1(hash64_stable(u64array, ARRAY_WORDS, 2147483648U) == 4827100319722378642ULL);

	return exit_status();
}
