from scripted import ScriptedJobPlugin
from staging import StagingJobPlugin

_jobplugins_by_name = {
    'scripted': ScriptedJobPlugin,
    'staging': StagingJobPlugin,
}

def register_jobplugin(cls):
    _jobplugins_by_name[cls.name] = cls

def load_jobplugin(name):
    return _jobplugins_by_name[name]
