# Bug report

## Checklist

- [ ] I searched for other issues in this repository and none addresses my problem;
- [ ] I already tried to make a clean install (deleting `node_modules` dir, `package-lock.json` or `yarn.lock` file and installing again);
- [ ] I am using a version of Node.js equal to or greater than 10.13.0 (we recently removed support for Node.js versions 8 and below);
- [ ] I tried to reproduce this issue with last version of `webpack`, if my project uses `webpack` directly.

## Describe the bug

A clear and concise description of what the bug is.

## Steps to reproduce the behavior

1. Go to '...';
2. Run command '....';
3. See error.

## Expected behavior

A clear and concise description of what you expected to happen.

## Current behavior

If applicable, add logs screenshots to help explain your problem. E.g. webpack logs.

## Environment

Please complete the following information:

- OS (e.g. macOS):
- OS Version (e.g. 10.15.7):
- Node Version (e.g. v12.17.0):
- Webpack version, if applicable (e.g. 4.43.0):

### `package.json`

If possible, please paste your project's `package.json` here;

## Additional context

Add any other context about the problem here.
