/**
* @license Apache-2.0
*
* Copyright (c) 2020 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

// MODULES //

var isPrime = require( './../../../../base/assert/is-prime' );
var isInteger = require( './../../../../base/assert/is-integer' );
var PINF = require( '@stdlib/constants/float64/pinf' );


// MAIN //

/**
* Returns a boolean indicating whether a number is a composite.
*
* @param {number} x - value to test
* @returns {boolean} boolean indicating whether a value is a composite number
*
* @example
* var bool = isComposite( 4.0 );
* // returns true
*
* @example
* var bool = isComposite( 5.0 );
* // returns false
*/
function isComposite( x ) {
	return isInteger( x ) && ( x > 1 ) && x !== PINF && isPrime( x ) === false;
}


// EXPORTS //

module.exports = isComposite;
