Building the NetCDF-4.2 and later Fortran libraries {#building_netcdf_fortran}
===================================================

[TOC]

In versions before 4.2, the Fortran netCDF library source was bundled
with the C library source in one distribution. With more recent
versions, the Fortran netCDF library has been split off into an
independent source distribution, intended to be built as a separate
library, *after* the C library is built and installed. This separation
simplifies the building and use of the C and Fortran netCDF libraries
and allows them to evolve independently.

More recently, building netcdf-fortran as an automated step in the
netcdf-c build is now possible (for non-MSVC builds) by using new
options at configure time, so if you haven't built and installed the
netCDF-C library yet, you may want to try the new netCDF-C <a
href="http://www.unidata.ucar.edu/software/netcdf/docs/getting_and_building_netcdf.html#getting"
>Fortran-bootstrap procedure</a>.

In the example commands below, we assume use of a
POSIX-standard shell, such as sh, bash, ksh, or zsh. If you are using
csh instead, you will have to use the

       setenv ENV_VARIABLE  value

syntax to set environment variables instead of the

       ENV_VARIABLE=value

syntax used in the examples. In either case, `${VAR}` is the
value of the shell variable or environment variable VAR.

It will be easier to build the netCDF Fortran library if the C (and if
needed, HDF5) libraries are built as shared libraries (the default), but
you can also use static libraries, as described in a later section.

Building with shared libraries {#building_fortran_shared_libraries}
==============================

1.  First make sure the netCDF C library has been built, tested, and
    installed. The shell variable NCDIR should be set such that
    the shared library for netCDF C is under `${NCDIR}/lib` and
    netCDF utilities such as ncdump are under `${NCDIR}/bin`. For example:

        NCDIR=/usr/local
    
2.  The configure script will try to determine suitable Fortran and C
    compilers for building netCDF Fortran, but you can instead specify
    them with the FC and CC environment variables, if needed. For
    example:

		CC=/usr/local/cc
		FC=/usr/local/fortran
    
3.  If the netCDF C library was installed as a shared library in a
    location that is not searched by default, you will need to set the
    LD\_LIBRARY\_PATH environment variable (or DYLD\_LIBRARY\_PATH on
    OSX) to specify that directory before running the configure script.
    For example:

        export LD_LIBRARY_PATH=${NCDIR}/lib:${LD_LIBRARY_PATH}

4.  If you set the LD\_LIBRARY\_PATH (or DYLD\_LIBRARY\_PATH)
    environment variable in the previous step, don't use "sudo"
    before the following "configure" or "make check" commands.
    Using "sudo" causes the LD\_\* environment variables to be
    ignored. You can use "sudo make install" as the last
    step if necessary, but don't use "sudo" before that.
    
5.  Set the shell variable `NFDIR` to where you want to install
    netCDF Fortran, which can be the same location where the netCDF C
    was installed (default /usr/local), but **not** the source
    directory where you are building the software.  Then, from the top-level
    source directory, run the configure script, using CPPFLAGS and LDFLAGS to
    specify where the netCDF C library was installed:

		NFDIR=/usr/local
        CPPFLAGS=-I${NCDIR}/include LDFLAGS=-L${NCDIR}/lib \
		./configure --prefix=${NFDIR}

    If you are cross-compiling, you should also include the configure
    option "--disable-fortran-type-check", as in:

        CPPFLAGS=-I${NCDIR}/include LDFLAGS=-L${NCDIR}/lib \
        ./configure --prefix=${NFDIR} --disable-fortran-type-check

	To see other configure options, run `configure --help`.

6.  If that succeeds, run

		make check

7.  If that succeeds, run

		make install

	or

		sudo make install

If you encounter problems, send the complete "config.log" file
generated by running configure to support-netcdf@unidata.ucar.edu.

Building with static libraries {#building_fortran_with_static_libraries}
==============================

If you can't build the C netCDF library as a shared library or if it has
already been installed by someone else only as a static library (which
means there are no libnetcdf.so files in the library directory where the
netCDF C library was installed), then building and installing the
Fortran netCDF libraries will be more complicated.
    
1.  The configure script will try to determine suitable Fortran and C
    compilers for building netCDF Fortran, but you can also, specify
    them with the FC and CC environment variables.

2.  Assume the static netCDF C library is installed under `${NCDIR}`,
    the HDF5 library under `${H5DIR}`, and other needed libraries
    such as zlib and curl under `${ODIR}`. Some or all of these could
    be the same (for example /usr/local).

3.  Let the shell variable `${NFDIR}` specify where you want to
    install the netCDF Fortran library.  This can be the same location
    where the netCDF C library is installed (default is /usr/local).

4.  Set the CPPFLAGS, LDFLAGS, LD\_LIBRARY\_PATH, and LIBS environment
    variables to specify where the netCDF C library is installed and
    where the other libraries may be found. For example:

        CPPFLAGS="-I${NCDIR}/include -I${H5DIR}/include -I${ODIR}/include" \
        LDFLAGS="-L${NCDIR}/lib -L${H5DIR}/lib -L${ODIR}/lib" \
        LD_LIBRARY_PATH=${NCDIR}/lib:${H5DIR}/lib:${ODIR}/lib \
        LIBS="-lnetcdf -lhdf5_hl -lhdf5 -lz -lcurl" \
        ./configure --disable-shared --prefix=${NCDIR}

    If you are cross-compiling, you should also include the configure
    option "--disable-fortran-type-check".

5.  For parallel I/O: The configure script sets CFLAGS appropriately for
    standard compilers, but if you are building with parallel I/O using
    wrappers such as mpicc, mpif90, and mpif77, specify compilers
    using the CC, FC, and F77 variables before configure.  For example:

        CC=mpicc FC=mpif90 F77=mpif77 CPPFLAGS=-I${NCDIR}/include \
        LDFLAGS=-L${NCDIR}/lib ./configure --prefix=${NFDIR}

    You may have to use absolute path names for CC, F90, and F77 if
	configure can't find them. Finally, you may also need to set
	CFLAGS to indicate which Fortran compiler is wrapped by mpif90 nd
	mpif77. For example, if "mpif90 --show" indicates gfortran is
	being used, then set CFLAGS=-DgFortran, and similarly set
	CFLAGS=-DpgiFortran for Portland Group compilers.

6.  If that succeeds, run "make check".

7.  If that succeeds, run "make install" or "sudo make install".

If you encounter problems, send the complete "config.log" file
generated by running configure to support-netcdf@unidata.ucar.edu.

Linking your programs with netCDF Fortran libraries {#linking_against_netcdf_fortran}
==============================

If you built the shared libraries, you can link with something like

    fortran my_prog.f -o my_prog -I${NFDIR}/include -L${NFDIR}/lib -lnetcdff

to link your Fortran software with the installed netCDF Fortran and C
libraries.

If you didn't install the shared libraries in a standard place, you
may need to set LD\_LIBRARY\_PATH (or DYLD\_LIBRARY\_PATH for OSX) to
include `${NFDIR}/lib` before running the resulting
program. Alternatively, you may add `${NFDIR}/lib` to the
LD\_RUN\_PATH environment variable before linking, or use the
`-Wl,-rpath -Wl,${NFDIR}/lib` linker flag, or have your system
administrator add `${NFDIR}/lib` to `/etc/ld.so.conf'.  See
operating system documentation about shared libraries for more
information, such as the ld(1) and ld.so(8) manual pages.

If you built static libraries, you will need to use something like

    fortran my_prog.f -o my_prog -I${NFDIR}/include \
    -L${NCDIR}/lib -lnetcdff -lnetcdf \
	-L${H5DIR}/lib -lhdf5_hl -lhdf5 -L${ODIR} -lz -lcurl -lm

to link Fortran software with the installed Fortran library and the
libraries on which it depends.

A simpler alternative that should work for either shared or static
libraries is to use the "nf-config" utility installed in `${NFDIR}/bin`:

	fortran my_prog.f -o my_prog `nf-config --fflags --flibs`

or the more general "pkg-config" utility, if you have it:

	fortran my_prog.f -o my_prog `pkg-config --cflags --libs netcdf-fortran`

Specifying The Environment for Building {#specify_build_env_fortran}
========================================

For cross-compiles, the following environment variables can be used to override the default fortran/C type settings like this (in sh):

     export NCBYTE_T="integer(selected_int_kind(2))"
     export NCSHORT_T="integer*2"
     export NF_INT1_T="integer(selected_int_kind(2))"
     export NF_INT2_T="integer*2"
     export NF_INT1_IS_C_SHORT=1
     export NF_INT2_IS_C_SHORT=1
     export NF_INT_IS_C_INT=1
     export NF_REAL_IS_C_FLOAT=1
     export NF_DOUBLEPRECISION_IS_C_DOUBLE=1
     
In this case you will need to run configure with `–disable-fortran-compiler-check` and `–disable-fortran-type-check`.

Environment Variable Description Notes
--------------------------

Variable | Usage | Description
---|---|---
CC	| C compiler	| If you don't specify this, the configure script will try to find a suitable C compiler. The default choice is gcc. If you wish to use a vendor compiler you must set CC to that compiler, and set other environment variables (as described below) to appropriate settings.
FC	| Fortran compiler (if any) | 	If you don't specify this, the configure script will try to find a suitable Fortran and Fortran 77 compiler. Use –disable-f90 to disable the netCDF Fortran 90 API, but build the netCDF Fortran 77 API.
F77	| Fortran 77 compiler (if any)	| Only specify this if your platform explicitly needs a different Fortran 77 compiler. Otherwise use FC to specify the Fortran compiler. If you don't specify this, the configure script will try to find a suitable Fortran compiler. For vendor compilers, make sure you're using the same vendor's Fortran 90 compiler. Using Fortran compilers from different vendors is not supported and may not work.
CFLAGS	| C compiler flags	| "-O -g2", for example.
CPPFLAGS	| C preprocessor options	| "-DNDEBUG" to omit assertion checks, for example.
FCFLAGS| 	Fortran 90 compiler flags	| "-O" or "-g", for example. These flags will be used for FORTRAN 90. If setting these you may also need to set FFLAGS for the FORTRAN 77 test programs.
FFLAGS	| Fortran 77 compiler flags	| "-O" or "-g", for example. If you need to pass the same arguments to the FORTRAN 90 build, also set FCFLAGS.
ARFLAGS, NMFLAGS, FPP, M4FLAGS, LIBS, FLIBS, FLDFLAGS	| Miscellaneous	| One or more of these may be needed for some platforms. Unless required, you should not set these environment variables, because that may interfere with the configure script. 
