/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.web.struts.dialogs;

import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.struts.StrutsConfigDataObject;
import org.netbeans.modules.web.struts.StrutsConfigUtilities;
import org.netbeans.modules.web.struts.config.model.Action;
import org.openide.util.NbBundle;

/**
 *
 * @author  petr
 */
public class AddFIActionPanel extends javax.swing.JPanel implements ValidatingPanel {
    private StrutsConfigDataObject config;
    /** Creates new form AddFIActionPanel */
    public AddFIActionPanel(StrutsConfigDataObject dObject) {
        config = dObject;
        initComponents();
        List actions = StrutsConfigUtilities.getAllActionsInModule(config);
        DefaultComboBoxModel model = (DefaultComboBoxModel)cbAction.getModel();
        //model.removeAllElements();
        Iterator iter = actions.iterator();
        while (iter.hasNext())
            model.addElement(((Action)iter.next()).getAttributeValue("path"));
    }

    public String validatePanel() {
        String actionPath = getActionPath();
        if (actionPath==null || actionPath.equals("/")) //NOI18N
            return NbBundle.getMessage(AddFIActionPanel.class,"MSG_EmptyActionPath");
        if (!actionPath.startsWith("/") ) //NOI18N
            return NbBundle.getMessage(AddFIActionPanel.class,"MSG_IncorrectActionPath", actionPath);
        if (containsActionPath(actionPath)) //NOI18N
            return NbBundle.getMessage(AddFIActionPanel.class,"MSG_DupliciteActionPath",actionPath);
        if (rbResourceFile.isSelected() && tResourceFile.getText().trim().length()==0) {
            return NbBundle.getMessage(AddFIActionPanel.class,"MSG_EmptyResourceFile");
        } else if (rbAction.isSelected() && cbAction.getSelectedItem()==null) {
            return NbBundle.getMessage(AddFIActionPanel.class,"MSG_EmptyAction");
        } else return null;
    }

    public javax.swing.AbstractButton[] getStateChangeComponents() {
        return new javax.swing.AbstractButton[]{ rbResourceFile };
    }

    public javax.swing.text.JTextComponent[] getDocumentChangeComponents() {
        return new javax.swing.text.JTextComponent[]{jTextFieldPath, tResourceFile};
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        bgActionType = new javax.swing.ButtonGroup();
        bgCall = new javax.swing.ButtonGroup();
        jPopupMenu1 = new javax.swing.JPopupMenu();
        lActionType = new javax.swing.JLabel();
        rbIncludeAction = new javax.swing.JRadioButton();
        rbForwardAction = new javax.swing.JRadioButton();
        lCall = new javax.swing.JLabel();
        rbResourceFile = new javax.swing.JRadioButton();
        rbAction = new javax.swing.JRadioButton();
        tResourceFile = new javax.swing.JTextField();
        bBrowse = new javax.swing.JButton();
        cbAction = new javax.swing.JComboBox();
        jLabelPath = new javax.swing.JLabel();
        jTextFieldPath = new javax.swing.JTextField();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(12, 12, 11, 11));
        setLayout(new java.awt.GridBagLayout());

        lActionType.setText(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "LBL_ActionType")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(lActionType, gridBagConstraints);

        bgActionType.add(rbIncludeAction);
        rbIncludeAction.setMnemonic(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "RB_Include_mnem").charAt(0));
        rbIncludeAction.setText(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "RB_Include")); // NOI18N
        rbIncludeAction.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 20, 0, 0);
        add(rbIncludeAction, gridBagConstraints);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/web/struts/dialogs/Bundle"); // NOI18N
        rbIncludeAction.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_rbIncudeAction")); // NOI18N

        bgActionType.add(rbForwardAction);
        rbForwardAction.setMnemonic(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "RB_Forward_mnem").charAt(0));
        rbForwardAction.setSelected(true);
        rbForwardAction.setText(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "RB_Forward")); // NOI18N
        rbForwardAction.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 20, 0, 0);
        add(rbForwardAction, gridBagConstraints);
        rbForwardAction.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_rbForwardAction")); // NOI18N

        lCall.setText(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "LBL_Call")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
        add(lCall, gridBagConstraints);

        bgCall.add(rbResourceFile);
        rbResourceFile.setMnemonic(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "RB_ResourceFile_mnem").charAt(0));
        rbResourceFile.setSelected(true);
        rbResourceFile.setText(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "RB_ResourceFile")); // NOI18N
        rbResourceFile.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rbResourceFile.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                rbResourceFileItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 20, 0, 0);
        add(rbResourceFile, gridBagConstraints);
        rbResourceFile.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_rbResourceFile2")); // NOI18N

        bgCall.add(rbAction);
        rbAction.setMnemonic(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "RB_Action_mnem").charAt(0));
        rbAction.setText(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "RB_Action")); // NOI18N
        rbAction.setMargin(new java.awt.Insets(0, 0, 0, 0));
        rbAction.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                rbActionItemStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(6, 20, 0, 0);
        add(rbAction, gridBagConstraints);
        rbAction.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_rbAction")); // NOI18N

        tResourceFile.setMinimumSize(new java.awt.Dimension(200, 24));
        tResourceFile.setPreferredSize(new java.awt.Dimension(200, 24));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        add(tResourceFile, gridBagConstraints);
        tResourceFile.getAccessibleContext().setAccessibleName(bundle.getString("ACSD_tResourceFile")); // NOI18N
        tResourceFile.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_tResourceFile")); // NOI18N

        bBrowse.setMnemonic(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "LBL_Browse_mnem").charAt(0));
        bBrowse.setText(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "LBL_BrowseButton")); // NOI18N
        bBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bBrowseActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        add(bBrowse, gridBagConstraints);
        bBrowse.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_bBrowse")); // NOI18N

        cbAction.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(6, 12, 0, 0);
        add(cbAction, gridBagConstraints);
        cbAction.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "ACSN_FIAction")); // NOI18N
        cbAction.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_cbAction")); // NOI18N

        jLabelPath.setDisplayedMnemonic(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "LBL_ActionPath_mnem").charAt(0));
        jLabelPath.setLabelFor(jTextFieldPath);
        jLabelPath.setText(org.openide.util.NbBundle.getMessage(AddFIActionPanel.class, "LBL_ActionPath")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jLabelPath, gridBagConstraints);

        jTextFieldPath.setColumns(30);
        jTextFieldPath.setText("/");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 12, 0, 0);
        add(jTextFieldPath, gridBagConstraints);
        jTextFieldPath.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_jTextFieldPath")); // NOI18N

        getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_AddFIActionPanel")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void bBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bBrowseActionPerformed
        try{
        org.netbeans.api.project.SourceGroup[] groups = StrutsConfigUtilities.getDocBaseGroups(config.getPrimaryFile());
            org.openide.filesystems.FileObject fo = BrowseFolders.showDialog(groups);
            if (fo!=null) {
                String res = "/"+StrutsConfigUtilities.getResourcePath(groups,fo,'/',true);
                tResourceFile.setText(res);
            }
        } catch (java.io.IOException ex) {}
    }//GEN-LAST:event_bBrowseActionPerformed

    private void rbResourceFileItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_rbResourceFileItemStateChanged
        tResourceFile.setEnabled(true);
        bBrowse.setEnabled(true);
        cbAction.setEnabled(false);
    }//GEN-LAST:event_rbResourceFileItemStateChanged

    private void rbActionItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_rbActionItemStateChanged
        tResourceFile.setEnabled(false);
        bBrowse.setEnabled(false);
        cbAction.setEnabled(true);
    }//GEN-LAST:event_rbActionItemStateChanged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bBrowse;
    private javax.swing.ButtonGroup bgActionType;
    private javax.swing.ButtonGroup bgCall;
    private javax.swing.JComboBox cbAction;
    private javax.swing.JLabel jLabelPath;
    private javax.swing.JPopupMenu jPopupMenu1;
    private javax.swing.JTextField jTextFieldPath;
    private javax.swing.JLabel lActionType;
    private javax.swing.JLabel lCall;
    private javax.swing.JRadioButton rbAction;
    private javax.swing.JRadioButton rbForwardAction;
    private javax.swing.JRadioButton rbIncludeAction;
    private javax.swing.JRadioButton rbResourceFile;
    private javax.swing.JTextField tResourceFile;
    // End of variables declaration//GEN-END:variables
    
    public String getActionPath() {
        String path = jTextFieldPath.getText().trim();
        return path.length()==0?null:path;
    }
    
    public boolean isForward() {
        return rbForwardAction.isSelected();
    }
    
    public String getResource() {
        if (rbResourceFile.isSelected()) {
            String resource=tResourceFile.getText().trim();
            return resource.length()==0?null:resource;
        } else {
            return StrutsConfigUtilities.getActionAsResource(
                    WebModule.getWebModule(config.getPrimaryFile()),
                    (String)cbAction.getSelectedItem());
        }
    }
    
    private boolean containsActionPath(String path) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)cbAction.getModel();
        for (int i=0; i<model.getSize(); i++) {
            if (path.equals(model.getElementAt(i))) return true;
        }
        return false;
    }
}
