/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

/*
 * QuickRunPanel.java
 *
 * Created on 4/8/2004, 18:25
 */
package org.netbeans.modules.mobility.project.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.util.NbBundle;

/**
 *
 * @author  Adam Sotona
 */
public class QuickRunPanel extends JPanel implements ActionListener {
    
    private static String lastPlatformName;
    private static String lastDeviceName = null;
    
    /** Creates new form QuickRunPanel */
    public QuickRunPanel(String platformType, String platformName, String deviceName) {
        if (lastPlatformName == null) {
            lastPlatformName = platformName;
            lastDeviceName = deviceName;
        }
        
        initComponents();
        initAccessibility();
        JavaPlatform jp[] = JavaPlatformManager.getDefault().getPlatforms(null, new Specification(platformType, null));
        Vector<J2MEPlatform> a = new Vector<J2MEPlatform>();
        int selected = 0;
        for (int i=0; i<jp.length; i++) {
            if (jp[i] instanceof J2MEPlatform) {
                if (lastPlatformName != null && (lastPlatformName.equals(((J2MEPlatform)jp[i]).getName()))) selected = a.size();
                a.add((J2MEPlatform)jp[i]);
            }
        }
        jComboBoxPlatform.setModel(new DefaultComboBoxModel(a));
        if (a.size() > 0) jComboBoxPlatform.setSelectedIndex(selected);
        actionPerformed(null);
        jComboBoxPlatform.addActionListener(this);
        jComboBoxDevice.addActionListener(this);
    }
    
    public String getPlatformName() {
        final Object o = jComboBoxPlatform.getSelectedItem();
        return o instanceof J2MEPlatform ? ((J2MEPlatform)o).getName() : null;
    }
    
    public String getDeviceName() {
        return (String) jComboBoxDevice.getSelectedItem();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jLabelPlatform = new javax.swing.JLabel();
        jComboBoxPlatform = new javax.swing.JComboBox();
        jLabelDevice = new javax.swing.JLabel();
        jComboBoxDevice = new javax.swing.JComboBox();

        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(QuickRunPanel.class, "LBL_QuickRun_Warning")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 0, 11);
        add(jLabel1, gridBagConstraints);

        jLabelPlatform.setLabelFor(jComboBoxPlatform);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelPlatform, org.openide.util.NbBundle.getBundle(QuickRunPanel.class).getString("LBL_QuickRun_Platform")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 0, 0);
        add(jLabelPlatform, gridBagConstraints);
        jLabelPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickRunPanel.class, "ACSD_QuicRun_Platform")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(11, 5, 0, 11);
        add(jComboBoxPlatform, gridBagConstraints);

        jLabelDevice.setLabelFor(jComboBoxDevice);
        org.openide.awt.Mnemonics.setLocalizedText(jLabelDevice, org.openide.util.NbBundle.getBundle(QuickRunPanel.class).getString("LBL_QuickRun_Device")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(11, 11, 11, 0);
        add(jLabelDevice, gridBagConstraints);
        jLabelDevice.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(QuickRunPanel.class, "ACSD_QuicRun_Device")); // NOI18N

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(11, 5, 11, 11);
        add(jComboBoxDevice, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents
    
    private void initAccessibility() {
        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getBundle(QuickRunPanel.class).getString("ACSN_QuickRun"));
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getBundle(QuickRunPanel.class).getString("ACSD_QuickRun"));
    }
    
    final public void actionPerformed(final ActionEvent e) {
        if (e == null || jComboBoxPlatform.equals(e.getSource())) {
            final Object o = jComboBoxPlatform.getSelectedItem();
            if (o instanceof J2MEPlatform) {
                lastPlatformName = ((J2MEPlatform)o).getName();
                final J2MEPlatform.Device d[] = ((J2MEPlatform)o).getDevices();
                int selected = 0;
                final Vector<String> a = new Vector<String>();
                for (int i=0; i<d.length; i++) {
                    if (lastDeviceName != null && lastDeviceName.equals(d[i].getName())) selected = a.size();
                    a.add(d[i].getName());
                }
                jComboBoxDevice.setModel(new DefaultComboBoxModel(a));
                jComboBoxDevice.setSelectedIndex(selected);
                lastDeviceName = (String)jComboBoxDevice.getSelectedItem();
            }
        } else {
            lastDeviceName = (String)jComboBoxDevice.getSelectedItem();
        }
    }
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxDevice;
    private javax.swing.JComboBox jComboBoxPlatform;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelDevice;
    private javax.swing.JLabel jLabelPlatform;
    // End of variables declaration//GEN-END:variables
    
}
