/* $Id: autogenerated_cleanup.cpp 642714 2021-12-27 19:03:59Z fukanchi $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */
/// This file was generated by application DATATOOL
///
/// ATTENTION:
///   Don't edit or commit this file into SVN as this file will
///   be overridden (by DATATOOL) without warning!

#include <ncbi_pch.hpp>
#include "autogenerated_cleanup.hpp"
#include "cleanup_utils.hpp"
#include "autogenerated_cleanup_extra.hpp"
#include <objects/misc/sequence_macros.hpp>

BEGIN_SCOPE(ncbi)
BEGIN_SCOPE(objects)

//LCOV_EXCL_START
// autogenerated code - includes functions for unused ASN.1 spec elements

void CAutogeneratedCleanup::x_BasicCleanupDate(CDate& date)
{
    if (date.IsStd()) {
        m_NewCleanup.x_DateStdBC(date.SetStd());
    }
}

void CAutogeneratedCleanup::x_BasicCleanupSeqId(CSeq_id & seq_id)
{ // type Choice
  m_NewCleanup.SeqIdBC(seq_id);
  if (seq_id.IsPdb() && seq_id.GetPdb().IsSetRel()) {
      x_BasicCleanupDate(seq_id.SetPdb().SetRel());
  }
} // end of x_BasicCleanupSeqId


void CAutogeneratedCleanup::x_BasicCleanupSeqPoint( CSeq_point & seq_point )
{ // type Reference
    if (seq_point.IsSetId()) {
        x_BasicCleanupSeqId(seq_point.SetId());
    }
} // end of x_BasicCleanupSeqPoint

void CAutogeneratedCleanup::x_BasicCleanupSeqBond(CSeq_bond & seq_bond)
{ // type Sequence
  if(seq_bond.IsSetA() ) {
    x_BasicCleanupSeqPoint(seq_bond.SetA());
  }
  if(seq_bond.IsSetB()) {
    x_BasicCleanupSeqPoint(seq_bond.SetB());
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_ext_locs_E_E_location_location_bond_bond_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqLocEquiv( CSeq_loc_equiv & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupSeqLocs( arg0.Set() );
  }
} // end of x_BasicCleanupSeqLocEquiv

void CAutogeneratedCleanup::x_BasicCleanupSeqInt(CSeq_interval & seq_int)
{ // type Reference
    if (seq_int.IsSetId()) {
        x_BasicCleanupSeqId(seq_int.SetId());
    }
} // end of x_BasicCleanupSeqInt


void CAutogeneratedCleanup::x_BasicCleanupSeqLocMix( CSeq_loc_mix & arg0 )
{ // type Reference
  m_NewCleanup.SeqLocMixBC( arg0 );
  if( arg0.IsSet() ) {
      x_BasicCleanupSeqLocs(arg0.Set());
  }
} // end of x_BasicCleanupSeqLocMix

template< typename Tcontainer_ncbi_cref_cseq_interval_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqInts( Tcontainer_ncbi_cref_cseq_interval_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cseq_interval_, iter, arg0 ) {
    x_BasicCleanupSeqInt( **iter );
  }
} // end of x_BasicCleanupSeqInts

void CAutogeneratedCleanup::x_BasicCleanupPackedSeqInt( CPacked_seqint & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
      for (auto pInt : arg0.Set()) {
          x_BasicCleanupSeqInt(*pInt);
      }
  }
} // end of x_BasicCleanupPackedSeqInt


void CAutogeneratedCleanup::x_BasicCleanupPackedPoint(CPacked_seqpnt & packed_point)
{ // type Reference
    if (packed_point.IsSetId()) {
        x_BasicCleanupSeqId(packed_point.SetId());
    }
} // end of x_BasicCleanupPackedPoint

void CAutogeneratedCleanup::x_BasicCleanupSeqLoc( CSeq_loc & arg0 )
{ // type Choice
  m_NewCleanup.SeqLocBC( arg0 );
  m_NewCleanup.x_BothStrandBC( arg0 );
  switch( arg0.Which() ) {
  case CSeq_loc::e_Bond:
    x_BasicCleanupSeqBond( arg0.SetBond() );
    break;
  case CSeq_loc::e_Empty:
    x_BasicCleanupSeqId( arg0.SetEmpty() );
    break;
  case CSeq_loc::e_Equiv:
    x_BasicCleanupSeqLocEquiv( arg0.SetEquiv() );
    break;
  case CSeq_loc::e_Int:
    x_BasicCleanupSeqInt( arg0.SetInt() );
    break;
  case CSeq_loc::e_Mix:
    x_BasicCleanupSeqLocMix( arg0.SetMix() );
    break;
  case CSeq_loc::e_Packed_int:
    x_BasicCleanupPackedSeqInt( arg0.SetPacked_int() );
    break;
  case CSeq_loc::e_Packed_pnt:
    x_BasicCleanupPackedPoint(arg0.SetPacked_pnt());
    break;
  case CSeq_loc::e_Pnt:
    x_BasicCleanupSeqPoint(arg0.SetPnt());
    break;
  case CSeq_loc::e_Whole:
    x_BasicCleanupSeqId( arg0.SetWhole() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqLoc

template<typename TSeqLocContainer>
void CAutogeneratedCleanup::x_BasicCleanupSeqLocs(TSeqLocContainer& locs)
{ // type UniSequence
    for (auto pLoc : locs) {
        x_BasicCleanupSeqLoc(*pLoc);
    }
} // end of x_BasicCleanupSeqLocs

template<typename TSeqIdContainer>
void CAutogeneratedCleanup::x_BasicCleanupSeqIds(TSeqIdContainer& ids)
{
    for (auto pId : ids) {
        x_BasicCleanupSeqId(*pId);
    }
}


void CAutogeneratedCleanup::x_BasicCleanupDenseDiag( CDense_diag & arg0 )
{ // type Sequence
  if( arg0.IsSetIds() ) {
    x_BasicCleanupSeqIds( arg0.SetIds() );
  }
} // end of x_BasicCleanupDenseDiag

template<typename TDenseDiagContainer>
void CAutogeneratedCleanup::x_BasicCleanupDenseDiags(TDenseDiagContainer& dense_diags)
{ // type UniSequence
  for (auto pDenseDiag : dense_diags) {
    x_BasicCleanupDenseDiag(*pDenseDiag);
  }
} // end of x_BasicCleanupDenseDiags


void CAutogeneratedCleanup::x_BasicCleanupDenseg( CDense_seg & denseg )
{ // type Reference
    if (denseg.IsSetIds()) {
        x_BasicCleanupSeqIds(denseg.SetIds());
    }
} // end of x_BasicCleanupDenseg


void CAutogeneratedCleanup::x_BasicCleanupSeqAlignSet(CSeq_align_set & align_set)
{ // type Reference
  if( align_set.IsSet() ) {
    for (auto pAlign : align_set.Set()) {
        x_BasicCleanupSeqAlign(*pAlign);
    }
  }
} // end of x_BasicCleanupSeqAlignSet

void CAutogeneratedCleanup::x_BasicCleanupPackedSeg( CPacked_seg & arg0 )
{ // type Reference
    if (arg0.IsSetIds()) {
        x_BasicCleanupSeqIds( arg0.SetIds() );
    }
} // end of x_BasicCleanupPackedSeg

void CAutogeneratedCleanup::x_BasicCleanupSparseAlign( CSparse_align & arg0 )
{ // type Sequence
  if( arg0.IsSetFirst_id() ) {
    x_BasicCleanupSeqId( arg0.SetFirst_id() );
  }
  if( arg0.IsSetSecond_id() ) {
    x_BasicCleanupSeqId( arg0.SetSecond_id() );
  }
} // end of x_BasicCleanupSparseAlign


void CAutogeneratedCleanup::x_BasicCleaupSparseSeg( CSparse_seg & arg0 )
{ // type Sequence
  if( arg0.IsSetMaster_id() ) {
    x_BasicCleanupSeqId( arg0.SetMaster_id() );
  }
  if( arg0.IsSetRows() ) {
    for (auto pSparseAlign : arg0.SetRows()) {
        x_BasicCleanupSparseAlign(*pSparseAlign);
    }
  }
} // end of x_BasicCleaupSparseSeg

void CAutogeneratedCleanup::x_BasicCleanupSplicedExon( CSpliced_exon & arg0 )
{ // type Sequence
  if( arg0.IsSetGenomic_id() ) {
    x_BasicCleanupSeqId( arg0.SetGenomic_id() );
  }
  if( arg0.IsSetProduct_id() ) {
    x_BasicCleanupSeqId( arg0.SetProduct_id() );
  }
} // end of x_BasicCleanupSplicedExon

void CAutogeneratedCleanup::x_BasicCleanupSplicedSeg( CSpliced_seg & arg0 )
{ // type Sequence
  if( arg0.IsSetExons() ) {
    for (auto pSplicedExon : arg0.SetExons()) {
        x_BasicCleanupSplicedExon(*pSplicedExon);
    }
  }
  if( arg0.IsSetGenomic_id() ) {
    x_BasicCleanupSeqId( arg0.SetGenomic_id() );
  }
  if( arg0.IsSetProduct_id() ) {
    x_BasicCleanupSeqId( arg0.SetProduct_id() );
  }
} // end of x_BasicCleanupAlignSegs_spliced_spliced_ETC

void CAutogeneratedCleanup::x_BasicCleanupStdSeg( CStd_seg & arg0 )
{ // type Sequence
  if( arg0.IsSetIds() ) {
    x_BasicCleanupSeqIds( arg0.SetIds() );
  }
  if( arg0.IsSetLoc() ) {
    x_BasicCleanupSeqLocs( arg0.SetLoc() );
  }
} // end of x_BasicCleanupStdSeg


void CAutogeneratedCleanup::x_BasicCleanupAlignSegs( CSeq_align::C_Segs & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeq_align::C_Segs::e_Dendiag:
    x_BasicCleanupDenseDiags(arg0.SetDendiag());
    break;
  case CSeq_align::C_Segs::e_Denseg:
    x_BasicCleanupDenseg( arg0.SetDenseg() );
    break;
  case CSeq_align::C_Segs::e_Disc:
    x_BasicCleanupSeqAlignSet( arg0.SetDisc() );
    break;
  case CSeq_align::C_Segs::e_Packed:
    x_BasicCleanupPackedSeg( arg0.SetPacked() );
    break;
  case CSeq_align::C_Segs::e_Sparse:
    x_BasicCleaupSparseSeg( arg0.SetSparse() );
    break;
  case CSeq_align::C_Segs::e_Spliced:
    x_BasicCleanupSplicedSeg( arg0.SetSpliced() );
    break;
  case CSeq_align::C_Segs::e_Std:
    for (auto pStdSeg : arg0.SetStd()) {
        x_BasicCleanupStdSeg(*pStdSeg);
    }
    break;
  default:
    break;
  }
} // end of x_BasicCleanupAlignSegs

void CAutogeneratedCleanup::x_BasicCleanupSeqAlign( CSeq_align & arg0 )
{ // type Sequence
  if( arg0.IsSetBounds() ) {
    x_BasicCleanupSeqLocs( arg0.SetBounds() );
  }
  if( arg0.IsSetSegs() ) {
    x_BasicCleanupAlignSegs( arg0.SetSegs() );
  }
} // end of x_BasicCleanupSeqAlign


template <typename TSeqAlignContainer>
void CAutogeneratedCleanup::x_BasicCleanupSeqAligns(TSeqAlignContainer& aligns)
{
    for (auto pAlign : aligns) {
        x_BasicCleanupSeqAlign(*pAlign);
    }
}

void CAutogeneratedCleanup::x_BasicCleanupAffilStd( CAffil::C_Std & arg0 )
{ // type Sequence
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Affil );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, City );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Country );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Div );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Email );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Fax );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Phone );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Postal_code );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Street );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Sub );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_imp_imp_pub_pub_std_ETC


void CAutogeneratedCleanup::x_BasicCleanupAffil( CAffil & arg0 )
{ // type Choice

    if (arg0.IsStd()) {
        x_BasicCleanupAffilStd(arg0.SetStd());
    }
    else
    if (arg0.IsStr()) {
        auto& affil_str = arg0.SetStr();
        m_NewCleanup.x_CompressStringSpacesMarkChanged(affil_str);
        m_NewCleanup.x_CleanupStringMarkChanged(affil_str);
    }

} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_imp_imp_pub_pub_ETC


void CAutogeneratedCleanup::x_BasicCleanupAuthor(CAuthor & arg0)
{ // type Sequence
  if( arg0.IsSetAffil() ) {
    x_BasicCleanupAffil( arg0.SetAffil() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_authors_authors_names_std_E_E_ETC


void CAutogeneratedCleanup::x_BasicCleanupAuthListNames( CAuth_list::C_Names & arg0 )
{ // type Choice
  if (arg0.IsStd()) {
    for (auto pAuthor : arg0.SetStd()) {
        x_BasicCleanupAuthor(*pAuthor);
    }

  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_authors_authors_names_ETC

void CAutogeneratedCleanup::x_BasicCleanupAuthList( CAuth_list & arg0, bool fix_initials)
{ // type Sequence

  if (fix_initials) {
      m_NewCleanup.x_AuthListBCWithFixInitials( arg0 );
  }
  if( arg0.IsSetAffil() ) {
    x_BasicCleanupAffil( arg0.SetAffil() );
  }
  if( arg0.IsSetNames() ) {
    x_BasicCleanupAuthListNames( arg0.SetNames() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_authors_authors_ETC


void CAutogeneratedCleanup::x_BasicCleanupPubStatusDate( CPubStatusDate & arg0 )
{ // type Sequence
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate(arg0.SetDate());
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_imp_imp_history_history_E_E_ETC


void CAutogeneratedCleanup::x_BasicCleanupPubStatusDateSet( CPubStatusDateSet & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    for (auto& pPubStatusDate : arg0.Set()) {
        x_BasicCleanupPubStatusDate(*pPubStatusDate);
    }
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_imp_imp_history_ETC

void CAutogeneratedCleanup::x_BasicCleanupImprint( CImprint & arg0 )
{ // type Sequence
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Issue );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Language );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Pages );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Part_sup );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Part_supi );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Section );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Volume );
  if( arg0.IsSetCprt() ) {
    x_BasicCleanupDate( arg0.SetCprt() );
  }
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate( arg0.SetDate() );
  }
  if( arg0.IsSetHistory() ) {
    x_BasicCleanupPubStatusDateSet( arg0.SetHistory() );
  }
  if( arg0.IsSetPub() ) {
    x_BasicCleanupAffil( arg0.SetPub() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_imp_imp_ETC


void CAutogeneratedCleanup::x_BasicCleanupCitBook( CCit_book & arg0 )
{ // type Sequence
  if( arg0.IsSetAuthors() ) {
    x_BasicCleanupAuthList( arg0.SetAuthors() );
  }
  if( arg0.IsSetImp() ) {
    x_BasicCleanupImprint( arg0.SetImp() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_cit_cit_ETC


void CAutogeneratedCleanup::x_BasicCleanupCitJournal( CCit_jour & arg0 )
{ // type Sequence
  if( arg0.IsSetImp() ) {
    x_BasicCleanupImprint( arg0.SetImp() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_journal_journal_ETC


void CAutogeneratedCleanup::x_BasicCleanupMeeting( CMeeting & arg0 )
{ // type Sequence
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate(arg0.SetDate());
 //   x_BasicCleanupDate( arg0.SetDate() );
  }
  if( arg0.IsSetPlace() ) {
    x_BasicCleanupAffil( arg0.SetPlace() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_proc_proc_meet_meet_ETC


void CAutogeneratedCleanup::x_BasicCleanupCitProc( CCit_proc & arg0 )
{ // type Sequence
  if( arg0.IsSetBook() ) {
    x_BasicCleanupCitBook( arg0.SetBook() );
  }
  if( arg0.IsSetMeet() ) {
    x_BasicCleanupMeeting( arg0.SetMeet() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_proc_proc_ETC


void CAutogeneratedCleanup::x_BasicCleanupCitArtFrom( CCit_art::C_From & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CCit_art::C_From::e_Book:
    x_BasicCleanupCitBook( arg0.SetBook() );
    break;
  case CCit_art::C_From::e_Journal:
    x_BasicCleanupCitJournal( arg0.SetJournal() );
    break;
  case CCit_art::C_From::e_Proc:
    x_BasicCleanupCitProc( arg0.SetProc() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupCitArtFrom


void CAutogeneratedCleanup::x_BasicCleanupTitle( CTitle & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    for (auto pElement : arg0.Set()) {
        if (pElement && pElement->IsName()) {
            m_NewCleanup.x_StripSpacesMarkChanged(pElement->SetName() );
        }
    }
  }
} // end of x_BasicCleanupTitle

void CAutogeneratedCleanup::x_BasicCleanupCitArt( CCit_art & arg0 )
{ // type Sequence
  if( arg0.IsSetAuthors() ) {
    x_BasicCleanupAuthList( arg0.SetAuthors() );
  }
  if( arg0.IsSetFrom() ) {
    x_BasicCleanupCitArtFrom( arg0.SetFrom() );
  }
  if( arg0.IsSetTitle() ) {
    x_BasicCleanupTitle( arg0.SetTitle() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_article_article_ETC


void CAutogeneratedCleanup::x_BasicCleanupMedlineEntry( CMedline_entry & arg0 )
{ // type Sequence
  if( arg0.IsSetCit() ) {
    x_BasicCleanupCitArt( arg0.SetCit() );
  }
  if( arg0.IsSetEm() ) {
    x_BasicCleanupDate(arg0.SetEm());
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_medline_medline_ETC


void CAutogeneratedCleanup::x_BasicCleanupPatentPriority( CPatent_priority & arg0 )
{ // type Sequence
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate(arg0.SetDate());
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_patent_patent_priority_E_E_ETC


void CAutogeneratedCleanup::x_BasicCleanupCitPat( CCit_pat & arg0 )
{ // type Sequence
  if( arg0.IsSetApp_date() ) {
    x_BasicCleanupDate(arg0.SetApp_date());
  }
  if( arg0.IsSetApplicants() ) {
    x_BasicCleanupAuthList( arg0.SetApplicants() );
  }
  if( arg0.IsSetAssignees() ) {
    x_BasicCleanupAuthList( arg0.SetAssignees() );
  }
  if( arg0.IsSetAuthors() ) {
    x_BasicCleanupAuthList( arg0.SetAuthors() );
  }
  if( arg0.IsSetDate_issue() ) {
    x_BasicCleanupDate(arg0.SetDate_issue());
  }
  if( arg0.IsSetPriority() ) {
    for (auto pPriority : arg0.SetPriority()) {
        x_BasicCleanupPatentPriority(*pPriority);
    }
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_patent_patent_ETC


/*
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_cit_cit_pub_E_E_equiv_equiv_E( CPub & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_cit_cit_pub_E_E_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_cit_cit_pub_E_E_equiv_equiv_E

template< typename Tcontainer_ncbi_cref_cpub_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_cit_cit_pub_E_E_equiv_equiv( Tcontainer_ncbi_cref_cpub_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cpub_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_cit_cit_pub_E_E_equiv_equiv_E( **iter );
  }
} // end of x_BasicCleanupSeqFeat_cit_cit_pub_E_E_equiv_equiv

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_cit_cit_pub_E_E_equiv( CPub_equiv & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupSeqFeat_cit_cit_pub_E_E_equiv_equiv( arg0.Set() );
  }
} // end of x_BasicCleanupSeqFeat_cit_cit_pub_E_E_equiv
*/


void CAutogeneratedCleanup::x_BasicCleanupCitGen( CCit_gen & arg0 )
{ // type Sequence
  if( arg0.IsSetAuthors() ) {
    x_BasicCleanupAuthList( arg0.SetAuthors() );
  }
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate(arg0.SetDate());
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_gen_gen_ETC


void CAutogeneratedCleanup::x_BasicCleanupCitLet( CCit_let & arg0 )
{ // type Sequence
  if( arg0.IsSetCit() ) {
    x_BasicCleanupCitBook( arg0.SetCit() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_pub_man_man_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_cit_ETC( CPub_set & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CPub_set::e_Article:
    for (auto pCitArt : arg0.SetArticle()) {
        x_BasicCleanupCitArt(*pCitArt);
    }
    break;
  case CPub_set::e_Book:
    for (auto pCitBook : arg0.SetBook()) {
        x_BasicCleanupCitBook(*pCitBook);
    }
    break;
  case CPub_set::e_Journal:
    for (auto pCitJournal : arg0.SetJournal()) {
        x_BasicCleanupCitJournal(*pCitJournal);
    }
    break;
  case CPub_set::e_Medline:
    for (auto pMedlineEntry : arg0.SetMedline()) {
        x_BasicCleanupMedlineEntry(*pMedlineEntry);
    }
    break;
  case CPub_set::e_Patent:
    for (auto pPatent : arg0.SetPatent()) {
        x_BasicCleanupCitPat(*pPatent);
    }
    break;
  case CPub_set::e_Proc:
    for (auto pProc : arg0.SetProc()) {
        x_BasicCleanupCitProc(*pProc);
    }
    break;
  case CPub_set::e_Pub:
    {
        const bool isSeqFeatCitPub = true;
        for (auto pPub : arg0.SetPub()) {
            x_BasicCleanupPub(*pPub, isSeqFeatCitPub);
            m_NewCleanup.x_RememberSeqFeatCitPubs(*pPub);
        }
    }
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_cit_cit_ETC


void CAutogeneratedCleanup:: x_BasicCleanupSeqFeat_comment( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_DecodeXMLMarkChanged( arg0 );
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
  m_NewCleanup.x_FixUpEllipsis( arg0 );
} // end of  x_BasicCleanupSeqFeat_comment


template< typename Tcontainer_ncbi_cref_cdbtag_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_dbxref_ETC( Tcontainer_ncbi_cref_cdbtag_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cdbtag_, iter, arg0 ) {
    m_NewCleanup.DbtagBC(**iter);
  }
} // end of x_BasicCleanupSeqFeat_dbxref_ETC


template< typename Tcontainer_std_string_ >
void CAutogeneratedCleanup::x_BasicCleanupOrgRefMod( Tcontainer_std_string_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_std_string_, iter, arg0 ) {
    m_NewCleanup.OrgrefModBC(*iter);
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_mod_ETC


template< typename Tcontainer_ncbi_cref_corgmod_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_orgname_orgname_mod_ETC( Tcontainer_ncbi_cref_corgmod_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_corgmod_, iter, arg0 ) {
    auto& orgMod = **iter;
    CLEAN_AND_COMPRESS_STRING_MEMBER(orgMod, Attrib );
    CLEAN_AND_COMPRESS_STRING_MEMBER_JUNK(orgMod, Subname );
     m_NewCleanup.x_OrgModBC(orgMod);
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_orgname_orgname_mod_ETC

void CAutogeneratedCleanup::x_BasicCleanupOrgNameName_hybrid_hybrid_E( COrgName & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_orgname_E1798_ETC( arg0 );
} // end of x_BasicCleanupOrgNameName_hybrid_hybrid_E

template< typename Tcontainer_ncbi_cref_corgname_ >
void CAutogeneratedCleanup::x_BasicCleanupOrgNameName_hybrid_hybrid( Tcontainer_ncbi_cref_corgname_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_corgname_, iter, arg0 ) {
    x_BasicCleanupOrgNameName_hybrid_hybrid_E( **iter );
  }
} // end of x_BasicCleanupOrgNameName_hybrid_hybrid

void CAutogeneratedCleanup::x_BasicCleanupOrgNameName_hybrid( CMultiOrgName & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupOrgNameName_hybrid_hybrid( arg0.Set() );
  }
} // end of x_BasicCleanupOrgNameName_hybrid

void CAutogeneratedCleanup::x_BasicCleanupOrgNameName( COrgName::C_Name & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case COrgName::C_Name::e_Hybrid:
    x_BasicCleanupOrgNameName_hybrid( arg0.SetHybrid() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupOrgNameName

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_orgname_E1798_ETC( COrgName & arg0 )
{ // type Sequence
  CLEAN_STRING_MEMBER( arg0, Attrib );
  CLEAN_STRING_MEMBER( arg0, Div );
  CLEAN_STRING_MEMBER( arg0, Lineage );
  if( arg0.IsSetMod() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_orgname_orgname_mod_ETC( arg0.SetMod() );
  }
  if( arg0.IsSetName() ) {
    x_BasicCleanupOrgNameName( arg0.SetName() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_orgname_E1798_ETC
/*
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_hybrid_E_ETC( COrgName & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_orgname_E1798_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_hybrid_E_ETC

template< typename Tcontainer_ncbi_cref_corgname_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_hybrid_ETC( Tcontainer_ncbi_cref_corgname_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_corgname_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_hybrid_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_hybrid_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_ETC( CMultiOrgName & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_hybrid_ETC( arg0.Set() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_ETC( COrgName::C_Name & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case COrgName::C_Name::e_Hybrid:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_hybrid_ETC( arg0.SetHybrid() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_orgname_orgname_name_ETC
*/
void CAutogeneratedCleanup::x_BasicCleanupSeqFeatDataOrgName(COrgName & arg0, bool cleanup_parent_biosource )
{ // type Sequence
  CLEAN_STRING_MEMBER( arg0, Attrib );
  CLEAN_STRING_MEMBER( arg0, Div );
  CLEAN_STRING_MEMBER( arg0, Lineage );

  if (cleanup_parent_biosource && m_pCurrentBioSource) {
    m_NewCleanup.x_CleanupOrgModAndSubSourceOther( arg0, *m_pCurrentBioSource );
  }

  if( arg0.IsSetMod() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org_orgname_orgname_mod_ETC( arg0.SetMod() );
  }
  if( arg0.IsSetName() ) {
    x_BasicCleanupOrgNameName( arg0.SetName() );
  }
} // end of x_BasicCleanupSeqFeatDataOrgName_orgname1746

/*
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_biosrc_biosrc_org( COrg_ref & arg0, bool cleanup_parent_biosource)
{ // type Sequence
  const bool cleanup_parent_biosource = true;
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Common );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Taxname );
  m_NewCleanup.OrgrefBC( arg0 );
  m_NewCleanup.x_GBQualToOrgRef( arg0, *m_pCurrentSeqFeat );
  if( arg0.IsSetCommon() ) {
    m_NewCleanup.x_TrimInternalSemicolonsMarkChanged( arg0.SetCommon() );
  }
  if( arg0.IsSetDb() ) {
    x_BasicCleanupSeqFeat_dbxref_ETC( arg0.SetDb() );
  }
  if( arg0.IsSetMod() ) {
    x_BasicCleanupOrgRefMod( arg0.SetMod() );
  }
  if( arg0.IsSetOrgname() ) {
    x_BasicCleanupSeqFeatDataOrgName( arg0.SetOrgname(), cleanup_parent_biosource);
  }
  CLEAN_STRING_LIST( arg0, Syn );
  m_NewCleanup.x_PostOrgRef( arg0 );
} // end of x_BasicCleanupSeqFeat_data_data_biosrc_biosrc_org_org
*/

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_pcr_primers_ETC( CPCRReactionSet & arg0 )
{ // type Reference
  m_NewCleanup.PCRReactionSetBC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_pcr_primers_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_source_source_ETC( CSubSource & arg0 )
{ // type Sequence
  m_NewCleanup.x_SubSourceBC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_source_source_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_source_ETC( CSubSource & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_source_source_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_source_ETC

template< typename Tcontainer_ncbi_cref_csubsource_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_subtype_ETC( Tcontainer_ncbi_cref_csubsource_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_csubsource_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_source_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_subtype_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_biosrc_biosrc( CBioSource & arg0 )
{ // type Sequence
  m_pCurrentBioSource = &arg0;

  m_NewCleanup.BiosourceBC( arg0 );
  if( arg0.IsSetOrg() ) {
    const bool cleanup_parent_biosource = true;
    x_BasicCleanupOrgRef( arg0.SetOrg(), cleanup_parent_biosource );
  }
  if( arg0.IsSetPcr_primers() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_pcr_primers_ETC( arg0.SetPcr_primers() );
  }
  if( arg0.IsSetSubtype() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_subtype_ETC( arg0.SetSubtype() );
  }
  m_NewCleanup.BiosourceFeatBC( arg0, *m_pCurrentSeqFeat );
  m_NewCleanup.x_PostBiosource( arg0 );
  m_NewCleanup.x_ModernizePCRPrimers( arg0 );

  m_pCurrentBioSource = nullptr;
} // end of x_BasicCleanupSeqFeat_data_data_biosrc_biosrc

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_biosrc( CBioSource & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_data_data_biosrc_biosrc( arg0 );
} // end of x_BasicCleanupSeqFeat_data_data_biosrc


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_E_E_ETC( CCode_break & arg0 )
{ // type Sequence
  if( arg0.IsSetLoc() ) {
    x_BasicCleanupSeqLoc( arg0.SetLoc() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_E_E_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_E_ETC( CCode_break & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_E_E_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_E_ETC

template< typename Tcontainer_ncbi_cref_ccode_break_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_ETC( Tcontainer_ncbi_cref_ccode_break_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_ccode_break_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_cdregion_cdregion( CCdregion & arg0 )
{ // type Sequence
  m_NewCleanup.CdregionFeatBC( arg0, *m_pCurrentSeqFeat );
  if( arg0.IsSetCode_break() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_ETC( arg0.SetCode_break() );
  }
} // end of x_BasicCleanupSeqFeat_data_data_cdregion_cdregion

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_cdregion( CCdregion & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_data_data_cdregion_cdregion( arg0 );
} // end of x_BasicCleanupSeqFeat_data_data_cdregion

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_E_E_ETC( CClone_seq & arg0 )
{ // type Sequence
  if( arg0.IsSetLocation() ) {
    x_BasicCleanupSeqLoc( arg0.SetLocation() );
  }
  if( arg0.IsSetSeq() ) {
    x_BasicCleanupSeqLoc( arg0.SetSeq() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_E_E_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_E_ETC( CClone_seq & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_E_E_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_E_ETC

template< typename Tcontainer_ncbi_cref_cclone_seq_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_ETC( Tcontainer_ncbi_cref_cclone_seq_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cclone_seq_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_ETC( CClone_seq_set & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_clone_seq_ETC( arg0.Set() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_ETC( CClone_ref & arg0 )
{ // type Sequence
  if( arg0.IsSetClone_seq() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_clone_seq_ETC( arg0.SetClone_seq() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_ETC( CClone_ref & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_clone_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_desc_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_CompressStringSpacesMarkChanged( arg0 );
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_desc_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_locus_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_DecodeXMLMarkChanged( arg0 );
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
  m_NewCleanup.x_TrimInternalSemicolonsMarkChanged( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_locus_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_syn_E_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_DecodeXMLMarkChanged( arg0 );
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_syn_E_ETC

template< typename Tcontainer_std_string_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_syn_ETC( Tcontainer_std_string_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_std_string_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_syn_E_ETC( *iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_syn_ETC

void CAutogeneratedCleanup::x_BasicCleanupGeneRef( CGene_ref & arg0, bool cleanup_parent_feat)
{ // type Sequence
  CLEAN_STRING_MEMBER( arg0, Allele );
  CLEAN_STRING_MEMBER( arg0, Desc );
  CLEAN_STRING_MEMBER( arg0, Locus );
  CLEAN_STRING_MEMBER( arg0, Locus_tag );
  CLEAN_STRING_MEMBER( arg0, Maploc );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Locus );
  if (cleanup_parent_feat && m_pCurrentSeqFeat) {
    m_NewCleanup.GeneFeatBC( arg0, *m_pCurrentSeqFeat );
  }
  if( arg0.IsSetAllele() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetAllele() );
  }
  if( arg0.IsSetDesc() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_desc_ETC( arg0.SetDesc() );
  }
  if( arg0.IsSetLocus() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_locus_ETC( arg0.SetLocus() );
  }
  if( arg0.IsSetLocus_tag() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetLocus_tag() );
  }
  if( arg0.IsSetMaploc() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetMaploc() );
  }
  if( arg0.IsSetSyn() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_syn_ETC( arg0.SetSyn() );
  }
  CLEAN_STRING_LIST( arg0, Syn );
  m_NewCleanup.GenerefBC( arg0 );
} // end of x_BasicCleanupGeneRef_gene


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_imp_imp_ETC( CImp_feat & arg0 )
{ // type Sequence
  CLEAN_STRING_MEMBER( arg0, Descr );
  CLEAN_STRING_MEMBER( arg0, Key );
  CLEAN_STRING_MEMBER( arg0, Loc );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_imp_imp_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_imp_ETC( CImp_feat & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_imp_imp_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_imp_ETC


void CAutogeneratedCleanup::x_BasicCleanupNumRef( CNum_ref & arg0 )
{ // type Sequence
  if( arg0.IsSetAligns() ) {
    x_BasicCleanupSeqAlign( arg0.SetAligns() );
  }
}

void CAutogeneratedCleanup::x_BasicCleanupNumbering( CNumbering & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CNumbering::e_Ref:
    x_BasicCleanupNumRef( arg0.SetRef() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_num_num_ETC



void CAutogeneratedCleanup::x_BasicCleanupOrgRef( COrg_ref & arg0, bool cleanup_parent_biosource)
{ // type Sequence
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Common );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Taxname );
  m_NewCleanup.OrgrefBC( arg0 );
  if (m_pCurrentSeqFeat) {
      m_NewCleanup.x_GBQualToOrgRef( arg0, *m_pCurrentSeqFeat );
  }
  if( arg0.IsSetCommon() ) {
    m_NewCleanup.x_TrimInternalSemicolonsMarkChanged( arg0.SetCommon() );
  }
  if( arg0.IsSetDb() ) {
    x_BasicCleanupSeqFeat_dbxref_ETC( arg0.SetDb() );
  }
  if( arg0.IsSetMod() ) {
    x_BasicCleanupOrgRefMod( arg0.SetMod() );
  }
  if( arg0.IsSetOrgname() ) {
    x_BasicCleanupSeqFeatDataOrgName( arg0.SetOrgname(), cleanup_parent_biosource );
  }
  CLEAN_STRING_LIST( arg0, Syn );
  m_NewCleanup.x_PostOrgRef( arg0 );
} // end of x_BasicCleanupOrgRef


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_activity_E_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.ProtActivityBC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_activity_E_ETC

template< typename Tcontainer_std_string_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_activity_ETC( Tcontainer_std_string_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_std_string_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_activity_E_ETC( *iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_activity_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_desc_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_DecodeXMLMarkChanged( arg0 );
  m_NewCleanup.x_TrimInternalSemicolonsMarkChanged( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_desc_ETC

template< typename Tcontainer_std_string_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_ec_ETC( Tcontainer_std_string_ & arg0 )
{ // type UniSequence
  m_NewCleanup.x_CleanupECNumberList( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_ec_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_name_E_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_DecodeXMLMarkChanged( arg0 );
  m_NewCleanup.x_CompressStringSpacesMarkChanged( arg0 );
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
  m_NewCleanup.x_RemoveFlankingQuotes( arg0 );
  m_NewCleanup.ProtNameBC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_name_E_ETC

template< typename Tcontainer_std_string_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_name_ETC( Tcontainer_std_string_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_std_string_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_name_E_ETC( *iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_name_ETC

void CAutogeneratedCleanup::x_BasicCleanupProtRef( CProt_ref & arg0, bool cleanup_parent_feat)
{ // type Sequence

  if (cleanup_parent_feat && m_pCurrentSeqFeat) {
    m_NewCleanup.ProtFeatfBC( arg0, *m_pCurrentSeqFeat );
  }
  m_NewCleanup.ProtrefBC( arg0 );
  if( arg0.IsSetActivity() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_activity_ETC( arg0.SetActivity() );
  }
  if( arg0.IsSetDesc() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_desc_ETC( arg0.SetDesc() );
  }
  if( arg0.IsSetEc() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_ec_ETC( arg0.SetEc() );
  }
  if( arg0.IsSetName() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_name_ETC( arg0.SetName() );
  }
  CLEAN_STRING_LIST( arg0, Name );
  if (cleanup_parent_feat) {
    m_NewCleanup.PostProtFeatfBC( arg0 );
  }
} // end of x_BasicCleanupSeqFeat_data_data_prot_prot



void CAutogeneratedCleanup::x_BasicCleanupPubEquiv( CPub_equiv & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    for (auto pPub : arg0.Set()) {
        x_BasicCleanupPub(*pPub);
    }
  }
} // end of x_BasicCleanupPubEquiv

void CAutogeneratedCleanup::x_BasicCleanupPub( CPub & arg0, bool isSeqFeatCitPub)
{ // type Choice
  m_NewCleanup.x_RememberPubOldLabel( arg0 );
  switch( arg0.Which() ) {
  case CPub::e_Article:
    x_BasicCleanupCitArt( arg0.SetArticle() );
    break;
  case CPub::e_Book:
    x_BasicCleanupCitBook( arg0.SetBook() );
    break;
  case CPub::e_Equiv:
    x_BasicCleanupPubEquiv( arg0.SetEquiv() );
    break;
  case CPub::e_Gen:
    x_BasicCleanupCitGen( arg0.SetGen() );
    break;
  case CPub::e_Journal:
    x_BasicCleanupCitJournal( arg0.SetJournal() );
    break;
  case CPub::e_Man:
    x_BasicCleanupCitLet( arg0.SetMan() );
    break;
  case CPub::e_Medline:
    x_BasicCleanupMedlineEntry( arg0.SetMedline() );
    break;
  case CPub::e_Muid:
    if (m_pCurrentSeqFeat && isSeqFeatCitPub) {
        m_NewCleanup.x_RememberMuidThatMightBeConvertibleToPmid(arg0);
    }
    break;
  case CPub::e_Patent:
    x_BasicCleanupCitPat( arg0.SetPatent() );
    break;
  case CPub::e_Proc:
    x_BasicCleanupCitProc( arg0.SetProc() );
    break;
  case CPub::e_Sub:
    x_BasicCleanupCitSub( arg0.SetSub() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_pub_E1806_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_pub_ETC( CPubdesc & arg0 )
{ // type Sequence
  if( arg0.IsSetComment() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetComment() );
  }
  if( arg0.IsSetNum() ) {
    x_BasicCleanupNumbering( arg0.SetNum() );
  }
  if( arg0.IsSetPub() ) {
    x_BasicCleanupPubEquiv( arg0.SetPub() );
    m_NewCleanup.x_NotePubdescOrAnnotPubs( arg0.SetPub() );
  }
  m_NewCleanup.PubdescBC( arg0 );
} // end of x_BasicCleanupSeqFeat_data_data_pub_pub_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_region_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_CompressStringSpacesMarkChanged( arg0 );
  m_NewCleanup.x_CleanupStringMarkChanged( arg0 );
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
  m_NewCleanup.x_TrimInternalSemicolonsMarkChanged( arg0 );
} // end of x_BasicCleanupSeqFeat_data_data_region_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_product_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
  m_NewCleanup.x_RemoveFlankingQuotes( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_product_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_E_E_ETC( CRNA_qual & arg0 )
{ // type Sequence
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Qual );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Val );
  if( arg0.IsSetQual() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetQual() );
  }
  if( arg0.IsSetVal() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetVal() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_E_E_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_E_ETC( CRNA_qual & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_E_E_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_E_ETC

template< typename Tcontainer_ncbi_cref_crna_qual_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_ETC( Tcontainer_ncbi_cref_crna_qual_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_crna_qual_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_ETC( CRNA_qual_set & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_quals_ETC( arg0.Set() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_ETC( CRNA_gen & arg0 )
{ // type Sequence
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Class );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Product );
  if( arg0.IsSetClass() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetClass() );
  }
  if( arg0.IsSetProduct() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_product_ETC( arg0.SetProduct() );
  }
  if( arg0.IsSetQuals() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_quals_ETC( arg0.SetQuals() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_ETC( CRNA_gen & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_gen_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_name_ETC( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_DecodeXMLMarkChanged( arg0 );
  m_NewCleanup.x_CompressStringSpacesMarkChanged( arg0 );
  m_NewCleanup.x_CleanupStringMarkChanged( arg0 );
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
  m_NewCleanup.x_RemoveFlankingQuotes( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_name_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_tRNA_tRNA_ETC( CTrna_ext & arg0 )
{ // type Sequence
  if( arg0.IsSetAnticodon() ) {
    x_BasicCleanupSeqLoc( arg0.SetAnticodon() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_tRNA_tRNA_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_tRNA_ETC( CTrna_ext & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_tRNA_tRNA_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_tRNA_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_ETC( CRNA_ref::C_Ext & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CRNA_ref::C_Ext::e_Gen:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_gen_ETC( arg0.SetGen() );
    break;
  case CRNA_ref::C_Ext::e_Name:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_name_ETC( arg0.SetName() );
    break;
  case CRNA_ref::C_Ext::e_TRNA:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_tRNA_ETC( arg0.SetTRNA() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_rna( CRNA_ref & arg0 )
{ // type Sequence
  if( arg0.IsSetExt() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_ETC( arg0.SetExt() );
  }
  m_NewCleanup.RnaFeatBC( arg0, *m_pCurrentSeqFeat );
  m_NewCleanup.RnarefBC( arg0 );
} // end of x_BasicCleanupSeqFeat_data_data_rna_rna


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data_data_site( CSeqFeatData::ESite & arg0 )
{ // type Enum
  m_NewCleanup.SiteFeatBC( arg0, *m_pCurrentSeqFeat );
} // end of x_BasicCleanupSeqFeat_data_data_site
/*
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_ETC( CGene_ref & arg0 )
{ // type Sequence
  CLEAN_STRING_MEMBER( arg0, Allele );
  CLEAN_STRING_MEMBER( arg0, Desc );
  CLEAN_STRING_MEMBER( arg0, Locus );
  CLEAN_STRING_MEMBER( arg0, Locus_tag );
  CLEAN_STRING_MEMBER( arg0, Maploc );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Locus );
  if( arg0.IsSetAllele() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetAllele() );
  }
  if( arg0.IsSetDesc() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_desc_ETC( arg0.SetDesc() );
  }
  if( arg0.IsSetLocus() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_locus_ETC( arg0.SetLocus() );
  }
  if( arg0.IsSetLocus_tag() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetLocus_tag() );
  }
  if( arg0.IsSetMaploc() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetMaploc() );
  }
  if( arg0.IsSetSyn() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_syn_ETC( arg0.SetSyn() );
  }
  CLEAN_STRING_LIST( arg0, Syn );
  m_NewCleanup.GenerefBC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_E_E_ETC

template< typename Tcontainer_ncbi_cref_cgene_ref_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_ETC( Tcontainer_ncbi_cref_cgene_ref_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cgene_ref_, iter, arg0 ) {
    x_BasicCleanupGeneRef( **iter, false);
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_gene_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_ETC( CProt_ref & arg0 )
{ // type Sequence
  m_NewCleanup.ProtrefBC( arg0 );
  if( arg0.IsSetActivity() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_activity_ETC( arg0.SetActivity() );
  }
  if( arg0.IsSetDesc() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_desc_ETC( arg0.SetDesc() );
  }
  if( arg0.IsSetEc() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_ec_ETC( arg0.SetEc() );
  }
  if( arg0.IsSetName() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_name_ETC( arg0.SetName() );
  }
  CLEAN_STRING_LIST( arg0, Name );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_protein_E_E_ETC

*/

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_ETC( COrg_ref & arg0 )
{ // type Sequence
  bool cleanup_parent_biosource = false;
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Common );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Taxname );
  m_NewCleanup.OrgrefBC( arg0 );
  if( arg0.IsSetCommon() ) {
    m_NewCleanup.x_TrimInternalSemicolonsMarkChanged( arg0.SetCommon() );
  }
  if( arg0.IsSetDb() ) {
    x_BasicCleanupSeqFeat_dbxref_ETC( arg0.SetDb() );
  }
  if( arg0.IsSetMod() ) {
    x_BasicCleanupOrgRefMod( arg0.SetMod() );
  }
  if( arg0.IsSetOrgname() ) {
    x_BasicCleanupSeqFeatDataOrgName( arg0.SetOrgname(), cleanup_parent_biosource );
  }
  CLEAN_STRING_LIST( arg0, Syn );
  m_NewCleanup.x_PostOrgRef( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_txorg_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_ETC( CTxinit & arg0 )
{ // type Sequence
  if( arg0.IsSetGene() ) {
    for (auto pGeneRef : arg0.SetGene()) {
        x_BasicCleanupGeneRef(*pGeneRef, false);
    }
  }
  if( arg0.IsSetProtein() ) {
      for (auto pProtRef : arg0.SetProtein()) {
        x_BasicCleanupProtRef(*pProtRef, false);
      }
  }
  if( arg0.IsSetTxorg() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_ETC( arg0.SetTxorg() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_ETC( CTxinit & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_ext_ext1769_ETC( CUser_object & arg0 )
{ // type Sequence
  m_NewCleanup.UserObjectBC( arg0 );
} // end of x_BasicCleanupSeqFeat_ext_ext1769_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_ext_ETC( CUser_object & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_ext_ext1769_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_ext_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence_E_variation( CVariation_ref & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation1805_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence_E_variation

template< typename Tcvariation_ref_container_ncbi_cref_c_e_consequence_c_e_consequence >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence_E( Tcvariation_ref_container_ncbi_cref_c_e_consequence_c_e_consequence & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case Tcvariation_ref_container_ncbi_cref_c_e_consequence_c_e_consequence::e_Variation:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence_E_variation( arg0.SetVariation() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence_E

template< typename Tcontainer_ncbi_cref_c_e_consequence_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence( Tcontainer_ncbi_cref_c_e_consequence_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_c_e_consequence_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence_E( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_E_seq_ETC( CDelta_item::C_Seq & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CDelta_item::C_Seq::e_Loc:
    x_BasicCleanupSeqLoc( arg0.SetLoc() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_E_seq_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_E_ETC( CDelta_item & arg0 )
{ // type Sequence
  if( arg0.IsSetSeq() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_E_seq_ETC( arg0.SetSeq() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_E_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_ETC( CDelta_item & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_E_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_ETC

template< typename Tcontainer_ncbi_cref_cdelta_item_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_ETC( Tcontainer_ncbi_cref_cdelta_item_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cdelta_item_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_ETC( CVariation_inst & arg0 )
{ // type Sequence
  if( arg0.IsSetDelta() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_delta_ETC( arg0.SetDelta() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_ETC( CVariation_inst & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_instance_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_ETC

template< typename Tcvariation_ref_container_ncbi_cref_c_e_somatic_origin_c_e_somatic_origin >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_ETC( Tcvariation_ref_container_ncbi_cref_c_e_somatic_origin_c_e_somatic_origin & arg0 )
{ // type Sequence
  if( arg0.IsSetSource() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_source_ETC( arg0.SetSource() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_ETC

template< typename Tcontainer_ncbi_cref_c_e_somatic_origin_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_ETC( Tcontainer_ncbi_cref_c_e_somatic_origin_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_c_e_somatic_origin_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_E1804_ETC( CVariation_ref & arg0 )
{ // type Sequence
  if( arg0.IsSetConsequence() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence( arg0.SetConsequence() );
  }
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data( arg0.SetData() );
  }
  if( arg0.IsSetSomatic_origin() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_ETC( arg0.SetSomatic_origin() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_E1804_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set_variations_E( CVariation_ref & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_E1804_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set_variations_E

template< typename Tcontainer_ncbi_cref_cvariation_ref_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set_variations( Tcontainer_ncbi_cref_cvariation_ref_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cvariation_ref_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set_variations_E( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set_variations

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set( CVariation_ref::C_Data::C_Set & arg0 )
{ // type Sequence
  if( arg0.IsSetVariations() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set_variations( arg0.SetVariations() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data( CVariation_ref::C_Data & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CVariation_ref::C_Data::e_Instance:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_instance_ETC( arg0.SetInstance() );
    break;
  case CVariation_ref::C_Data::e_Set:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data_set( arg0.SetSet() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation1805_ETC( CVariation_ref & arg0 )
{ // type Sequence
  if( arg0.IsSetConsequence() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_consequence( arg0.SetConsequence() );
  }
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_data( arg0.SetData() );
  }
  if( arg0.IsSetSomatic_origin() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_somatic_origin_ETC( arg0.SetSomatic_origin() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation1805_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_ETC( CVariation_ref & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation1805_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_data( CSeqFeatData & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeqFeatData::e_Biosrc:
    x_BasicCleanupSeqFeat_data_data_biosrc( arg0.SetBiosrc() );
    break;
  case CSeqFeatData::e_Cdregion:
    x_BasicCleanupSeqFeat_data_data_cdregion( arg0.SetCdregion() );
    break;
  case CSeqFeatData::e_Clone:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_ETC( arg0.SetClone() );
    break;
  case CSeqFeatData::e_Gene:
    {
        const bool clean_parent_feat = true;
        x_BasicCleanupGeneRef( arg0.SetGene(), clean_parent_feat);
    }
    break;
  case CSeqFeatData::e_Imp:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_imp_ETC( arg0.SetImp() );
    break;
  case CSeqFeatData::e_Num:
    x_BasicCleanupNumbering( arg0.SetNum() );
    break;
  case CSeqFeatData::e_Org:
    {
      bool inBiosource = false;
      x_BasicCleanupOrgRef( arg0.SetOrg(), inBiosource);
    }
    break;
  case CSeqFeatData::e_Prot:
    x_BasicCleanupProtRef( arg0.SetProt(), true);
    break;
  case CSeqFeatData::e_Pub:
    x_BasicCleanupSeqFeat_data_data_pub_ETC( arg0.SetPub() );
    break;
  case CSeqFeatData::e_Region:
    x_BasicCleanupSeqFeat_data_data_region_ETC( arg0.SetRegion() );
    break;
  case CSeqFeatData::e_Rna:
    x_BasicCleanupSeqFeat_data_data_rna( arg0.SetRna() );
    break;
  case CSeqFeatData::e_Seq:
    x_BasicCleanupSeqLoc( arg0.SetSeq() );
    break;
  case CSeqFeatData::e_Site:
    x_BasicCleanupSeqFeat_data_data_site( arg0.SetSite() );
    break;
  case CSeqFeatData::e_Txinit:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_ETC( arg0.SetTxinit() );
    break;
  case CSeqFeatData::e_User:
    x_BasicCleanupSeqFeat_ext_ETC( arg0.SetUser() );
    break;
  case CSeqFeatData::e_Variation:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_ETC( arg0.SetVariation() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_data_data


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_location_location_equiv_ETC( CSeq_loc_equiv & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupSeqLocs( arg0.Set() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_location_location_equiv_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_location_location1767_ETC( CSeq_loc & arg0 )
{ // type Choice
  m_NewCleanup.SeqLocBC( arg0 );
  m_NewCleanup.ConvertSeqLocWholeToInt( arg0 );
  switch( arg0.Which() ) {
  case CSeq_loc::e_Bond:
    x_BasicCleanupSeqBond(arg0.SetBond());
    break;
  case CSeq_loc::e_Empty:
    x_BasicCleanupSeqId( arg0.SetEmpty() );
    break;
  case CSeq_loc::e_Equiv:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_variation_location_location_equiv_ETC( arg0.SetEquiv() );
    break;
  case CSeq_loc::e_Int:
    x_BasicCleanupSeqInt( arg0.SetInt() );
    break;
  case CSeq_loc::e_Mix:
    x_BasicCleanupSeqLocMix( arg0.SetMix() );
    break;
  case CSeq_loc::e_Packed_int:
    x_BasicCleanupPackedSeqInt(arg0.SetPacked_int());
    break;
  case CSeq_loc::e_Packed_pnt:
    x_BasicCleanupPackedPoint(arg0.SetPacked_pnt());
    break;
  case CSeq_loc::e_Pnt:
    x_BasicCleanupSeqPoint(arg0.SetPnt());
    break;
  case CSeq_loc::e_Whole:
    x_BasicCleanupSeqId(arg0.SetWhole());
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_location_location1767_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_location_ETC( CSeq_loc & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_location_location1767_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_location_ETC

template< typename Tcontainer_ncbi_cref_cgb_qual_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_qual_ETC( Tcontainer_ncbi_cref_cgb_qual_ & arg0 )
{ // type UniSequence
  m_NewCleanup.x_ExpandCombinedQuals( arg0 );
} // end of x_BasicCleanupSeqFeat_qual_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_support_support_inference_E_E_basis_basis_ETC( CEvidenceBasis & arg0 )
{ // type Sequence
  if( arg0.IsSetAccessions() ) {
    x_BasicCleanupSeqIds( arg0.SetAccessions() );
  }
} // end of x_BasicCleanupSeqFeat_support_support_inference_E_E_basis_basis_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_support_support_inference_E_E_basis_ETC( CEvidenceBasis & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_support_support_inference_E_E_basis_basis_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_support_support_inference_E_E_basis_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_support_support_inference_E_E_ETC( CInferenceSupport & arg0 )
{ // type Sequence
  if( arg0.IsSetBasis() ) {
    x_BasicCleanupSeqFeat_support_support_inference_E_E_basis_ETC( arg0.SetBasis() );
  }
} // end of x_BasicCleanupSeqFeat_support_support_inference_E_E_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_support_support_inference_E_ETC( CInferenceSupport & arg0 )
{ // type Reference
    x_BasicCleanupSeqFeat_support_support_inference_E_E_ETC( arg0 );
} // end of x_BasicCleanupSeqFeat_support_support_inference_E_ETC

template< typename Tcontainer_ncbi_cref_cinferencesupport_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_support_support_inference_ETC( Tcontainer_ncbi_cref_cinferencesupport_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cinferencesupport_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_support_support_inference_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_support_support_inference_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_protein_E_ETC( CModelEvidenceItem & arg0 )
{ // type Sequence
  if( arg0.IsSetId() ) {
    x_BasicCleanupSeqId( arg0.SetId() );
  }
} // end of x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_protein_E_E_ETC


template< typename Tcontainer_ncbi_cref_cmodelevidenceitem_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_protein_ETC( Tcontainer_ncbi_cref_cmodelevidenceitem_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cmodelevidenceitem_, iter, arg0 ) {
    x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_protein_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_protein_ETC

void CAutogeneratedCleanup::x_BasicCleanupModelEvidenceSupport( CModelEvidenceSupport & arg0 )
{ // type Sequence
  if( arg0.IsSetEst() ) {
    x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_protein_ETC( arg0.SetEst() );
  }
  if( arg0.IsSetIdentification() ) {
    x_BasicCleanupSeqId( arg0.SetIdentification() );
  }
  if( arg0.IsSetMrna() ) {
    x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_protein_ETC( arg0.SetMrna() );
  }
  if( arg0.IsSetProtein() ) {
    x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_protein_ETC( arg0.SetProtein() );
  }
} // end of x_BasicCleanupSeqFeat_support_support_model_evidence_E_E_ETC


template< typename Tcontainer_ncbi_cref_cmodelevidencesupport_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_support_support_model_evidence_ETC( Tcontainer_ncbi_cref_cmodelevidencesupport_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cmodelevidencesupport_, iter, arg0 ) {
    x_BasicCleanupModelEvidenceSupport( **iter );
  }
} // end of x_BasicCleanupSeqFeat_support_support_model_evidence_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqFeatSupport( CSeqFeatSupport & arg0 )
{ // type Sequence
  if( arg0.IsSetInference() ) {
    x_BasicCleanupSeqFeat_support_support_inference_ETC( arg0.SetInference() );
  }
  if( arg0.IsSetModel_evidence() ) {
    x_BasicCleanupSeqFeat_support_support_model_evidence_ETC( arg0.SetModel_evidence() );
  }
} // end of x_BasicCleanupSeqFeat_support_support_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org( COrg_ref & arg0 )
{ // type Sequence
  bool cleanup_parent_biosource = true;
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Common );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Taxname );
  m_NewCleanup.OrgrefBC( arg0 );
  if( arg0.IsSetCommon() ) {
    m_NewCleanup.x_TrimInternalSemicolonsMarkChanged( arg0.SetCommon() );
  }
  if( arg0.IsSetDb() ) {
    x_BasicCleanupSeqFeat_dbxref_ETC( arg0.SetDb() );
  }
  if( arg0.IsSetMod() ) {
    x_BasicCleanupOrgRefMod( arg0.SetMod() );
  }
  if( arg0.IsSetOrgname() ) {
    x_BasicCleanupSeqFeatDataOrgName(arg0.SetOrgname(), cleanup_parent_biosource);
  }
  CLEAN_STRING_LIST( arg0, Syn );
  m_NewCleanup.x_PostOrgRef( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org_org


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_ETC( CBioSource & arg0 )
{ // type Sequence
  m_pCurrentBioSource = &arg0;

  m_NewCleanup.BiosourceBC( arg0 );
  if( arg0.IsSetOrg() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_org( arg0.SetOrg() );
  }
  if( arg0.IsSetPcr_primers() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_pcr_primers_ETC( arg0.SetPcr_primers() );
  }
  if( arg0.IsSetSubtype() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_subtype_ETC( arg0.SetSubtype() );
  }
  m_NewCleanup.x_PostBiosource( arg0 );
  m_NewCleanup.x_ModernizePCRPrimers( arg0 );

  m_pCurrentBioSource = nullptr;
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_biosrc_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_ETC( CCdregion & arg0 )
{ // type Sequence
  if( arg0.IsSetCode_break() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_code_break_ETC( arg0.SetCode_break() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_cdregion_ETC



void CAutogeneratedCleanup::x_BasicCleanupSeqFeatXrefPub( CPubdesc & arg0 )
{ // type Sequence
  if( arg0.IsSetComment() ) {
    m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0.SetComment() );
  }
  if( arg0.IsSetNum() ) {
    x_BasicCleanupNumbering( arg0.SetNum() );
  }
  if( arg0.IsSetPub() ) {
    x_BasicCleanupPubEquiv( arg0.SetPub() );
  }
  m_NewCleanup.PubdescBC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_pub_pub_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_ETC( CRNA_ref & arg0 )
{ // type Sequence
  if( arg0.IsSetExt() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ext_ETC( arg0.SetExt() );
  }
  m_NewCleanup.RnarefBC( arg0 );
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_rna_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_E_E_data_ETC( CSeqFeatData & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeqFeatData::e_Biosrc:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_ETC( arg0.SetBiosrc() );
    break;
  case CSeqFeatData::e_Cdregion:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_cdregion_ETC( arg0.SetCdregion() );
    break;
  case CSeqFeatData::e_Clone:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_clone_ETC( arg0.SetClone() );
    break;
  case CSeqFeatData::e_Gene:
    x_BasicCleanupGeneRef( arg0.SetGene(), false);
    break;
  case CSeqFeatData::e_Imp:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_imp_ETC( arg0.SetImp() );
    break;
  case CSeqFeatData::e_Num:
    x_BasicCleanupNumbering( arg0.SetNum() );
    break;
  case CSeqFeatData::e_Org:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_ETC( arg0.SetOrg() );
    break;
  case CSeqFeatData::e_Prot:
    x_BasicCleanupProtRef(arg0.SetProt(), false);
    break;
  case CSeqFeatData::e_Pub:
    x_BasicCleanupSeqFeatXrefPub( arg0.SetPub() );
    break;
  case CSeqFeatData::e_Rna:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_rna_ETC( arg0.SetRna() );
    break;
  case CSeqFeatData::e_Seq:
    x_BasicCleanupSeqLoc( arg0.SetSeq() );
    break;
  case CSeqFeatData::e_Txinit:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_ETC( arg0.SetTxinit() );
    break;
  case CSeqFeatData::e_Variation:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_variation_ETC( arg0.SetVariation() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_data_data_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqFeatXref( CSeqFeatXref & arg0 )
{ // type Sequence
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqFeat_xref_E_E_data_ETC( arg0.SetData() );
  }
} // end of x_BasicCleanupSeqFeat_xref_E_E_ETC


template< typename Tcontainer_ncbi_cref_cseqfeatxref_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqFeat_xref_ETC( Tcontainer_ncbi_cref_cseqfeatxref_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cseqfeatxref_, iter, arg0 ) {
    x_BasicCleanupSeqFeatXref( **iter );
  }
} // end of x_BasicCleanupSeqFeat_xref_ETC

void CAutogeneratedCleanup::BasicCleanupSeqFeat( CSeq_feat & arg0_raw )
{ // type Sequence
  CRef<CSeq_feat> raw_ref( &arg0_raw );
  CSeq_feat_EditHandle efh;

  CRef<CSeq_feat> new_feat;

  try {
    // Try to use an edit handle so we can update the object manager
    efh = CSeq_feat_EditHandle( m_Scope.GetSeq_featHandle( arg0_raw ) );
    new_feat.Reset( new CSeq_feat );
    new_feat->Assign( arg0_raw );
  } catch(...) {
    new_feat.Reset( &arg0_raw );
  }

  CSeq_feat &arg0 = *new_feat;

  m_pCurrentSeqFeat = &arg0;

  CLEAN_STRING_MEMBER( arg0, Comment );
  CLEAN_STRING_MEMBER( arg0, Except_text );
  CLEAN_STRING_MEMBER( arg0, Title );
  CLEAN_AND_COMPRESS_STRING_MEMBER( arg0, Comment );
  m_NewCleanup.ImpFeatBC( arg0 );
  m_NewCleanup.SeqfeatBC( arg0 );
  if( arg0.IsSetCit() ) {
    x_BasicCleanupSeqFeat_cit_ETC( arg0.SetCit() );
  }
  if( arg0.IsSetComment() ) {
     x_BasicCleanupSeqFeat_comment( arg0.SetComment() );
  }
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqFeat_data( arg0.SetData() );
  }
  if( arg0.IsSetDbxref() ) {
    x_BasicCleanupSeqFeat_dbxref_ETC( arg0.SetDbxref() );
  }
  if( arg0.IsSetExt() ) {
    x_BasicCleanupSeqFeat_ext_ETC( arg0.SetExt() );
  }
  if( arg0.IsSetLocation() ) {
    x_BasicCleanupSeqFeat_location_ETC( arg0.SetLocation() );
  }
  if( arg0.IsSetProduct() ) {
    x_BasicCleanupSeqLoc( arg0.SetProduct() );
  }
  if( arg0.IsSetQual() ) {
    x_BasicCleanupSeqFeat_qual_ETC( arg0.SetQual() );
  }
  if( arg0.IsSetSupport() ) {
    x_BasicCleanupSeqFeatSupport( arg0.SetSupport() );
  }
  if( arg0.IsSetTitle() ) {
    m_NewCleanup.x_DecodeXMLMarkChanged( arg0.SetTitle() );
  }
  if( arg0.IsSetXref() ) {
    x_BasicCleanupSeqFeat_xref_ETC( arg0.SetXref() );
  }
  m_NewCleanup.x_PostSeqFeat( arg0 );

  m_pCurrentSeqFeat = nullptr;

  if( efh ) {
    efh.Replace(arg0);
    arg0_raw.Assign( arg0 );
  }

} // end of BasicCleanupSeqFeat


template <typename TSeqFeatContainer>
void CAutogeneratedCleanup::x_BasicCleanupSeqFeats(TSeqFeatContainer& feats)
{
    for (auto pFeat : feats) {
        BasicCleanupSeqFeat(*pFeat);
    }
}


void CAutogeneratedCleanup::x_BasicCleanupSeqGraph( CSeq_graph & arg0 )
{ // type Sequence
  if( arg0.IsSetLoc() ) {
    x_BasicCleanupSeqLoc( arg0.SetLoc() );
  }
} // end of x_BasicCleanupSeqAnnotData_graph_E_E_ETC


template< typename Tcontainer_ncbi_cref_cseq_graph_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotGraph( Tcontainer_ncbi_cref_cseq_graph_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cseq_graph_, iter, arg0 ) {
    x_BasicCleanupSeqGraph(**iter);
  }
} // end of x_BasicCleanupSeqAnnotGraph

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled_int_scaled_data( CSeqTable_multi_data & arg0 )
{ // type Reference
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data1712_ETC( arg0 );
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled_int_scaled_data

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled_int_scaled( CScaled_int_multi_data & arg0 )
{ // type Sequence
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled_int_scaled_data( arg0.SetData() );
  }
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled_int_scaled

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled( CScaled_int_multi_data & arg0 )
{ // type Reference
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled_int_scaled( arg0 );
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled_real_scaled_data( CSeqTable_multi_data & arg0 )
{ // type Reference
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data1712_ETC( arg0 );
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled_real_scaled_data

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled_real_scaled( CScaled_real_multi_data & arg0 )
{ // type Sequence
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled_real_scaled_data( arg0.SetData() );
  }
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled_real_scaled

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled( CScaled_real_multi_data & arg0 )
{ // type Reference
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled_real_scaled( arg0 );
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_int_delta1713_ETC( CSeqTable_multi_data & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeqTable_multi_data::e_Id:
    x_BasicCleanupSeqIds( arg0.SetId() );
    break;
  case CSeqTable_multi_data::e_Int_delta:
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_delta( arg0.SetInt_delta() );
    break;
  case CSeqTable_multi_data::e_Int_scaled:
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled( arg0.SetInt_scaled() );
    break;
  case CSeqTable_multi_data::e_Interval:
    x_BasicCleanupSeqInts( arg0.SetInterval() );
    break;
  case CSeqTable_multi_data::e_Loc:
    x_BasicCleanupSeqLocs( arg0.SetLoc() );
    break;
  case CSeqTable_multi_data::e_Real_scaled:
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled( arg0.SetReal_scaled() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_int_delta1713_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_delta( CSeqTable_multi_data & arg0 )
{ // type Reference
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_int_delta1713_ETC( arg0 );
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_delta

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data1712_ETC( CSeqTable_multi_data & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeqTable_multi_data::e_Id:
    x_BasicCleanupSeqIds( arg0.SetId() );
    break;
  case CSeqTable_multi_data::e_Int_delta:
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_delta( arg0.SetInt_delta() );
    break;
  case CSeqTable_multi_data::e_Int_scaled:
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_int_scaled( arg0.SetInt_scaled() );
    break;
  case CSeqTable_multi_data::e_Interval:
    x_BasicCleanupSeqInts( arg0.SetInterval() );
    break;
  case CSeqTable_multi_data::e_Loc:
    x_BasicCleanupSeqLocs( arg0.SetLoc() );
    break;
  case CSeqTable_multi_data::e_Real_scaled:
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data_real_scaled( arg0.SetReal_scaled() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data1712_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_ETC( CSeqTable_multi_data & arg0 )
{ // type Reference
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_data1712_ETC( arg0 );
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_sparse_other_sparse_other_ETC( CSeqTable_single_data & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeqTable_single_data::e_Id:
    x_BasicCleanupSeqId( arg0.SetId() );
    break;
  case CSeqTable_single_data::e_Interval:
    x_BasicCleanupSeqInt( arg0.SetInterval() );
    break;
  case CSeqTable_single_data::e_Loc:
    x_BasicCleanupSeqLoc( arg0.SetLoc() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_sparse_other_sparse_other_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_sparse_other_ETC( CSeqTable_single_data & arg0 )
{ // type Reference
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_sparse_other_sparse_other_ETC( arg0 );
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_sparse_other_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_ETC( CSeqTable_column & arg0 )
{ // type Sequence
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_data_ETC( arg0.SetData() );
  }
  if( arg0.IsSetDefault() ) {
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_sparse_other_ETC( arg0.SetDefault() );
  }
  if( arg0.IsSetSparse_other() ) {
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_sparse_other_ETC( arg0.SetSparse_other() );
  }
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_E_ETC


template< typename Tcontainer_ncbi_cref_cseqtable_column_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_ETC( Tcontainer_ncbi_cref_cseqtable_column_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cseqtable_column_, iter, arg0 ) {
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_E_ETC( **iter );
  }
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqTable( CSeq_table & arg0 )
{ // type Sequence
  if( arg0.IsSetColumns() ) {
    x_BasicCleanupSeqAnnotData_seq_table_seq_table_columns_ETC( arg0.SetColumns() );
  }
} // end of x_BasicCleanupSeqAnnotData_seq_table_seq_table_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqAnnotData( CSeq_annot::C_Data & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeq_annot::C_Data::e_Align:
    x_BasicCleanupSeqAligns( arg0.SetAlign() );
    break;
  case CSeq_annot::C_Data::e_Ftable:
    x_BasicCleanupSeqFeats( arg0.SetFtable() );
    break;
  case CSeq_annot::C_Data::e_Graph:
    x_BasicCleanupSeqAnnotGraph( arg0.SetGraph() );
    break;
  case CSeq_annot::C_Data::e_Ids:
    x_BasicCleanupSeqIds( arg0.SetIds() );
    break;
  case CSeq_annot::C_Data::e_Locs:
    x_BasicCleanupSeqLocs( arg0.SetLocs() );
    break;
  case CSeq_annot::C_Data::e_Seq_table:
    x_BasicCleanupSeqTable( arg0.SetSeq_table() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqAnnotData

void CAutogeneratedCleanup::x_BasicCleanupBioseqSet_annot_E_E_desc_desc_E_E_align_ETC( CAlign_def & arg0 )
{ // type Sequence
  if( arg0.IsSetIds() ) {
    x_BasicCleanupSeqIds( arg0.SetIds() );
  }
} // end of x_BasicCleanupBioseqSet_annot_E_E_desc_desc_E_E_align_align_ETC

void CAutogeneratedCleanup::x_BasicCleanupBioseqSet_annot_E_E_desc_desc_E_ETC( CAnnotdesc & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CAnnotdesc::e_Align:
    x_BasicCleanupBioseqSet_annot_E_E_desc_desc_E_E_align_ETC( arg0.SetAlign() );
    break;
  case CAnnotdesc::e_Create_date:
    x_BasicCleanupDate( arg0.SetCreate_date() );
    break;
  case CAnnotdesc::e_Pub:
    x_BasicCleanupSeqFeatXrefPub( arg0.SetPub() );
    break;
  case CAnnotdesc::e_Region:
    x_BasicCleanupSeqLoc( arg0.SetRegion() );
    break;
  case CAnnotdesc::e_Src:
    x_BasicCleanupSeqId( arg0.SetSrc() );
    break;
  case CAnnotdesc::e_Update_date:
    x_BasicCleanupDate( arg0.SetUpdate_date() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupBioseqSet_annot_E_E_desc_desc_E_E_ETC


template< typename Tcontainer_ncbi_cref_cannotdesc_ >
void CAutogeneratedCleanup::x_BasicCleanupBioseqSet_annot_E_E_desc_desc_ETC( Tcontainer_ncbi_cref_cannotdesc_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cannotdesc_, iter, arg0 ) {
    x_BasicCleanupBioseqSet_annot_E_E_desc_desc_E_ETC( **iter );
  }
} // end of x_BasicCleanupBioseqSet_annot_E_E_desc_desc_ETC

void CAutogeneratedCleanup::x_BasicCleanupBioseqSet_annot_E_E_desc_ETC( CAnnot_descr & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupBioseqSet_annot_E_E_desc_desc_ETC( arg0.Set() );
  }
} // end of x_BasicCleanupBioseqSet_annot_E_E_desc_ETC

void CAutogeneratedCleanup::BasicCleanupSeqAnnot( CSeq_annot & arg0 )
{ // type Sequence
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqAnnotData( arg0.SetData() );
  }
  if( arg0.IsSetDesc() ) {
    x_BasicCleanupBioseqSet_annot_E_E_desc_ETC( arg0.SetDesc() );
  }
} // end of x_BasicCleanupBioseq_annot_E_E


template< typename Tcontainer_ncbi_cref_cseq_annot_ >
void CAutogeneratedCleanup::x_BasicCleanupBioseq_annot( Tcontainer_ncbi_cref_cseq_annot_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cseq_annot_, iter, arg0 ) {
    BasicCleanupSeqAnnot( **iter );
  }
} // end of x_BasicCleanupBioseq_annot

void CAutogeneratedCleanup::x_BasicCleanupDescComment( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_DecodeXMLMarkChanged( arg0 );
  m_NewCleanup.x_CleanupStringJunkMarkChanged( arg0 );
  m_NewCleanup.x_RemoveSpacesBetweenTildesMarkChanged( arg0 );
  m_NewCleanup.X_CommentTildeFixes( arg0 );
} // end of x_BasicCleanupDescComment

void CAutogeneratedCleanup::x_BasicCleanupEMBLBlock( CEMBL_block & arg0 )
{ // type Sequence
  m_NewCleanup.EMBLblockBC( arg0 );
  if( arg0.IsSetCreation_date() ) {
    x_BasicCleanupDate( arg0.SetCreation_date() );
  }
  if( arg0.IsSetUpdate_date() ) {
    x_BasicCleanupDate( arg0.SetUpdate_date() );
  }
} // end of x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_descr_descr_E_E_embl_embl_ETC


void CAutogeneratedCleanup::x_BasicCleanupGBBlock( CGB_block & arg0 )
{ // type Sequence
  m_NewCleanup.GBblockBC( arg0 );
  if( arg0.IsSetEntry_date() ) {
    x_BasicCleanupDate( arg0.SetEntry_date() );
  }
  if( arg0.IsSetOrigin() ) {
    m_NewCleanup.GBblockOriginBC( arg0.SetOrigin() );
  }
} // end of x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_descr_descr_E_E_genbank_genbank_ETC


void CAutogeneratedCleanup::x_BasicCleanupMolInfo( CMolInfo & arg0 )
{ // type Sequence
  m_NewCleanup.MolInfoBC( arg0 );
  m_NewCleanup.x_FixUnsetMolFromBiomol( arg0, *m_LastArg_BasicCleanupBioseq );
} // end of x_BasicCleanupMolInfo_molinfo



void CAutogeneratedCleanup::x_BasicCleanupPDBBlock( CPDB_block & arg0 )
{ // type Sequence
  if( arg0.IsSetDeposition() ) {
    x_BasicCleanupDate( arg0.SetDeposition() );
  }
  if( arg0.IsSetReplace() ) {
    auto& replace = arg0.SetReplace();
    if (replace.IsSetDate()) {
        x_BasicCleanupDate( replace.SetDate() );
    }
  }
} // end of x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_descr_descr_E_E_pdb_pdb_ETC


void CAutogeneratedCleanup::x_BasicCleanupPIRBlock( CPIR_block & arg0 )
{ // type Sequence
  if( arg0.IsSetSeqref() ) {
    x_BasicCleanupSeqIds( arg0.SetSeqref() );
  }
} // end of x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_descr_descr_E_E_pir_pir_ETC


void CAutogeneratedCleanup::x_BasicCleanupDescRegion( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_CleanupStringMarkChanged( arg0 );
  m_NewCleanup.x_ConvertDoubleQuotesMarkChanged( arg0 );
} // end of x_BasicCleanupDescRegion

void CAutogeneratedCleanup::x_BasicCleanupSPBlock( CSP_block & arg0 )
{ // type Sequence
  if( arg0.IsSetAnnotupd() ) {
    x_BasicCleanupDate( arg0.SetAnnotupd() );
  }
  if( arg0.IsSetCreated() ) {
    x_BasicCleanupDate( arg0.SetCreated() );
  }
  if( arg0.IsSetSeqref() ) {
    x_BasicCleanupSeqIds( arg0.SetSeqref() );
  }
  if( arg0.IsSetSequpd() ) {
    x_BasicCleanupDate( arg0.SetSequpd() );
  }
} // end of x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_descr_descr_E_E_sp_sp_ETC


void CAutogeneratedCleanup::x_BasicCleanupDescTitle( std::string & arg0 )
{ // type Primitive
  m_NewCleanup.x_DecodeXMLMarkChanged( arg0 );
  m_NewCleanup.x_CompressStringSpacesMarkChanged( arg0 );
  m_NewCleanup.x_CleanupStringMarkChanged( arg0 );
} // end of x_BasicCleanupDescTitle

void CAutogeneratedCleanup::x_BasicCleanupBioseq_descr_descr_E( CSeqdesc & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeqdesc::e_Comment:
    x_BasicCleanupDescComment( arg0.SetComment() );
    break;
  case CSeqdesc::e_Create_date:
    x_BasicCleanupDate( arg0.SetCreate_date() );
    break;
  case CSeqdesc::e_Embl:
    x_BasicCleanupEMBLBlock( arg0.SetEmbl() );
    break;
  case CSeqdesc::e_Genbank:
    x_BasicCleanupGBBlock( arg0.SetGenbank() );
    break;
  case CSeqdesc::e_Modelev:
    x_BasicCleanupModelEvidenceSupport( arg0.SetModelev() );
    break;
  case CSeqdesc::e_Molinfo:
    x_BasicCleanupMolInfo( arg0.SetMolinfo() );
    break;
  case CSeqdesc::e_Name:
    m_NewCleanup.x_CleanupStringMarkChanged( arg0.SetName() );
    break;
  case CSeqdesc::e_Num:
    x_BasicCleanupNumbering( arg0.SetNum() );
    break;
  case CSeqdesc::e_Org:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_ETC( arg0.SetOrg() );
    break;
  case CSeqdesc::e_Pdb:
    x_BasicCleanupPDBBlock( arg0.SetPdb() );
    break;
  case CSeqdesc::e_Pir:
    x_BasicCleanupPIRBlock( arg0.SetPir() );
    break;
  case CSeqdesc::e_Pub:
    x_BasicCleanupSeqFeat_data_data_pub_ETC( arg0.SetPub() );
    break;
  case CSeqdesc::e_Region:
    x_BasicCleanupDescRegion( arg0.SetRegion() );
    break;
  case CSeqdesc::e_Source:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_ETC( arg0.SetSource() );
    break;
  case CSeqdesc::e_Sp:
    x_BasicCleanupSPBlock( arg0.SetSp() );
    break;
  case CSeqdesc::e_Title:
    x_BasicCleanupDescTitle( arg0.SetTitle() );
    break;
  case CSeqdesc::e_Update_date:
    x_BasicCleanupDate( arg0.SetUpdate_date() );
    break;
  case CSeqdesc::e_User:
    x_BasicCleanupSeqFeat_ext_ETC( arg0.SetUser() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupBioseq_descr_descr_E_E


void CAutogeneratedCleanup::x_BasicCleanupBioseq_descr( CSeq_descr & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    for (auto pDesc : arg0.Set()) {
        x_BasicCleanupBioseq_descr_descr_E( *pDesc);
    }
  }
} // end of x_BasicCleanupBioseq_descr


void CAutogeneratedCleanup::x_BasicCleanupDeltaExt( CDelta_ext & arg0 )
{ // type Reference
  m_NewCleanup.DeltaExtBC( arg0, *m_LastArg_x_BasicCleanupBioseq_inst_inst );
  if( arg0.IsSet() ) {
    for (auto pDeltaSeq : arg0.Set()) {
      if (pDeltaSeq && pDeltaSeq->IsLoc()) {
        x_BasicCleanupSeqLoc(pDeltaSeq->SetLoc());
      }
    }
  }
} // end of x_BasicCleanupDeltaExt


void CAutogeneratedCleanup::x_BasicCleanupBioseq_inst_inst_ext_ext_map( CMap_ext & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupSeqFeats(arg0.Set());
  }
} // end of x_BasicCleanupBioseq_inst_inst_ext_ext_map


void CAutogeneratedCleanup::x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_inst_inst_ext_ext_seg_ETC( CSeg_ext & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    x_BasicCleanupSeqLocs( arg0.Set() );
  }
} // end of x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_inst_inst_ext_ext_seg_ETC

void CAutogeneratedCleanup::x_BasicCleanupSeqExt( CSeq_ext & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeq_ext::e_Delta:
    x_BasicCleanupDeltaExt( arg0.SetDelta() );
    break;
  case CSeq_ext::e_Map:
    x_BasicCleanupBioseq_inst_inst_ext_ext_map( arg0.SetMap() );
    break;
  case CSeq_ext::e_Ref:
    x_BasicCleanupSeqLoc( arg0.SetRef() );
    break;
  case CSeq_ext::e_Seg:
    x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_inst_inst_ext_ext_seg_ETC( arg0.SetSeg() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupBioseq_inst_inst_ext_ext


void CAutogeneratedCleanup::x_BasicCleanupSeqHistDeleted( CSeq_hist::C_Deleted & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeq_hist::C_Deleted::e_Date:
    x_BasicCleanupDate( arg0.SetDate() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqHistDeleted

void CAutogeneratedCleanup::x_BasicCleanupSeqHistRec( CSeq_hist_rec & arg0 )
{ // type Sequence
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate( arg0.SetDate() );
  }
  if( arg0.IsSetIds() ) {
    x_BasicCleanupSeqIds( arg0.SetIds() );
  }
} // end of x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_inst_inst_hist_hist_replaced_by_replaced_by_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqHist( CSeq_hist & arg0 )
{ // type Sequence
  if( arg0.IsSetAssembly() ) {
    x_BasicCleanupSeqAligns( arg0.SetAssembly() );
  }
  if( arg0.IsSetDeleted() ) {
    x_BasicCleanupSeqHistDeleted( arg0.SetDeleted() );
  }
  if( arg0.IsSetReplaced_by() ) {
    x_BasicCleanupSeqHistRec( arg0.SetReplaced_by() );
  }
  if( arg0.IsSetReplaces() ) {
    x_BasicCleanupSeqHistRec( arg0.SetReplaces() );
  }
} // end of x_BasicCleanupBioseqSet_seq_set_E_E_seq_seq_inst_inst_hist_hist_ETC


void CAutogeneratedCleanup::x_BasicCleanupBioseq_inst( CSeq_inst & arg0 )
{ // type Sequence
  m_LastArg_x_BasicCleanupBioseq_inst_inst = &arg0;

  if( arg0.IsSetExt() ) {
    x_BasicCleanupSeqExt( arg0.SetExt() );
  }
  if( arg0.IsSetHist() ) {
    x_BasicCleanupSeqHist( arg0.SetHist() );
  }

  m_LastArg_x_BasicCleanupBioseq_inst_inst = nullptr;
} // end of x_BasicCleanupBioseq_inst_inst


void CAutogeneratedCleanup::BasicCleanupBioseq( CBioseq & arg0 )
{ // type Sequence
  m_LastArg_BasicCleanupBioseq = &arg0;

  m_NewCleanup.ProtSeqBC( arg0 );
  m_NewCleanup.x_RemoveSingleStrand( arg0 );
  if( arg0.IsSetAnnot() ) {
    x_BasicCleanupBioseq_annot( arg0.SetAnnot() );
  }
  if( arg0.IsSetDescr() ) {
    x_BasicCleanupBioseq_descr( arg0.SetDescr() );
  }
  if( arg0.IsSetId() ) {
    x_BasicCleanupSeqIds( arg0.SetId() );
  }
  if( arg0.IsSetInst() ) {
    x_BasicCleanupBioseq_inst( arg0.SetInst() );
  }
  m_NewCleanup.x_AddPartialToProteinTitle( arg0 );
  m_NewCleanup.x_ClearEmptyDescr( arg0 );

  m_LastArg_BasicCleanupBioseq = nullptr;
} // end of BasicCleanupBioseq


template< typename Tcontainer_ncbi_cref_cseq_annot_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqAnnots( Tcontainer_ncbi_cref_cseq_annot_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cseq_annot_, iter, arg0 ) {
    BasicCleanupSeqAnnot( **iter );
  }
} // end of x_BasicCleanupSeqAnnots


void CAutogeneratedCleanup::x_BasicCleanupBioseqSetDesc( CSeqdesc & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeqdesc::e_Comment:
    x_BasicCleanupDescComment( arg0.SetComment() );
    break;
  case CSeqdesc::e_Create_date:
    x_BasicCleanupDate( arg0.SetCreate_date() );
    break;
  case CSeqdesc::e_Embl:
    x_BasicCleanupEMBLBlock( arg0.SetEmbl() );
    break;
  case CSeqdesc::e_Genbank:
    x_BasicCleanupGBBlock( arg0.SetGenbank() );
    break;
  case CSeqdesc::e_Modelev:
    x_BasicCleanupModelEvidenceSupport( arg0.SetModelev() );
    break;
  case CSeqdesc::e_Molinfo:
    m_NewCleanup.MolInfoBC( arg0.SetMolinfo() );
    break;
  case CSeqdesc::e_Name:
    m_NewCleanup.x_CleanupStringMarkChanged( arg0.SetName() );
    break;
  case CSeqdesc::e_Num:
    x_BasicCleanupNumbering( arg0.SetNum() );
    break;
  case CSeqdesc::e_Org:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_txinit_txinit_txorg_ETC( arg0.SetOrg() );
    break;
  case CSeqdesc::e_Pdb:
    x_BasicCleanupPDBBlock( arg0.SetPdb() );
    break;
  case CSeqdesc::e_Pir:
    x_BasicCleanupPIRBlock( arg0.SetPir() );
    break;
  case CSeqdesc::e_Pub:
    x_BasicCleanupSeqFeat_data_data_pub_ETC( arg0.SetPub() );
    break;
  case CSeqdesc::e_Region:
    x_BasicCleanupDescRegion( arg0.SetRegion() );
    break;
  case CSeqdesc::e_Source:
    x_BasicCleanupSeqFeat_xref_E_E_data_data_biosrc_ETC( arg0.SetSource() );
    break;
  case CSeqdesc::e_Sp:
    x_BasicCleanupSPBlock( arg0.SetSp() );
    break;
  case CSeqdesc::e_Title:
    x_BasicCleanupDescTitle( arg0.SetTitle() );
    break;
  case CSeqdesc::e_Update_date:
    x_BasicCleanupDate( arg0.SetUpdate_date() );
    break;
  case CSeqdesc::e_User:
    x_BasicCleanupSeqFeat_ext_ETC( arg0.SetUser() );
    break;
  default:
    break;
  }
} // end of x_BasicCleanupBioseqSet_descr_descr_E_E_ETC


void CAutogeneratedCleanup::x_BasicCleanupBioseqSet_descr_ETC( CSeq_descr & arg0 )
{ // type Reference
  if( arg0.IsSet() ) {
    for (auto pDesc : arg0.Set()) {
        x_BasicCleanupBioseqSetDesc(*pDesc);
    }
  }
} // end of x_BasicCleanupBioseqSet_descr_ETC


void CAutogeneratedCleanup::x_BasicCleanupSeqEntry_set( CBioseq_set & arg0 )
{ // type Sequence
  m_NewCleanup.SeqsetBC( arg0 );
  if( arg0.IsSetAnnot() ) {
    x_BasicCleanupSeqAnnots( arg0.SetAnnot() );
  }
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate( arg0.SetDate() );
  }
  if( arg0.IsSetDescr() ) {
    x_BasicCleanupBioseqSet_descr_ETC( arg0.SetDescr() );
  }
  if( arg0.IsSetSeq_set() ) {
    for (auto pEntry : arg0.SetSeq_set()) {
        BasicCleanupSeqEntry(*pEntry);
    }
  }
  m_NewCleanup.x_ClearEmptyDescr( arg0 );
} // end of x_BasicCleanupSeqEntry_set_set_ETC


void CAutogeneratedCleanup::BasicCleanupSeqEntry( CSeq_entry & arg0 )
{ // type Choice
  m_NewCleanup.EnteringEntry( arg0 );
  m_NewCleanup.x_CopyGBBlockDivToOrgnameDiv( arg0 );
  switch( arg0.Which() ) {
  case CSeq_entry::e_Seq:
    BasicCleanupBioseq( arg0.SetSeq() );
    break;
  case CSeq_entry::e_Set:
    x_BasicCleanupSeqEntry_set( arg0.SetSet() );
    break;
  default:
    break;
  }
  m_NewCleanup.LeavingEntry( arg0 );
} // end of BasicCleanupSeqEntry


void CAutogeneratedCleanup::x_BasicCleanupSeqSubmit_data_annots_E( CSeq_annot & arg0 )
{ // type Sequence
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqAnnotData( arg0.SetData() );
  }
  if( arg0.IsSetDesc() ) {
    x_BasicCleanupBioseqSet_annot_E_E_desc_ETC( arg0.SetDesc() );
  }
} // end of x_BasicCleanupSeqSubmit_data_annots_E_E


template< typename Tcontainer_ncbi_cref_cseq_annot_ >
void CAutogeneratedCleanup::x_BasicCleanupSeqSubmit_data_annots( Tcontainer_ncbi_cref_cseq_annot_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cseq_annot_, iter, arg0 ) {
    x_BasicCleanupSeqSubmit_data_annots_E( **iter );
  }
} // end of x_BasicCleanupSeqSubmit_data_annots


void CAutogeneratedCleanup::x_BasicCleanupSeqSubmit_data( CSeq_submit::C_Data & arg0 )
{ // type Choice
  switch( arg0.Which() ) {
  case CSeq_submit::C_Data::e_Annots:
    x_BasicCleanupSeqSubmit_data_annots( arg0.SetAnnots() );
    break;
  case CSeq_submit::C_Data::e_Delete:
    x_BasicCleanupSeqIds( arg0.SetDelete() );
    break;
  case CSeq_submit::C_Data::e_Entrys:
    for (auto pEntry : arg0.SetEntrys()) {
        BasicCleanupSeqEntry(*pEntry);
    }
    break;
  default:
    break;
  }
} // end of x_BasicCleanupSeqSubmit_data


void CAutogeneratedCleanup::x_BasicCleanupCitSub( CCit_sub & arg0, bool in_submit_block )
{ // type Sequence
  if( arg0.IsSetAuthors() ) {
    x_BasicCleanupAuthList(arg0.SetAuthors(), in_submit_block);
  }
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate( arg0.SetDate() );
  }
  if( arg0.IsSetImp() ) {
    x_BasicCleanupImprint( arg0.SetImp() );
  }
} // end of x_BasicCleanupSeqSubmit_sub_sub_cit_cit


void CAutogeneratedCleanup::x_BasicCleanupContactInfo( CContact_info & arg0 )
{ // type Sequence
  if( arg0.IsSetContact() ) {
    x_BasicCleanupAuthor( arg0.SetContact() );
  }
} // end of x_BasicCleanupContactInfo


void CAutogeneratedCleanup::x_BasicCleanupSeqSubmit_sub( CSubmit_block & arg0 )
{ // type Sequence
  if( arg0.IsSetCit() ) {
    const bool in_submit_block = true;
    x_BasicCleanupCitSub( arg0.SetCit(), in_submit_block);
  }
  if( arg0.IsSetContact() ) {
    x_BasicCleanupContactInfo( arg0.SetContact() );
  }
  if( arg0.IsSetReldate() ) {
    x_BasicCleanupDate( arg0.SetReldate() );
  }
} // end of x_BasicCleanupSeqSubmit_sub_sub


void CAutogeneratedCleanup::BasicCleanupSeqSubmit( CSeq_submit & arg0 )
{ // type Sequence
  if( arg0.IsSetData() ) {
    x_BasicCleanupSeqSubmit_data( arg0.SetData() );
  }
  if( arg0.IsSetSub() ) {
    x_BasicCleanupSeqSubmit_sub( arg0.SetSub() );
  }
} // end of BasicCleanupSeqSubmit


void CAutogeneratedCleanup::x_BasicCleanupBioseqSet_seq_set_E( CSeq_entry & arg0 )
{ // type Choice
  m_NewCleanup.EnteringEntry( arg0 );
  m_NewCleanup.x_CopyGBBlockDivToOrgnameDiv( arg0 );
  switch( arg0.Which() ) {
  case CSeq_entry::e_Seq:
    BasicCleanupBioseq( arg0.SetSeq() );
    break;
  case CSeq_entry::e_Set:
    BasicCleanupBioseqSet( arg0.SetSet() );
    break;
  default:
    break;
  }
  m_NewCleanup.LeavingEntry( arg0 );
} // end of x_BasicCleanupBioseqSet_seq_set_E


template< typename Tcontainer_ncbi_cref_cseq_entry_ >
void CAutogeneratedCleanup::x_BasicCleanupBioseqSet_seq_set( Tcontainer_ncbi_cref_cseq_entry_ & arg0 )
{ // type UniSequence
  NON_CONST_ITERATE( typename Tcontainer_ncbi_cref_cseq_entry_, iter, arg0 ) {
    x_BasicCleanupBioseqSet_seq_set_E( **iter );
  }
} // end of x_BasicCleanupBioseqSet_seq_set

void CAutogeneratedCleanup::BasicCleanupBioseqSet( CBioseq_set & arg0 )
{ // type Sequence
  m_NewCleanup.SeqsetBC( arg0 );
  if( arg0.IsSetAnnot() ) {
    x_BasicCleanupSeqAnnots( arg0.SetAnnot() );
  }
  if( arg0.IsSetDate() ) {
    x_BasicCleanupDate( arg0.SetDate() );
  }
  if( arg0.IsSetDescr() ) {
    x_BasicCleanupBioseqSet_descr_ETC( arg0.SetDescr() );
  }
  if( arg0.IsSetSeq_set() ) {
    x_BasicCleanupBioseqSet_seq_set( arg0.SetSeq_set() );
  }
  m_NewCleanup.x_ClearEmptyDescr( arg0 );
} // end of BasicCleanupBioseqSet
//LCOV_EXCL_STOP

END_SCOPE(objects)
END_SCOPE(ncbi)

