.\" $Id: nasd.conf.man 268 2007-11-10 23:41:22Z jon13 $
.TH NASD.CONF 5 "" "NAS"
.SH NAME
nasd.conf \- Configuration file for NAS servers.
.SH DESCRIPTION
.I nasd.conf
Is a file that can be used to configure the behaiviour of the NAS
server, including what devices it will attempt to use, the minimum & maximum
frequencies used, if the device should be used in 8bit or 16bit mode, what
fragment size and number of fragments should be used (useful for tuning the
server's latency) and if the server should be verbose when starting or
output debugging information. Not all options are supported for all
servers, see the \fI/etc/nas/nasd.conf.eg\fP file for information on what
options are supported for which servers.
.SH "THE CONFIG FILE SYNTAX"
There are up to three section in the config file. The first section
deals with global options, some of which just turn on verbose messages
when parsing the config file, and setting debug messages on. The
remaining two sections will, if present, adjust various parameters of
the input and output devices, for those servers that understand them.
.PP
.B verbose
Sets a flag telling the server to report what it's trying to do with each
setting in the config file. This option is \fBoff\fP by default.
.PP
.B debug <number>
Sets the debug flag, which will provide a trace of the server's activities
on stderr. Set <number> to \fB0\fP to disable debug messages, \fB99\fP for
*alot* of debug messages. This option defaults to \fB0\fP.
.PP
.B ReleaseDevice "YES" | "NO"
Set to \fBYES\fP or \fBNO\fP. Defines whether the server should release the
audio device when finished playing or recording a sound. This option defaults
to \fBYES\fP. (voxware, hpux, sun)
.PP
.B KeepMixer "YES" | "NO"
Set to \fBYES\fP or \fBNO\fP.
Defines whether the server should keep the mixer open when releasing the
audio device. Without an open mixer device the server will always report
the default gain and line mode and cannot change them either. This option
defaults to \fBYES\fP. (voxware)
.PP
.B MixerInit "YES" | "NO"
Set to \fBYES\fP or \fBNO\fP. Defines whether the server will init the mixer
device on startup. Later changes of gain or input mode will change the
mixer settings. This option defaults to \fBNO\fP. (voxware)
.PP
.B ReInitMixer "YES" | "NO"
Set to \fBYES\fP or \fBNO\fP. Defines whether the server will re-init the mixer
device on every audio device open. The mixer is re-initialized only if it is
initialized at startup (see \fBMixerInit\fR option). This option defaults
to \fBNO\fP. (voxware)
.PP
.B OutDevType "EXT" | "INT"
For HPUX servers, define to \fBEXT\fP to use the external output device
(headphone/speakers) or \fBINT\fP for the internal output device (internal
speaker). Defaults to \fBEXT\fP.
.PP
.B outputsection
Marks the beginning of the output section, which allows various parameters
of the output device to be set up.
.PP
.B inputsection
Marks the beginning of the input section, which allows various parameters
of the input device to be set up.
.PP
.B end
Marks the end of the input section or output section.
.PP
.B device <devname>
Specifies what device is used. An example is \fBdevice "/dev/dsp"\fR.
With the voxware server you can use the empty string \fB""\fP to disable
the device.
.PP
.B mixer <mixername>
Specifies what mixer device is used. An example is \fBmixer "/dev/mixer"\fR.
If <mixername> is set to the empty string \fB""\fR no mixer is used in
this section.
.PP
.B gain <number>
Specifies the default volume (\fB0\fP\-\fB100\fP). The default is \fB50\fP.
.PP
.B gainscale <number>
This factor (expressed as a percentage) is applied to all volume-setting
requests. This lets the server transparently limit the actual
maximum volume that can be set by clients. The default is \fB100\fP.
.PP
.B maxrate <number>
The maximum number of samples per second that we'll drive the
card at.
.PP
.B minrate <number>
The minimum number of samples per second that the card will be driven
at.
.PP
.B maxfrags <number>
The maximum number of of kernel buffers that will be used for the device.
the number is dynamically adjusted as the sampling frequency varies.
.PP
.B minfrags <number>
The minimum number of kernel buffers that will be used.
.PP
.B fragsize <number>
The size of each buffer - note that the size must be a power of 2.
.PP
.B wordsize <number>
The number of bits per sample. Allowable values are \fB8\fP and \fB16\fP.
.PP
.B numchans <number>
Used to decide if the card is run in stereo or mono mode. Allowable
values are \fB1\fP or \fB2\fP.

.PP
.B forcerate "no" | "yes"
Forces the output rate to the current rate. The default is \fBno\fP.
.PP
.B autoOpen "no" | "yes"
Whether to open the device at init time (if \fBReleaseDevice\fP = \fBno\fP).
The default is \fByes\fP.
.PP
.B readwrite "no" | "yes"
Whether or not to open the device read\-write. The default is \fBno\fP.
If set to \fByes\fP, then the device will be opened read\-write. There
should be no need to set this to \fByes\fP, but...
.SH "SEE ALSO"
nas(1), nasd(1), auinfo(1), auplay(1), auctl(1)
.SH BUGS
.PP
Absolutely none.
.SH AUTHORS
Stephen Hocking (sysseh@devetir.qld.gov.au), 
Jon Trulson (jon@radscan.com)
