/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.reporting.html;

import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.FormattingContext;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;
import com.jcoverage.reporting.html.ColumnRenderer;
import com.jcoverage.reporting.html.DefaultColumnRenderer;
import com.jcoverage.reporting.html.Writable;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReportTable
implements Writable {
    static Logger logger = Logger.getLogger((Class)(class$com$jcoverage$reporting$html$ReportTable == null ? (class$com$jcoverage$reporting$html$ReportTable = ReportTable.class$("com.jcoverage.reporting.html.ReportTable")) : class$com$jcoverage$reporting$html$ReportTable));
    public static final ColumnRenderer DEFAULT_COLUMN_RENDERER = new DefaultColumnRenderer();
    Page page;
    Set records;
    Column[] columns;
    FormattingContext ctx;
    ColumnRenderer[] columnRenderers;
    Map registeredDefaultColumnRenderers = new HashMap();
    static /* synthetic */ Class class$com$jcoverage$reporting$html$ReportTable;

    public ReportTable(Page page, Set records, Column[] columns, FormattingContext ctx) {
        this.page = page;
        this.records = records;
        this.columns = columns;
        this.ctx = ctx;
        this.columnRenderers = new ColumnRenderer[columns.length];
    }

    public void setColumnRenderer(Column column, ColumnRenderer renderer) {
        this.registeredDefaultColumnRenderers.put(column, renderer);
    }

    public void setColumnRenderer(Column column, ColumnRenderer renderer, int colnum) {
        if (!this.columns[colnum].equals(column)) {
            throw new IllegalArgumentException("Column number does not correspond to given column. Given column is " + column + " but column number corresponds to column " + this.columns[colnum]);
        }
        this.columnRenderers[colnum] = renderer;
    }

    void fillColumnRenderers() {
        for (int i = 0; i < this.columnRenderers.length; ++i) {
            if (this.columnRenderers[i] != null) continue;
            ColumnRenderer defaultColumnRenderer = (ColumnRenderer)this.registeredDefaultColumnRenderers.get(this.columns[i]);
            this.columnRenderers[i] = defaultColumnRenderer != null ? defaultColumnRenderer : DEFAULT_COLUMN_RENDERER;
        }
    }

    public void writeTo(PrintWriter writer) {
        this.fillColumnRenderers();
        writer.println("<table cellpadding=\"2\" cellspacing=\"0\" width=\"85%\">");
        writer.print("<tr>");
        for (int i = 0; i < this.columns.length; ++i) {
            this.columnRenderers[i].renderTitle(this.ctx, writer, this.columns[i], i == this.columns.length - 1);
        }
        writer.println("</tr>");
        int rownum = 0;
        Iterator it = this.records.iterator();
        while (it.hasNext()) {
            String cssClass = rownum % 2 == 0 ? "yin" : "yang";
            ++rownum;
            Line line = (Line)it.next();
            Page detail = line.getDetailPage();
            String href = null;
            if (detail != null) {
                href = this.ctx.getCollator().getPathToPage(this.ctx, detail, this.page);
            }
            writer.println("<tr class=\"" + cssClass + "\">");
            for (int i = 0; i < this.columns.length; ++i) {
                this.columnRenderers[i].renderField(this.ctx, writer, this.columns[i], line, href);
            }
            writer.println("</tr>");
        }
        writer.println("</table>");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

