# -*- coding: utf-8 -*-
#
# «MPlayerHandler» - MPlayer Application lirc creator
#
# Copyright (C) 2007, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 3 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuLircGenerator.core import ProgramHandler

class MPlayerHandler(ProgramHandler):
    def __init__(self,lircd, lircrc,repeat,delay):
        application_name="mplayer"
        application_dictionary={ \
        "ok":"pause", \
        "vol-":"volume -1", \
        "vol+":"volume +1", \
        "forward":"seek +30 0", \
        "rewind":"seek -30 0", \
        "skip":"seek +15 0", \
        "replay":"seek -15 0", \
        "pause":"pause",\
        "up":"seek +60 0", \
        "down":"seek -60 0", \
        "right":"seek +6 0", \
        "left":"seek -6 0", \
        "enter":"pause", \
        "mute":"mute", \
        "play":"pause", \
        "power":"quit", \
        "stop":"quit", \
        "home":"vo_fullscreen" \
        }
        ProgramHandler.__init__(self,application_name,application_dictionary,lircd,lircrc,repeat,delay)
