/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "mforms/mforms.h"
#include "wf_view.h"
#include "wf_checkbox.h"

using namespace MySQL;
using namespace MySQL::Forms;
using namespace MySQL::Utilities;

//--------------------------------------------------------------------------------------------------

bool CheckBoxImpl::create(mforms::CheckBox *self, bool square)
{
  CheckBoxImpl ^cb = gcnew CheckBoxImpl(self);

  if (cb != nullptr)
  {
    CheckBox^ box = ViewImpl::create<CheckBox>(self, cb);
    box->ForeColor = System::Drawing::Color::Black;
    box->Click += gcnew System::EventHandler(&CheckBoxImpl::click);
    if (square)
      box->Appearance = Appearance::Button;

    return true;
  }
  return false;
}

//--------------------------------------------------------------------------------------------------

void CheckBoxImpl::click(System::Object ^sender, System::EventArgs ^e)
{
  Windows::Forms::CheckBox^ box = (Windows::Forms::CheckBox^)sender;

  if (box->Tag != nullptr)
  {
    mforms::Button* button = ViewImpl::get_backend_control<mforms::Button>(box);
    if (button != 0)
      button->callback();
  }
}

//--------------------------------------------------------------------------------------------------

void CheckBoxImpl::set_active(mforms::CheckBox *self, bool flag)
{
  CheckBoxImpl^ box = (CheckBoxImpl^)ObjectImpl::FromUnmanaged(self);

  if (box != nullptr)
    box->get_control<CheckBox>()->Checked = flag;
}

//--------------------------------------------------------------------------------------------------

bool CheckBoxImpl::get_active(mforms::CheckBox *self)
{
  CheckBoxImpl^ box = (CheckBoxImpl^)ObjectImpl::FromUnmanaged(self);

  if (box != nullptr)
    return box->get_control<CheckBox>()->Checked;
  return false;
}

//--------------------------------------------------------------------------------------------------

CheckBoxImpl::CheckBoxImpl(mforms::CheckBox *cbox)
  : ButtonImpl(cbox)
{
}

//--------------------------------------------------------------------------------------------------
