//
// Authors:
//   Atsushi Enomoto
//
// Copyright 2007 Novell (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using System.Linq;
using System.Xml;

namespace System.Xml.Linq
{
	public class XComment : XNode
	{
		string value;

		public XComment (string value)
		{
			this.value = value;
		}

		public XComment (XComment other)
		{
			this.value = other.value;
		}

		public override XmlNodeType NodeType {
			get { return XmlNodeType.Comment; }
		}

		public string Value {
			get { return value; }
			set { this.value = value; }
		}

		public override void WriteTo (XmlWriter writer)
		{
			var v = value.Replace ("--", "- -");
			v = v.LastOrDefault () == '-' ? v.Substring (0, v.Length - 1) +"&#2D;" : v;
			writer.WriteComment (v);
		}
	}
}
