# MongoDB Voluntary Product Accessibility Template® (VPAT™)

Contact for more Information: https://www.mongodb.com/contact

## Summary Table


|Criteria|Supporting Features|Remarks and explanations|
|---|---|---|
|Section 1194.21 Software Applications and Operating Systems|Product has been coded to meet this standard subject to the remarks on the right.||
|Section 1194.22 Web-based Internet Information and Applications|Product has been coded to meet this standard subject to the remarks on the right.||
|Section 1194.23 Telecommunications Products|Not Applicable||
|Section 1194.24 Video and Multi-media Products|Not Applicable||
|Section 1194.25 Self-Contained, Closed Products|Not Applicable||
|Section 1194.26 Desktop and Portable Computers|Not Applicable||
|Section 1194.31 Functional Performance Criteria|Product has been coded to meet this standard subject to the remarks on the right.||
|Section 1194.41 Information, Documentation and Support|Product has been coded to meet this standard subject to the remarks on the right.||

## Section 1194.21 Software Applications and Operating Systems – Detail
 
|Criteria |Supporting Features|Remarks and explanations|
|---|---|---|
|(a) When software is designed to run on a system that has a keyboard, product functions shall be executable from a keyboard where the function itself or the result of performing a function can be discerned textually.|Product has been coded to meet this standard subject to the remarks on the right.|All functions can be executed from the keyboard.|
|(b) Applications shall not disrupt or disable activated features of other products that are identified as accessibility features, where those features are developed and documented according to industry standards. Applications also shall not disrupt or disable activated features of any operating system that are identified as accessibility features where the application programming interface for those accessibility features has been documented by the manufacturer of the operating system and is available to the product developer.|Product has been coded to meet this standard subject to the remarks on the right.|Does not interfere with Mouse Keys, Sticky Keys, Filter Keys or Toggle Keys.|
|(c\) A well-defined on-screen indication of the current focus shall be provided that moves among interactive interface elements as the input focus changes. The focus shall be programmatically exposed so that Assistive Technology can track focus and focus changes.|Product has been coded to meet this standard subject to the remarks on the right.|Focus is programmatically exposed.|
|(d) Sufficient information about a user interface element including the identity, operation and state of the element shall be available to Assistive Technology. When an image represents a program element, the information conveyed by the image must also be available in text.|Product has been coded to meet this standard subject to the remarks on the right.|Information about each UI element is programmatically exposed.|
|(e) When bitmap images are used to identify controls, status indicators, or other programmatic elements, the meaning assigned to those images shall be consistent throughout an application's performance.|Product has been coded to meet this standard subject to the remarks on the right.|Does not use bitmap images.|
|(f) Textual information shall be provided through operating system functions for displaying text. The minimum information that shall be made available is text content, text input caret location, and text attributes.|Product has been coded to meet this standard subject to the remarks on the right.|Information about each UI element is programmatically exposed.|
|(g) Applications shall not override user selected contrast and color selections and other individual display attributes.|Product has been coded to meet this standard subject to the remarks on the right.|Windows or other OS-level color settings are not over-ruled by product.|
|(h) When animation is displayed, the information shall be displayable in at least one non-animated presentation mode at the option of the user.|Product has been coded to meet this standard subject to the remarks on the right.|Does not use animation in UI.|
|(i) Color coding shall not be used as the only means of conveying information, indicating an action, prompting a response, or distinguishing a visual element.|Product has been coded to meet this standard subject to the remarks on the right.|Color coding is not used.|
|(j) When a product permits a user to adjust color and contrast settings, a variety of color selections capable of producing a range of contrast levels shall be provided.|Product has been coded to meet this standard subject to the remarks on the right.|Does not permit use to adjust color and contrast settings. |
|(k) Software shall not use flashing or blinking text, objects, or other elements having a flash or blink frequency greater than 2 Hz and lower than 55 Hz.|Product has been coded to meet this standard subject to the remarks on the right. |There is no instance of blinking or flashing objects that are within the danger range of 2hz to 55hz.|
|(l) When electronic forms are used, the form shall allow people using Assistive Technology to access the information, field elements, and functionality required for completion and submission of the form, including all directions and cues.|Product has been coded to meet this standard subject to the remarks on the right.|All functions can be executed from the keyboard.|

## Section 1194.22 Web-based Internet information and applications – Detail
 
|Criteria |Supporting Features|Remarks and explanations|
|---|---|---|
|(a) A text equivalent for every non-text element shall be provided (e.g., via "alt", "longdesc", or in element content).|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/.|
|(b) Equivalent alternatives for any multimedia presentation shall be synchronized with the presentation.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/.|
|(c\) Web pages shall be designed so that all information conveyed with color is also available without color, for example from context or markup.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(d) Documents shall be organized so they are readable without requiring an associated style sheet.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(e) Redundant text links shall be provided for each active region of a server-side image map.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(f) Client-side image maps shall be provided instead of server-side image maps except where the regions cannot be defined with an available geometric shape.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(g) Row and column headers shall be identified for data tables.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(h) Markup shall be used to associate data cells and header cells for data tables that have two or more logical levels of row or column headers.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(i) Frames shall be titled with text that facilitates frame identification and navigation|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(j) Pages shall be designed to avoid causing the screen to flicker with a frequency greater than 2 Hz and lower than 55 Hz.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(k) A text-only page, with equivalent information or functionality, shall be provided to make a web site comply with the provisions of this part, when compliance cannot be accomplished in any other way. The content of the text-only page shall be updated whenever the primary page changes.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/.|
|(l) When pages utilize scripting languages to display content, or to create interface elements, the information provided by the script shall be identified with functional text that can be read by Assistive Technology.|Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(m) When a web page requires that an applet, plug-in or other application be present on the client system to interpret page content, the page must provide a link to a plug-in or applet that complies with §1194.21(a) through (l). |Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(n) When electronic forms are designed to be completed on-line, the form shall allow people using Assistive Technology to access the information, field elements, and functionality required for completion and submission of the form, including all directions and cues. |Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(o) A method shall be provided that permits users to skip repetitive navigation links. |Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |
|(p\) When a timed response is required, the user shall be alerted and given sufficient time to indicate more time is required. |Core MongoDB documentation has been coded to meet this standard subject to the remarks on the right. |Our documentation complies to this criteria and can be found at https://docs.mongodb.com/manual/. |

### Note to 1194.22
The Board interprets paragraphs (a) through (k) of this section as consistent with the following 
priority 1 Checkpoints of the Web Content Accessibility Guidelines 1.0 (WCAG 1.0) (May 5 1999) published by the Web 
Accessibility Initiative of the World Wide Web Consortium: Paragraph (a) - 1.1, (b) - 1.4, (c\) - 2.1, (d) - 6.1, 
(e) - 1.2, (f) - 9.1, (g) - 5.1, (h) - 5.2, (i) - 12.1, (j) - 7.1, (k) - 11.4.

## Section 1194.23 Telecommunications Products – Detail

|Criteria |Supporting Features|Remarks and explanations|
|---|---|---|
|(a) Telecommunications products or systems which provide a function allowing voice communication and which do not themselves provide a TTY functionality shall provide a standard non-acoustic connection point for TTYs. Microphones shall be capable of being turned on and off to allow the user to intermix speech with TTY use.|Not Applicable||
|(b) Telecommunications products which include voice communication functionality shall support all commonly used cross-manufacturer non-proprietary standard TTY signal protocols.|Not Applicable||
|(c\) Voice mail, auto-attendant, and interactive voice response telecommunications systems shall be usable by TTY users with their TTYs.|Not Applicable||
|(d) Voice mail, messaging, auto-attendant, and interactive voice response telecommunications systems that require a response from a user within a time interval, shall give an alert when the time interval is about to run out, and shall provide sufficient time for the user to indicate more time is required.|Not Applicable||
|(e) Where provided, caller identification and similar telecommunications functions shall also be available for users of TTYs, and for users who cannot see displays.|Not Applicable||
|(f) For transmitted voice signals, telecommunications products shall provide a gain adjustable up to a minimum of 20 dB. For incremental volume control, at least one intermediate step of 12 dB of gain shall be provided.|Not Applicable||
|(g) If the telecommunications product allows a user to adjust the receive volume, a function shall be provided to automatically reset the volume to the default level after every use.|Not Applicable||
|(h) Where a telecommunications product delivers output by an audio transducer which is normally held up to the ear, a means for effective magnetic wireless coupling to hearing technologies shall be provided.|Not Applicable||
|(i) Interference to hearing technologies (including hearing aids, cochlear implants, and assistive listening devices) shall be reduced to the lowest possible level that allows a user of hearing technologies to utilize the telecommunications product.|Not Applicable||
|(j) Products that transmit or conduct information or communication, shall pass through cross-manufacturer, non-proprietary, industry-standard codes, translation protocols, formats or other information necessary to provide the information or communication in a usable format. Technologies which use encoding, signal compression, format transformation, or similar techniques shall not remove information needed for access or shall restore it upon delivery.|Not Applicable||
|(k)(1) Products which have mechanically operated controls or keys shall comply with the following: Controls and Keys shall be tactilely discernible without activating the controls or keys.|Not Applicable||
|(k)(2) Products which have mechanically operated controls or keys shall comply with the following: Controls and Keys shall be operable with one hand and shall not require tight grasping, pinching, twisting of the wrist. The force required to activate controls and keys shall be 5 lbs. (22.2N) maximum.|Not Applicable||
|(k)(3) Products which have mechanically operated controls or keys shall comply with the following: If key repeat is supported, the delay before repeat shall be adjustable to at least 2 seconds. Key repeat rate shall be adjustable to 2 seconds per character.|Not Applicable||
|(k)(4) Products which have mechanically operated controls or keys shall comply with the following: The status of all locking or toggle controls or keys shall be visually discernible, and discernible either through touch or sound.|Not Applicable||

## Section 1194.24 Video and Multi-media Products – Detail

|Criteria|Supporting Features|Remarks and explanations|
|---|---|---|
|(a) All analog television displays 13 inches and larger, and computer equipment that includes analog television receiver or display circuitry, shall be equipped with caption decoder circuitry which appropriately receives, decodes, and displays closed captions from broadcast, cable, videotape, and DVD signals. As soon as practicable, but not later than July 1, 2002, widescreen digital television (DTV) displays measuring at least 7.8 inches vertically, DTV sets with conventional displays measuring at least 13 inches vertically, and stand-alone DTV tuners, whether or not they are marketed with display screens, and computer equipment that includes DTV receiver or display circuitry, shall be equipped with caption decoder circuitry which appropriately receives, decodes, and displays closed captions from broadcast, cable, videotape, and DVD signals.|Not Applicable||
|(b) Television tuners, including tuner cards for use in computers, shall be equipped with secondary audio program playback circuitry.|Not Applicable||
|(c\) All training and informational video and multimedia productions which support the agency's mission, regardless of format, that contain speech or other audio information necessary for the comprehension of the content, shall be open or closed captioned.|Not Applicable||
|(d) All training and informational video and multimedia productions which support the agency's mission, regardless of format, that contain visual information necessary for the comprehension of the content, shall be audio described.|Not Applicable||
|(e) Display or presentation of alternate text presentation or audio descriptions shall be user-selectable unless permanent.|Not Applicable||

## Section 1194.25 Self-Contained, Closed Products – Detail
 
|Criteria |Supporting Features|Remarks and explanations|
|---|---|---|
|(a) Self contained products shall be usable by people with disabilities without requiring an end-user to attach Assistive Technology to the product. Personal headsets for private listening are not Assistive Technology.|Not Applicable||
|(b) When a timed response is required, the user shall be alerted and given sufficient time to indicate more time is required.|Not Applicable||
|(c\) Where a product utilizes touchscreens or contact-sensitive controls, an input method shall be provided that complies with §1194.23 (k) (1) through (4).|Not Applicable||
|(d) When biometric forms of user identification or control are used, an alternative form of identification or activation, which does not require the user to possess particular biological characteristics, shall also be provided.|Not Applicable||
|(e) When products provide auditory output, the audio signal shall be provided at a standard signal level through an industry standard connector that will allow for private listening. The product must provide the ability to interrupt, pause, and restart the audio at anytime.|Not Applicable||
|(f) When products deliver voice output in a public area, incremental volume control shall be provided with output amplification up to a level of at least 65 dB. Where the ambient noise level of the environment is above 45 dB, a volume gain of at least 20 dB above the ambient level shall be user selectable. A function shall be provided to automatically reset the volume to the default level after every use.|Not Applicable||
|(g) Color coding shall not be used as the only means of conveying information, indicating an action, prompting a response, or distinguishing a visual element.|Not Applicable||
|(h) When a product permits a user to adjust color and contrast settings, a range of color selections capable of producing a variety of contrast levels shall be provided.|Not Applicable||
|(i) Products shall be designed to avoid causing the screen to flicker with a frequency greater than 2 Hz and lower than 55 Hz.|Not Applicable||
|(j)(1) Products which are freestanding, non-portable, and intended to be used in one location and which have operable controls shall comply with the following: The position of any operable control shall be determined with respect to a vertical plane, which is 48 inches in length, centered on the operable control, and at the maximum protrusion of the product within the 48 inch length on products which are freestanding, non-portable, and intended to be used in one location and which have operable controls.|Not Applicable||
|(j)(2) Products which are freestanding, non-portable, and intended to be used in one location and which have operable controls shall comply with the following: Where any operable control is 10 inches or less behind the reference plane, the height shall be 54 inches maximum and 15 inches minimum above the floor.|Not Applicable||
|(j)(3) Products which are freestanding, non-portable, and intended to be used in one location and which have operable controls shall comply with the following: Where any operable control is more than 10 inches and not more than 24 inches behind the reference plane, the height shall be 46 inches maximum and 15 inches minimum above the floor.|Not Applicable||
|(j)(4) Products which are freestanding, non-portable, and intended to be used in one location and which have operable controls shall comply with the following: Operable controls shall not be more than 24 inches behind the reference plane.|Not Applicable||

## Section 1194.26 Desktop and Portable Computers – Detail
 
|Criteria|Supporting Features|Remarks and explanations|
|---|---|---|
|(a) All mechanically operated controls and keys shall comply with §1194.23 (k) (1) through (4).|Not Applicable||
|(b) If a product utilizes touchscreens or touch-operated controls, an input method shall be provided that complies with §1194.23 (k) (1) through (4).|Not Applicable||
|(c\) When biometric forms of user identification or control are used, an alternative form of identification or activation, which does not require the user to possess particular biological characteristics, shall also be provided.|Not Applicable||
|(d) Where provided, at least one of each type of expansion slots, ports and connectors shall comply with publicly available industry standards|Not Applicable||

## Section 1194.31 Functional Performance Criteria – Detail
 
|Criteria|Supporting Features|Remarks and explanations|
|---|---|---|
|(a) At least one mode of operation and information retrieval that does not require user vision shall be provided, or support for Assistive Technology used by people who are blind or visually impaired shall be provided.|Applicable|All user operation of the product are compatible with Assistive Technology.|
|(b) At least one mode of operation and information retrieval that does not require visual acuity greater than 20/70 shall be provided in audio and enlarged print output working together or independently, or support for Assistive Technology used by people who are visually impaired shall be provided.|Applicable|All user operation of the product are compatible with Assistive Technology.|
|(c\) At least one mode of operation and information retrieval that does not require user hearing shall be provided, or support for Assistive Technology used by people who are deaf or hard of hearing shall be provided|Not Applicable|There is no reliance on user hearing.|
|(d) Where audio information is important for the use of a product, at least one mode of operation and information retrieval shall be provided in an enhanced auditory fashion, or support for assistive hearing devices shall be provided.|Not Applicable|There is no reliance on sound.|
|(e) At least one mode of operation and information retrieval that does not require user speech shall be provided, or support for Assistive Technology used by people with disabilities shall be provided.|Not Applicable|There is no reliance on user speech.|
|(f) At least one mode of operation and information retrieval that does not require fine motor control or simultaneous actions and that is operable with limited reach and strength shall be provided.|Not Applicable|There is no reliance on fine motor control.|

## Section 1194.41 Information, Documentation and Support – Detail
 
|Criteria|Supporting Features|Remarks and explanations|
|---|---|---| 
|(a) Product support documentation provided to end-users shall be made available in alternate formats upon request, at no additional charge| Support documentation for this product is available in accessible electronic format or print format.| MongoDB documentation is available online: http://docs.mongodb.org/manual/. Alternately, users may, from the same link, access the documentation as single page HTML, epub or PDF format. There is no additional charge for these alternate formats.|
|(b) End-users shall have access to a description of the accessibility and compatibility features of products in alternate formats or alternate methods upon request, at no additional charge.|Description is available in accessible electronic format online. |Information regarding accessibility and compatibility features are available online: https://www.mongodb.com/accessibility/vpat Links to alternative formats may also be contained online, as applicable. There is no additional charge for these alternate formats.|
|(c\) Support services for products shall accommodate the communication needs of end-users with disabilities.|MongoDB, Inc.'s support services via web support https://support.mongodb.com/ . | MongoDB, Inc. customers primarily use SalesForce Service Cloud for communications with support. SalesForce Service Cloud delivers content via a web interface that is accessible to existing screen readers. SalesForce Service Cloud has a VPAT located at http://www.sfdcstatic.com/assets/pdf/misc/VPAT_servicecloud_summer2013.pdf .|
