"use strict";

var helpers = require("../helpers/helpers");

exports["NZ-CHAT"] = {

	"guess:by:offset" : helpers.makeTestGuess("NZ-CHAT", { offset: true, expect: "Pacific/Chatham" }),

	"guess:by:abbr" : helpers.makeTestGuess("NZ-CHAT", { abbr: true, expect: "Pacific/Chatham" }),

	"1945" : helpers.makeTestYear("NZ-CHAT", [
		["1945-12-31T11:44:59+00:00", "23:59:59", "+1215", -735],
		["1945-12-31T11:45:00+00:00", "00:30:00", "+1245", -765]
	]),

	"1974" : helpers.makeTestYear("NZ-CHAT", [
		["1974-11-02T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1974-11-02T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1975" : helpers.makeTestYear("NZ-CHAT", [
		["1975-02-22T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1975-02-22T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1975-10-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1975-10-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1976" : helpers.makeTestYear("NZ-CHAT", [
		["1976-03-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1976-03-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1976-10-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1976-10-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1977" : helpers.makeTestYear("NZ-CHAT", [
		["1977-03-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1977-03-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1977-10-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1977-10-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1978" : helpers.makeTestYear("NZ-CHAT", [
		["1978-03-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1978-03-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1978-10-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1978-10-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1979" : helpers.makeTestYear("NZ-CHAT", [
		["1979-03-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1979-03-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1979-10-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1979-10-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1980" : helpers.makeTestYear("NZ-CHAT", [
		["1980-03-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1980-03-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1980-10-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1980-10-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1981" : helpers.makeTestYear("NZ-CHAT", [
		["1981-02-28T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1981-02-28T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1981-10-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1981-10-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1982" : helpers.makeTestYear("NZ-CHAT", [
		["1982-03-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1982-03-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1982-10-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1982-10-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1983" : helpers.makeTestYear("NZ-CHAT", [
		["1983-03-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1983-03-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1983-10-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1983-10-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1984" : helpers.makeTestYear("NZ-CHAT", [
		["1984-03-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1984-03-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1984-10-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1984-10-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1985" : helpers.makeTestYear("NZ-CHAT", [
		["1985-03-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1985-03-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1985-10-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1985-10-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1986" : helpers.makeTestYear("NZ-CHAT", [
		["1986-03-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1986-03-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1986-10-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1986-10-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1987" : helpers.makeTestYear("NZ-CHAT", [
		["1987-02-28T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1987-02-28T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1987-10-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1987-10-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1988" : helpers.makeTestYear("NZ-CHAT", [
		["1988-03-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1988-03-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1988-10-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1988-10-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1989" : helpers.makeTestYear("NZ-CHAT", [
		["1989-03-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1989-03-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1989-10-07T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1989-10-07T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1990" : helpers.makeTestYear("NZ-CHAT", [
		["1990-03-17T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1990-03-17T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1990-10-06T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1990-10-06T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1991" : helpers.makeTestYear("NZ-CHAT", [
		["1991-03-16T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1991-03-16T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1991-10-05T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1991-10-05T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1992" : helpers.makeTestYear("NZ-CHAT", [
		["1992-03-14T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1992-03-14T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1992-10-03T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1992-10-03T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1993" : helpers.makeTestYear("NZ-CHAT", [
		["1993-03-20T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1993-03-20T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1993-10-02T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1993-10-02T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1994" : helpers.makeTestYear("NZ-CHAT", [
		["1994-03-19T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1994-03-19T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1994-10-01T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1994-10-01T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1995" : helpers.makeTestYear("NZ-CHAT", [
		["1995-03-18T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1995-03-18T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1995-09-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1995-09-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1996" : helpers.makeTestYear("NZ-CHAT", [
		["1996-03-16T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1996-03-16T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1996-10-05T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1996-10-05T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1997" : helpers.makeTestYear("NZ-CHAT", [
		["1997-03-15T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1997-03-15T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1997-10-04T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1997-10-04T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1998" : helpers.makeTestYear("NZ-CHAT", [
		["1998-03-14T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1998-03-14T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1998-10-03T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1998-10-03T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"1999" : helpers.makeTestYear("NZ-CHAT", [
		["1999-03-20T13:59:59+00:00", "03:44:59", "+1345", -825],
		["1999-03-20T14:00:00+00:00", "02:45:00", "+1245", -765],
		["1999-10-02T13:59:59+00:00", "02:44:59", "+1245", -765],
		["1999-10-02T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2000" : helpers.makeTestYear("NZ-CHAT", [
		["2000-03-18T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2000-03-18T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2000-09-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2000-09-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2001" : helpers.makeTestYear("NZ-CHAT", [
		["2001-03-17T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2001-03-17T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2001-10-06T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2001-10-06T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2002" : helpers.makeTestYear("NZ-CHAT", [
		["2002-03-16T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2002-03-16T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2002-10-05T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2002-10-05T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2003" : helpers.makeTestYear("NZ-CHAT", [
		["2003-03-15T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2003-03-15T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2003-10-04T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2003-10-04T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2004" : helpers.makeTestYear("NZ-CHAT", [
		["2004-03-20T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2004-03-20T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2004-10-02T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2004-10-02T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2005" : helpers.makeTestYear("NZ-CHAT", [
		["2005-03-19T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2005-03-19T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2005-10-01T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2005-10-01T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2006" : helpers.makeTestYear("NZ-CHAT", [
		["2006-03-18T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2006-03-18T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2006-09-30T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2006-09-30T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2007" : helpers.makeTestYear("NZ-CHAT", [
		["2007-03-17T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2007-03-17T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2007-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2007-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2008" : helpers.makeTestYear("NZ-CHAT", [
		["2008-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2008-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2008-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2008-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2009" : helpers.makeTestYear("NZ-CHAT", [
		["2009-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2009-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2009-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2009-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2010" : helpers.makeTestYear("NZ-CHAT", [
		["2010-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2010-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2010-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2010-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2011" : helpers.makeTestYear("NZ-CHAT", [
		["2011-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2011-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2011-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2011-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2012" : helpers.makeTestYear("NZ-CHAT", [
		["2012-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2012-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2012-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2012-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2013" : helpers.makeTestYear("NZ-CHAT", [
		["2013-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2013-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2013-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2013-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2014" : helpers.makeTestYear("NZ-CHAT", [
		["2014-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2014-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2014-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2014-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2015" : helpers.makeTestYear("NZ-CHAT", [
		["2015-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2015-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2015-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2015-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2016" : helpers.makeTestYear("NZ-CHAT", [
		["2016-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2016-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2016-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2016-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2017" : helpers.makeTestYear("NZ-CHAT", [
		["2017-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2017-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2017-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2017-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2018" : helpers.makeTestYear("NZ-CHAT", [
		["2018-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2018-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2018-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2018-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2019" : helpers.makeTestYear("NZ-CHAT", [
		["2019-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2019-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2019-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2019-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2020" : helpers.makeTestYear("NZ-CHAT", [
		["2020-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2020-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2020-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2020-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2021" : helpers.makeTestYear("NZ-CHAT", [
		["2021-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2021-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2021-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2021-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2022" : helpers.makeTestYear("NZ-CHAT", [
		["2022-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2022-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2022-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2022-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2023" : helpers.makeTestYear("NZ-CHAT", [
		["2023-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2023-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2023-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2023-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2024" : helpers.makeTestYear("NZ-CHAT", [
		["2024-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2024-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2024-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2024-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2025" : helpers.makeTestYear("NZ-CHAT", [
		["2025-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2025-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2025-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2025-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2026" : helpers.makeTestYear("NZ-CHAT", [
		["2026-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2026-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2026-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2026-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2027" : helpers.makeTestYear("NZ-CHAT", [
		["2027-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2027-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2027-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2027-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2028" : helpers.makeTestYear("NZ-CHAT", [
		["2028-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2028-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2028-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2028-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2029" : helpers.makeTestYear("NZ-CHAT", [
		["2029-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2029-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2029-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2029-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2030" : helpers.makeTestYear("NZ-CHAT", [
		["2030-04-06T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2030-04-06T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2030-09-28T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2030-09-28T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2031" : helpers.makeTestYear("NZ-CHAT", [
		["2031-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2031-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2031-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2031-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2032" : helpers.makeTestYear("NZ-CHAT", [
		["2032-04-03T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2032-04-03T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2032-09-25T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2032-09-25T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2033" : helpers.makeTestYear("NZ-CHAT", [
		["2033-04-02T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2033-04-02T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2033-09-24T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2033-09-24T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2034" : helpers.makeTestYear("NZ-CHAT", [
		["2034-04-01T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2034-04-01T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2034-09-23T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2034-09-23T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2035" : helpers.makeTestYear("NZ-CHAT", [
		["2035-03-31T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2035-03-31T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2035-09-29T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2035-09-29T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2036" : helpers.makeTestYear("NZ-CHAT", [
		["2036-04-05T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2036-04-05T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2036-09-27T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2036-09-27T14:00:00+00:00", "03:45:00", "+1345", -825]
	]),

	"2037" : helpers.makeTestYear("NZ-CHAT", [
		["2037-04-04T13:59:59+00:00", "03:44:59", "+1345", -825],
		["2037-04-04T14:00:00+00:00", "02:45:00", "+1245", -765],
		["2037-09-26T13:59:59+00:00", "02:44:59", "+1245", -765],
		["2037-09-26T14:00:00+00:00", "03:45:00", "+1345", -825]
	])
};