package org.codehaus.modello.metadata;

/*
 * Copyright (c) 2004, Codehaus.org
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.ModelAssociation;
import org.codehaus.modello.model.ModelClass;
import org.codehaus.modello.model.ModelField;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

import java.util.Collections;
import java.util.Map;

/**
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: AbstractMetadataPlugin.java 1156 2009-01-24 21:46:37Z hboutemy $
 */
public abstract class AbstractMetadataPlugin
    extends AbstractLogEnabled
    implements MetadataPlugin
{
    // ----------------------------------------------------------------------
    // MetadataPlugin Implementation
    // ----------------------------------------------------------------------

    public Map getModelMap( Model model, ModelMetadata metadata )
        throws ModelloException
    {
        return Collections.EMPTY_MAP;
    }

    public Map getClassMap( ModelClass clazz, ClassMetadata metadata )
        throws ModelloException
    {
        return Collections.EMPTY_MAP;
    }

    public Map getFieldMap( ModelField field, FieldMetadata metadata )
        throws ModelloException
    {
        return Collections.EMPTY_MAP;
    }

    public Map getAssociationMap( ModelAssociation association, AssociationMetadata metadata )
        throws ModelloException
    {
        return Collections.EMPTY_MAP;
    }

    // ----------------------------------------------------------------------
    //
    // ----------------------------------------------------------------------

    protected boolean getBoolean( Map data, String key, boolean defaultValue )
    {
        String value = (String) data.get( key );

        if ( StringUtils.isEmpty( value ) )
        {
            return defaultValue;
        }

        return Boolean.valueOf( value ).booleanValue();
    }

    protected String getString( Map data, String key )
    {
        String value = (String) data.get( key );

        return StringUtils.isEmpty( value ) ? null : value;
    }
}
