/* 
  Copyright (C) 2008 Kai Hertel, André Gaul

	This file is part of mmpong.

	mmpong is free software: you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation, either version 3 of the License, or
	(at your option) any later version.

	mmpong is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with mmpong.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef __MESSAGE_HEADER__
#define __MESSAGE_HEADER__

#include <stdint.h>
#include <sys/time.h>
#include "game.h"
#include "dllhelper.h"


#ifdef __cplusplus
extern "C" {
#endif

#define NETMESSAGE_MAXLEN 256

#define NETMSG_SUCCESS 			0
#define NETMSG_ARGINVALID 		(-1)
#define NETMSG_PARTIAL 			(-2)
#define NETMSG_END_SOCKET 		(-3)
#define NETMSG_FAIL_DELIVER 	(-4)
#define NETMSG_FAIL_SOCKET 		(-5)
#define NETMSG_FAIL_CONVERT 	(-6)
#define NETMSG_FAIL_CHECKSUM 	(-7)
#define NETMSG_FAIL_SYSCRITICAL (-8)

enum netmessage_type {
	NETMSG_STAT= 's', 	// full game state
	NETMSG_UPDT= 'u', 	// game state update
	NETMSG_EXIT= 'e', 	// peer exits voluntarily
	NETMSG_KICK= 'k', 	// client session terminates
	NETMSG_POS=  'p'	// position update
};

// no padding for structures related to the net code
#pragma pack(push, 1)

struct netmessage_header {
	uint16_t id;
	uint16_t len;
	struct gametime_public stamp;
};

struct netmessage {
	struct netmessage_header hdr;
	union {
		char data[NETMESSAGE_MAXLEN -sizeof(struct netmessage_header)];
		struct game_state_full {
			uint16_t team;
			struct gameplay_public game;
		} full;
		struct game_state_part { 	// this one might need manual adjustments to stay in sync with `struct gameplay_public`
			struct gametime_public stamp; 	// time stamp
			struct gameball_public ball;
			struct gamepaddle_public pad[2];
		} part;
		uint16_t position;
	} payload;
};

#pragma pack(pop)

struct netmessage_buffer {
	uint16_t sz;
	struct netmessage msg;
	uint16_t pos, len;
};

EXPORT int netmessage_buffer_init(struct netmessage_buffer **);
EXPORT int netmessage_buffer_flush(const int, struct netmessage_buffer *);
EXPORT int netmessage_scrambler_init(void);
EXPORT int netmessage_send(const int, const enum netmessage_type, const void *, const uint16_t, struct netmessage_buffer *);
EXPORT int netmessage_recv(const int, struct netmessage *, const uint16_t, struct netmessage_buffer *);
EXPORT int netmessage_get_hdr_stamp(const struct netmessage *, struct timeval *);

#ifdef __cplusplus
}
#endif

#endif

