C **************************** LICENSE START ***********************************
C
C Copyright 2012 ECMWF and INPE. This software is distributed under the terms
C of the Apache License version 2.0. In applying this license, ECMWF does not
C waive the privileges and immunities granted to it by virtue of its status as
C an Intergovernmental Organization or submit itself to any jurisdiction.
C
C ***************************** LICENSE END ************************************

      SUBROUTINE TLVALID ( igrib_id1, igrib_id2,
     X                     LEVEL, LOK )
C
C          CHECK THAT GRIB SECTIONS 1 AND 2 ARE THE SAME
C          FOR 2 FIELDS EXCEPT FOR:
C              PARAMETER CODE
C              LEVEL (IF LOGICAL LEVEL IS FALSE)
C          RETURN LOGICAL LOK AS FALSE IF NO MATCH
C
C
      LOGICAL LOK,LEVEL,lcheck
      LOK=.TRUE.
C
C -------------------------------------------------------------------
C

      IF( .NOT. lcheck( igrib_id1, igrib_id2,
     x                 'numberOfPoints' )) goto 13
      IF( .NOT. lcheck( igrib_id1, igrib_id2, 'Ni' )) goto 13
      IF( .NOT. lcheck( igrib_id1, igrib_id2, 'Nj' )) goto 13
      IF( .NOT. lcheck( igrib_id1, igrib_id2,
     x                'latitudeOfFirstGridPointInDegrees' )) goto 13
      IF( .NOT. lcheck( igrib_id1, igrib_id2,
     x                'longitudeOfFirstGridPointInDegrees' )) goto 13
      IF( .NOT. lcheck( igrib_id1, igrib_id2,
     x                'scanningMode' )) goto 13
!      IF( .NOT. lcheck( igrib_id1, igrib_id2, 'gridType' )) goto 13
      IF( .NOT. lcheck( igrib_id1, igrib_id2, 'dataDate' )) goto 13
      IF( .NOT. lcheck( igrib_id1, igrib_id2, 'time' )) goto 13

      IF(LEVEL) THEN
         IF( .NOT. lcheck( igrib_id1, igrib_id2, 'levtype' )) goto 13
         IF( .NOT. lcheck( igrib_id1, igrib_id2, 'level' )) goto 13
      ENDIF

!      DO 111 K=1,5
!      IF(ISEC1T(K).NE.ISEC1L(K)) GO TO 300
!  111 CONTINUE
!      IF(ISEC1T(7).NE.ISEC1L(7)) GO TO 300
!      IF(LEVEL) THEN
!           IF(ISEC1T(8).NE.ISEC1L(8)) GO TO 300
!      ENDIF
!      DO 112 K=9,24
!      IF(ISEC1T(K).NE.ISEC1L(K)) GO TO 300
!  112 CONTINUE
!C
!      DO 122 K=1,12
!      IF(ISEC2T(K).NE.ISEC2L(K)) GO TO 300
!  122 CONTINUE
!C
!      DO 132 K=1,ISEC2T(12)+10
!      IF(ZSEC2T(K).NE.ZSEC2L(K)) GO TO 300
!  132 CONTINUE
C
      RETURN
C
C -------------------------------------------------------------------
C
   13 CONTINUE
      LOK=.FALSE.
      RETURN
      END

      LOGICAL FUNCTION lcheck( igrib_id1, igrib_id2, cname )

      use grib_api

      CHARACTER*(*) cname
      INTEGER ival1, ival2
      CHARACTER*(72) cerrmsg

      lcheck = .TRUE.
      CALL grib_get_int( igrib_id1, cname, ival1 )
      CALL grib_get_int( igrib_id2, cname, ival2 )
      IF( ival1 .ne. ival2 ) THEN
         cerrmsg = 'POTTF_ENV=Input fields not consistent: ' // cname
         JJ=cputenv( cerrmsg )
         lcheck = .FALSE.
      ENDIF

      RETURN
      END
